/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectoryPersistentCache.class.getName());
    private final File cacheDir;
    private final StringEncoder filenameEncoder;

    public SimpleDirectoryPersistentCache(File cacheDir) {
        this(cacheDir, Base32.getStringEncoder());
    }

    public SimpleDirectoryPersistentCache(File cacheDir, StringEncoder filenameEncoder) {
        if (!cacheDir.exists()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" does not exist");
        }
        if (!cacheDir.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + cacheDir + "\" is not a directory");
        }
        this.cacheDir = cacheDir;
        this.filenameEncoder = filenameEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String nodeVer, DiscoverInfo info) {
        File nodeFile = this.getFileFor(nodeVer);
        try {
            if (nodeFile.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(nodeFile, info);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to write disco info to file", e);
        }
    }

    @Override
    public DiscoverInfo lookup(String nodeVer) {
        File nodeFile = this.getFileFor(nodeVer);
        if (!nodeFile.isFile()) {
            return null;
        }
        DiscoverInfo info = null;
        try {
            info = SimpleDirectoryPersistentCache.restoreInfoFromFile(nodeFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Coud not restore info from file", e);
        }
        return info;
    }

    private File getFileFor(String nodeVer) {
        String filename = this.filenameEncoder.encode(nodeVer);
        return new File(this.cacheDir, filename);
    }

    @Override
    public void emptyCache() {
        File[] files = this.cacheDir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            f.delete();
        }
    }

    private static void writeInfoToFile(File file, DiscoverInfo info) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            dos.writeUTF(info.toXML(null).toString());
        }
    }

    private static DiscoverInfo restoreInfoFromFile(File file) throws Exception {
        String fileContent;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            fileContent = dis.readUTF();
        }
        if (fileContent == null) {
            return null;
        }
        return (DiscoverInfo)PacketParserUtils.parseStanza(fileContent);
    }
}

