/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.provider;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GeoLocationProvider
extends ExtensionElementProvider<GeoLocation> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public GeoLocation parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, ParseException, URISyntaxException {
        GeoLocation.Builder builder = GeoLocation.builder();
        while (true) {
            int event = parser.next();
            block0 : switch (event) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "accuracy": {
                            builder.setAccuracy(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "alt": {
                            builder.setAlt(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "altaccuracy": {
                            builder.setAltAccuracy(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "area": {
                            builder.setArea(parser.nextText());
                            break block0;
                        }
                        case "bearing": {
                            builder.setBearing(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "building": {
                            builder.setBuilding(parser.nextText());
                            break block0;
                        }
                        case "country": {
                            builder.setCountry(parser.nextText());
                            break block0;
                        }
                        case "countrycode": {
                            builder.setCountryCode(parser.nextText());
                            break block0;
                        }
                        case "datum": {
                            builder.setDatum(parser.nextText());
                            break block0;
                        }
                        case "description": {
                            builder.setDescription(parser.nextText());
                            break block0;
                        }
                        case "error": {
                            builder.setError(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "floor": {
                            builder.setFloor(parser.nextText());
                            break block0;
                        }
                        case "lat": {
                            builder.setLat(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "locality": {
                            builder.setLocality(parser.nextText());
                            break block0;
                        }
                        case "lon": {
                            builder.setLon(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "postalcode": {
                            builder.setPostalcode(parser.nextText());
                            break block0;
                        }
                        case "region": {
                            builder.setRegion(parser.nextText());
                            break block0;
                        }
                        case "room": {
                            builder.setRoom(parser.nextText());
                            break block0;
                        }
                        case "speed": {
                            builder.setSpeed(ParserUtils.getDoubleFromNextText(parser));
                            break block0;
                        }
                        case "street": {
                            builder.setStreet(parser.nextText());
                            break block0;
                        }
                        case "text": {
                            builder.setText(parser.nextText());
                            break block0;
                        }
                        case "timestamp": {
                            builder.setTimestamp(ParserUtils.getDateFromNextText(parser));
                            break block0;
                        }
                        case "tzo": {
                            builder.setTzo(parser.nextText());
                            break block0;
                        }
                        case "uri": {
                            builder.setUri(ParserUtils.getUriFromNextText(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }
}

