/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateDataIQ;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.jxmpp.util.XmppStringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static final Map<String, PrivateDataProvider> privateDataProviders = new Hashtable<String, PrivateDataProvider>();
    private static final PrivateData DUMMY_PRIVATE_DATA = new PrivateData(){

        @Override
        public String getElementName() {
            return "smackDummyPrivateData";
        }

        @Override
        public String getNamespace() {
            return "https://igniterealtime.org/projects/smack/";
        }

        @Override
        public CharSequence toXML() {
            return '<' + this.getElementName() + " xmlns='" + this.getNamespace() + "'/>";
        }
    };

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection connection) {
        PrivateDataManager privateDataManager = instances.get(connection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(connection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey(elementName, namespace);
        return privateDataProviders.get(key);
    }

    public static void addPrivateDataProvider(String elementName, String namespace, PrivateDataProvider provider) {
        String key = XmppStringUtils.generateKey(elementName, namespace);
        privateDataProviders.put(key, provider);
    }

    public static void removePrivateDataProvider(String elementName, String namespace) {
        String key = XmppStringUtils.generateKey(elementName, namespace);
        privateDataProviders.remove(key);
    }

    private PrivateDataManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
    }

    public PrivateData getPrivateData(String elementName, String namespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PrivateDataIQ privateDataGet = new PrivateDataIQ(elementName, namespace);
        PrivateDataIQ response = (PrivateDataIQ)this.connection().createStanzaCollectorAndSend(privateDataGet).nextResultOrThrow();
        return response.getPrivateData();
    }

    public void setPrivateData(PrivateData privateData) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PrivateDataIQ privateDataSet = new PrivateDataIQ(privateData);
        this.connection().createStanzaCollectorAndSend(privateDataSet).nextResultOrThrow();
    }

    public boolean isSupported() throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        try {
            this.setPrivateData(DUMMY_PRIVATE_DATA);
            return true;
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return false;
            }
            throw e;
        }
    }

    public static class PrivateDataIQProvider
    extends IQProvider<PrivateDataIQ> {
        @Override
        public PrivateDataIQ parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
            PrivateData privateData = null;
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    String namespace;
                    String elementName = parser.getName();
                    PrivateDataProvider provider = PrivateDataManager.getPrivateDataProvider(elementName, namespace = parser.getNamespace());
                    if (provider != null) {
                        privateData = provider.parsePrivateData(parser);
                        continue;
                    }
                    DefaultPrivateData data = new DefaultPrivateData(elementName, namespace);
                    boolean finished = false;
                    while (!finished) {
                        int event = parser.next();
                        if (event == 2) {
                            String name = parser.getName();
                            if (parser.isEmptyElementTag()) {
                                data.setValue(name, "");
                                continue;
                            }
                            event = parser.next();
                            if (event != 4) continue;
                            String value = parser.getText();
                            data.setValue(name, value);
                            continue;
                        }
                        if (event != 3 || !parser.getName().equals(elementName)) continue;
                        finished = true;
                    }
                    privateData = data;
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            return new PrivateDataIQ(privateData);
        }
    }
}

