/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.FullJidAndSessionId;
import org.jivesoftware.smackx.jingle.JingleSessionHandler;
import org.jivesoftware.smackx.jingle.Role;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jxmpp.jid.FullJid;

public abstract class JingleSession
implements JingleSessionHandler {
    protected HashSet<String> failedTransportMethods = new HashSet();
    protected final FullJid local;
    protected final FullJid remote;
    protected final Role role;
    protected final String sid;
    protected final List<JingleContent> contents = new ArrayList<JingleContent>();
    protected ArrayList<Future<?>> queued = new ArrayList();
    protected JingleTransportSession<?> transportSession;

    public JingleSession(FullJid initiator, FullJid responder, Role role, String sid) {
        this(initiator, responder, role, sid, null);
    }

    public JingleSession(FullJid initiator, FullJid responder, Role role, String sid, List<JingleContent> contents) {
        if (role == Role.initiator) {
            this.local = initiator;
            this.remote = responder;
        } else {
            this.local = responder;
            this.remote = initiator;
        }
        this.sid = sid;
        this.role = role;
        if (contents != null) {
            this.contents.addAll(contents);
        }
    }

    public FullJid getInitiator() {
        return this.isInitiator() ? this.local : this.remote;
    }

    public boolean isInitiator() {
        return this.role == Role.initiator;
    }

    public FullJid getResponder() {
        return this.isResponder() ? this.local : this.remote;
    }

    public boolean isResponder() {
        return this.role == Role.responder;
    }

    public FullJid getRemote() {
        return this.remote;
    }

    public FullJid getLocal() {
        return this.local;
    }

    public String getSessionId() {
        return this.sid;
    }

    public FullJidAndSessionId getFullJidAndSessionId() {
        return new FullJidAndSessionId(this.remote, this.sid);
    }

    public List<JingleContent> getContents() {
        return this.contents;
    }

    public JingleTransportSession<?> getTransportSession() {
        return this.transportSession;
    }

    protected void setTransportSession(JingleTransportSession<?> transportSession) {
        this.transportSession = transportSession;
    }

    public int hashCode() {
        int hashCode = 31 + this.getInitiator().hashCode();
        hashCode = 31 * hashCode + this.getResponder().hashCode();
        hashCode = 31 * hashCode + this.getSessionId().hashCode();
        return hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof JingleSession)) {
            return false;
        }
        JingleSession otherJingleSession = (JingleSession)other;
        return this.getInitiator().equals(otherJingleSession.getInitiator()) && this.getResponder().equals(otherJingleSession.getResponder()) && this.sid.equals(otherJingleSession.sid);
    }

    @Override
    public IQ handleJingleSessionRequest(Jingle jingle) {
        switch (jingle.getAction()) {
            case content_accept: {
                return this.handleContentAccept(jingle);
            }
            case content_add: {
                return this.handleContentAdd(jingle);
            }
            case content_modify: {
                return this.handleContentModify(jingle);
            }
            case content_reject: {
                return this.handleContentReject(jingle);
            }
            case content_remove: {
                return this.handleContentRemove(jingle);
            }
            case description_info: {
                return this.handleDescriptionInfo(jingle);
            }
            case session_info: {
                return this.handleSessionInfo(jingle);
            }
            case security_info: {
                return this.handleSecurityInfo(jingle);
            }
            case session_accept: {
                return this.handleSessionAccept(jingle);
            }
            case transport_accept: {
                return this.handleTransportAccept(jingle);
            }
            case transport_info: {
                return this.transportSession.handleTransportInfo(jingle);
            }
            case session_initiate: {
                return this.handleSessionInitiate(jingle);
            }
            case transport_reject: {
                return this.handleTransportReject(jingle);
            }
            case session_terminate: {
                return this.handleSessionTerminate(jingle);
            }
            case transport_replace: {
                return this.handleTransportReplace(jingle);
            }
        }
        return IQ.createResultIQ(jingle);
    }

    protected IQ handleSessionInitiate(Jingle sessionInitiate) {
        return IQ.createResultIQ(sessionInitiate);
    }

    protected IQ handleSessionTerminate(Jingle sessionTerminate) {
        return IQ.createResultIQ(sessionTerminate);
    }

    protected IQ handleSessionInfo(Jingle sessionInfo) {
        return IQ.createResultIQ(sessionInfo);
    }

    protected IQ handleSessionAccept(Jingle sessionAccept) {
        return IQ.createResultIQ(sessionAccept);
    }

    protected IQ handleContentAdd(Jingle contentAdd) {
        return IQ.createResultIQ(contentAdd);
    }

    protected IQ handleContentAccept(Jingle contentAccept) {
        return IQ.createResultIQ(contentAccept);
    }

    protected IQ handleContentModify(Jingle contentModify) {
        return IQ.createResultIQ(contentModify);
    }

    protected IQ handleContentReject(Jingle contentReject) {
        return IQ.createResultIQ(contentReject);
    }

    protected IQ handleContentRemove(Jingle contentRemove) {
        return IQ.createResultIQ(contentRemove);
    }

    protected IQ handleDescriptionInfo(Jingle descriptionInfo) {
        return IQ.createResultIQ(descriptionInfo);
    }

    protected IQ handleSecurityInfo(Jingle securityInfo) {
        return IQ.createResultIQ(securityInfo);
    }

    protected IQ handleTransportAccept(Jingle transportAccept) {
        return IQ.createResultIQ(transportAccept);
    }

    protected IQ handleTransportReplace(Jingle transportReplace) {
        return IQ.createResultIQ(transportReplace);
    }

    protected IQ handleTransportReject(Jingle transportReject) {
        return IQ.createResultIQ(transportReject);
    }

    public abstract XMPPConnection getConnection();

    public abstract void onTransportMethodFailed(String var1);
}

