/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.JingleTransportInitiationCallback;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransportSession
extends JingleTransportSession<JingleS5BTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportSession.class.getName());
    private JingleTransportInitiationCallback callback;
    private UsedCandidate ourChoice;
    private UsedCandidate theirChoice;
    private static final UsedCandidate CANDIDATE_FAILURE = new UsedCandidate(null, null, null);

    public JingleS5BTransportSession(JingleSession jingleSession) {
        super(jingleSession);
    }

    @Override
    public JingleS5BTransport createTransport() {
        if (this.ourProposal == null) {
            this.ourProposal = this.createTransport(JingleManager.randomId(), Bytestream.Mode.tcp);
        }
        return (JingleS5BTransport)this.ourProposal;
    }

    @Override
    public void setTheirProposal(JingleContentTransport transport) {
        this.theirProposal = (JingleS5BTransport)transport;
    }

    public JingleS5BTransport createTransport(String sid, Bytestream.Mode mode) {
        JingleS5BTransport.Builder jb = JingleS5BTransport.getBuilder().setStreamId(sid).setMode(mode).setDestinationAddress(Socks5Utils.createDigest(sid, this.jingleSession.getLocal(), this.jingleSession.getRemote()));
        if (JingleS5BTransportManager.isUseLocalCandidates()) {
            for (Bytestream.StreamHost host : this.transportManager().getLocalStreamHosts()) {
                jb.addTransportCandidate(new JingleS5BTransportCandidate(host, 100, JingleS5BTransportCandidate.Type.direct));
            }
        }
        List<Object> remoteHosts = Collections.emptyList();
        if (JingleS5BTransportManager.isUseExternalCandidates()) {
            try {
                remoteHosts = this.transportManager().getAvailableStreamHosts();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not determine available StreamHosts.", e);
            }
        }
        for (Bytestream.StreamHost host : remoteHosts) {
            jb.addTransportCandidate(new JingleS5BTransportCandidate(host, 0, JingleS5BTransportCandidate.Type.proxy));
        }
        return jb.build();
    }

    public void setTheirTransport(JingleContentTransport transport) {
        this.theirProposal = (JingleS5BTransport)transport;
    }

    @Override
    public void initiateOutgoingSession(JingleTransportInitiationCallback callback) {
        this.callback = callback;
        this.initiateSession();
    }

    @Override
    public void initiateIncomingSession(JingleTransportInitiationCallback callback) {
        this.callback = callback;
        this.initiateSession();
    }

    private void initiateSession() {
        Socks5Proxy.getSocks5Proxy().addTransfer(this.createTransport().getDestinationAddress());
        JingleContent content = this.jingleSession.getContents().get(0);
        UsedCandidate usedCandidate = this.chooseFromProposedCandidates((JingleS5BTransport)this.theirProposal);
        if (usedCandidate == null) {
            this.ourChoice = CANDIDATE_FAILURE;
            Jingle candidateError = this.transportManager().createCandidateError(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), content.getSenders(), content.getCreator(), content.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId());
            try {
                this.jingleSession.getConnection().sendStanza(candidateError);
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Could not send candidate-error.", e);
            }
        } else {
            this.ourChoice = usedCandidate;
            Jingle jingle = this.transportManager().createCandidateUsed(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), content.getSenders(), content.getCreator(), content.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId(), this.ourChoice.candidate.getCandidateId());
            try {
                this.jingleSession.getConnection().createStanzaCollectorAndSend(jingle).nextResultOrThrow();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not send candidate-used.", e);
            }
        }
        this.connectIfReady();
    }

    private UsedCandidate chooseFromProposedCandidates(JingleS5BTransport proposal) {
        for (JingleContentTransportCandidate c : proposal.getCandidates()) {
            JingleS5BTransportCandidate candidate = (JingleS5BTransportCandidate)c;
            try {
                return this.connectToTheirCandidate(candidate);
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException e) {
                LOGGER.log(Level.WARNING, "Could not connect to " + candidate.getHost(), e);
            }
        }
        LOGGER.log(Level.WARNING, "Failed to connect to any candidate.");
        return null;
    }

    private UsedCandidate connectToTheirCandidate(JingleS5BTransportCandidate candidate) throws InterruptedException, TimeoutException, SmackException, XMPPException, IOException {
        Bytestream.StreamHost streamHost = candidate.getStreamHost();
        String address = streamHost.getAddress();
        Socks5Client socks5Client = new Socks5Client(streamHost, ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        Socket socket = socks5Client.getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to their StreamHost " + address + " using dstAddr " + ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.theirProposal, candidate, socket);
    }

    private UsedCandidate connectToOurCandidate(JingleS5BTransportCandidate candidate) throws InterruptedException, TimeoutException, SmackException, XMPPException, IOException {
        Bytestream.StreamHost streamHost = candidate.getStreamHost();
        String address = streamHost.getAddress();
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, ((JingleS5BTransport)this.ourProposal).getDestinationAddress(), this.jingleSession.getConnection(), ((JingleS5BTransport)this.ourProposal).getStreamId(), this.jingleSession.getRemote());
        Socket socket = socks5Client.getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to our StreamHost " + address + " using dstAddr " + ((JingleS5BTransport)this.ourProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.ourProposal, candidate, socket);
    }

    @Override
    public String getNamespace() {
        return "urn:xmpp:jingle:transports:s5b:1";
    }

    @Override
    public IQ handleTransportInfo(Jingle transportInfo) {
        JingleS5BTransportInfo info = (JingleS5BTransportInfo)transportInfo.getContents().get(0).getTransport().getInfo();
        switch (info.getElementName()) {
            case "candidate-used": {
                return this.handleCandidateUsed(transportInfo);
            }
            case "candidate-activated": {
                return this.handleCandidateActivate(transportInfo);
            }
            case "candidate-error": {
                return this.handleCandidateError(transportInfo);
            }
            case "proxy-error": {
                return this.handleProxyError(transportInfo);
            }
        }
        return IQ.createResultIQ(transportInfo);
    }

    public IQ handleCandidateUsed(Jingle jingle) {
        JingleS5BTransportInfo info = (JingleS5BTransportInfo)jingle.getContents().get(0).getTransport().getInfo();
        String candidateId = ((JingleS5BTransportInfo.CandidateUsed)info).getCandidateId();
        this.theirChoice = new UsedCandidate((JingleS5BTransport)this.ourProposal, ((JingleS5BTransport)this.ourProposal).getCandidate(candidateId), null);
        if (this.theirChoice.candidate == null) {
            // empty if block
        }
        this.connectIfReady();
        return IQ.createResultIQ(jingle);
    }

    public IQ handleCandidateActivate(Jingle jingle) {
        LOGGER.log(Level.INFO, "handleCandidateActivate");
        Socks5BytestreamSession bs = new Socks5BytestreamSession(this.ourChoice.socket, this.ourChoice.candidate.getJid().asBareJid().equals(this.jingleSession.getRemote().asBareJid()));
        this.callback.onSessionInitiated(bs);
        return IQ.createResultIQ(jingle);
    }

    public IQ handleCandidateError(Jingle jingle) {
        this.theirChoice = CANDIDATE_FAILURE;
        this.connectIfReady();
        return IQ.createResultIQ(jingle);
    }

    public IQ handleProxyError(Jingle jingle) {
        return IQ.createResultIQ(jingle);
    }

    private void connectIfReady() {
        JingleContent content = this.jingleSession.getContents().get(0);
        if (this.ourChoice == null || this.theirChoice == null) {
            LOGGER.log(Level.INFO, "Not ready.");
            return;
        }
        if (this.ourChoice == CANDIDATE_FAILURE && this.theirChoice == CANDIDATE_FAILURE) {
            LOGGER.log(Level.INFO, "Failure.");
            this.jingleSession.onTransportMethodFailed(this.getNamespace());
            return;
        }
        LOGGER.log(Level.INFO, "Ready.");
        UsedCandidate nominated = this.ourChoice != CANDIDATE_FAILURE && this.theirChoice != CANDIDATE_FAILURE ? (this.ourChoice.candidate.getPriority() > this.theirChoice.candidate.getPriority() ? this.ourChoice : (this.ourChoice.candidate.getPriority() < this.theirChoice.candidate.getPriority() ? this.theirChoice : (this.jingleSession.isInitiator() ? this.ourChoice : this.theirChoice))) : (this.ourChoice != CANDIDATE_FAILURE ? this.ourChoice : this.theirChoice);
        if (nominated == this.theirChoice) {
            LOGGER.log(Level.INFO, "Their choice, so our proposed candidate is used.");
            boolean isProxy = nominated.candidate.getType() == JingleS5BTransportCandidate.Type.proxy;
            try {
                nominated = this.connectToOurCandidate(nominated.candidate);
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException e) {
                LOGGER.log(Level.INFO, "Could not connect to our candidate.", e);
                return;
            }
            if (isProxy) {
                LOGGER.log(Level.INFO, "Is external proxy. Activate it.");
                Bytestream activate = new Bytestream(((JingleS5BTransport)this.ourProposal).getStreamId());
                activate.setMode(null);
                activate.setType(IQ.Type.set);
                activate.setTo(nominated.candidate.getJid());
                activate.setToActivate(this.jingleSession.getRemote());
                activate.setFrom(this.jingleSession.getLocal());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend(activate).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not activate proxy.", e);
                    return;
                }
                LOGGER.log(Level.INFO, "Send candidate-activate.");
                Jingle candidateActivate = this.transportManager().createCandidateActivated(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), content.getSenders(), content.getCreator(), content.getName(), nominated.transport.getStreamId(), nominated.candidate.getCandidateId());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend(candidateActivate).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not send candidate-activated", e);
                    return;
                }
            }
            LOGGER.log(Level.INFO, "Start transmission.");
            Socks5BytestreamSession bs = new Socks5BytestreamSession(nominated.socket, !isProxy);
            this.callback.onSessionInitiated(bs);
        } else {
            boolean isProxy;
            LOGGER.log(Level.INFO, "Our choice, so their candidate was used.");
            boolean bl = isProxy = nominated.candidate.getType() == JingleS5BTransportCandidate.Type.proxy;
            if (!isProxy) {
                LOGGER.log(Level.INFO, "Direct connection.");
                Socks5BytestreamSession bs = new Socks5BytestreamSession(nominated.socket, true);
                this.callback.onSessionInitiated(bs);
            } else {
                LOGGER.log(Level.INFO, "Our choice was their external proxy. wait for candidate-activate.");
            }
        }
    }

    public JingleS5BTransportManager transportManager() {
        return JingleS5BTransportManager.getInstanceFor(this.jingleSession.getConnection());
    }

    private static final class UsedCandidate {
        private final Socket socket;
        private final JingleS5BTransport transport;
        private final JingleS5BTransportCandidate candidate;

        private UsedCandidate(JingleS5BTransport transport, JingleS5BTransportCandidate candidate, Socket socket) {
            this.socket = socket;
            this.transport = transport;
            this.candidate = candidate;
        }
    }
}

