/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="claimCheck")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClaimCheckDefinition
extends NoOutputDefinition<ClaimCheckDefinition> {
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlAttribute(required=true)
    @Metadata(enums="Get,GetAndRemove,Set,Push,Pop", javaType="org.apache.camel.model.ClaimCheckOperation")
    private String operation;
    @XmlAttribute
    private String key;
    @XmlAttribute
    private String filter;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;

    public ClaimCheckDefinition() {
    }

    protected ClaimCheckDefinition(ClaimCheckDefinition source) {
        super(source);
        this.aggregationStrategyBean = source.aggregationStrategyBean;
        this.operation = source.operation;
        this.key = source.key;
        this.filter = source.filter;
        this.aggregationStrategy = source.aggregationStrategy;
        this.aggregationStrategyMethodName = source.aggregationStrategyMethodName;
    }

    @Override
    public ClaimCheckDefinition copyDefinition() {
        return new ClaimCheckDefinition(this);
    }

    public String toString() {
        if (this.operation != null) {
            return "ClaimCheck[" + this.operation + "]";
        }
        return "ClaimCheck";
    }

    @Override
    public String getShortName() {
        return "claimCheck";
    }

    @Override
    public String getLabel() {
        return "claimCheck";
    }

    public ClaimCheckDefinition operation(ClaimCheckOperation operation) {
        return this.operation(operation.name());
    }

    public ClaimCheckDefinition operation(String operation) {
        this.setOperation(operation);
        return this;
    }

    public ClaimCheckDefinition key(String key) {
        this.setKey(key);
        return this;
    }

    public ClaimCheckDefinition filter(String filter) {
        this.setFilter(filter);
        return this;
    }

    public ClaimCheckDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
        return this;
    }

    public ClaimCheckDefinition aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public ClaimCheckDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }
}

