/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.app;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.model.app.BeanConstructorDefinition;
import org.apache.camel.model.app.BeanConstructorsDefinition;

public class BeanConstructorsAdapter
extends XmlAdapter<BeanConstructorsDefinition, Map<Integer, Object>> {
    @Override
    public Map<Integer, Object> unmarshal(BeanConstructorsDefinition v) {
        if (v == null) {
            return null;
        }
        int counter = 0;
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (BeanConstructorDefinition pd : v.getConstructors()) {
            Integer idx = pd.getIndex();
            if (idx == null) {
                idx = counter;
                ++counter;
            }
            result.put(idx, pd.getValue());
        }
        return result;
    }

    @Override
    public BeanConstructorsDefinition marshal(Map<Integer, Object> v) {
        if (v == null) {
            return null;
        }
        BeanConstructorDefinition[] result = new BeanConstructorDefinition[v.size()];
        int pos = 0;
        for (Map.Entry<Integer, Object> entry : v.entrySet()) {
            Integer idx = entry.getKey();
            Object value = entry.getValue();
            BeanConstructorDefinition pd = new BeanConstructorDefinition();
            if (idx != null) {
                pd.setIndex(idx);
            }
            pd.setValue(value.toString());
            result[pos++] = pd;
        }
        BeanConstructorsDefinition def = new BeanConstructorsDefinition();
        def.setConstructors(Arrays.asList(result));
        return def;
    }
}

