/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.ZeebeService;
import org.apache.camel.component.zeebe.model.MessageRequest;
import org.apache.camel.component.zeebe.model.MessageResponse;
import org.apache.camel.component.zeebe.processor.AbstractBaseProcessor;

public class MessageProcessor
extends AbstractBaseProcessor {
    public MessageProcessor(ZeebeEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        MessageRequest message = null;
        if (exchange.getMessage().getBody() instanceof MessageRequest) {
            message = exchange.getMessage().getBody(MessageRequest.class);
        } else if (exchange.getMessage().getBody() instanceof String) {
            try {
                String bodyString = exchange.getMessage().getBody(String.class);
                message = this.objectMapper.readValue(bodyString, MessageRequest.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalArgumentException("Cannot convert body to MessageMessage", jsonProcessingException);
            }
        } else {
            throw new CamelException("Message data missing");
        }
        MessageResponse resultMessage = null;
        switch (this.endpoint.getOperationName()) {
            case PUBLISH_MESSAGE: {
                resultMessage = this.publishMessage(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Operation!");
            }
        }
        this.setBody(exchange, resultMessage, this.endpoint.isFormatJSON());
    }

    private MessageResponse publishMessage(MessageRequest message) {
        ZeebeService zeebeService = this.endpoint.getComponent().getZeebeService();
        return zeebeService.publishMessage(message);
    }
}

