/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingListener;
import org.apache.camel.support.PropertyConfigurerHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class PropertyBindingSupport {
    private PropertyBindingSupport() {
    }

    public static Builder build() {
        return new Builder();
    }

    public static boolean bindProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull(camelContext, "camelContext");
        org.apache.camel.util.ObjectHelper.notNull(target, "target");
        org.apache.camel.util.ObjectHelper.notNull(properties, "properties");
        return PropertyBindingSupport.build().bind(camelContext, target, properties);
    }

    public static boolean bindWithFlattenProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull(camelContext, "camelContext");
        org.apache.camel.util.ObjectHelper.notNull(target, "target");
        org.apache.camel.util.ObjectHelper.notNull(properties, "properties");
        return PropertyBindingSupport.build().withFlattenProperties(true).bind(camelContext, target, properties);
    }

    public static void setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull(context, "context");
        org.apache.camel.util.ObjectHelper.notNull(target, "target");
        org.apache.camel.util.ObjectHelper.notNull(properties, "properties");
        if (target instanceof CamelContext) {
            throw new UnsupportedOperationException("Configuring the Camel Context is not supported");
        }
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            Component component = (Component)target;
            ServiceHelper.initService(target);
            configurer = component.getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(target.getClass().getSimpleName(), context);
        }
        try {
            PropertyBindingSupport.build().withMandatory(true).withRemoveParameters(false).withConfigurer(configurer).withIgnoreCase(true).withFlattenProperties(true).bind(context, target, properties);
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                Object prefix = e.getOptionPrefix();
                if (prefix != null && !((String)prefix).endsWith(".")) {
                    prefix = "." + (String)prefix;
                }
                key = prefix != null ? (String)prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), null, key, e.getCause());
        }
    }

    private static boolean doBindProperties(CamelContext camelContext, Object target, Map<String, Object> properties, String optionPrefix, boolean ignoreCase, boolean removeParameter, boolean flattenProperties, boolean mandatory, boolean optional, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder, boolean reflection, PropertyConfigurer configurer, PropertyBindingListener listener) {
        AbstractMap sorted;
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        if (flattenProperties) {
            properties = new FlattenMap(properties);
        }
        if (listener == null && camelContext != null) {
            listener = camelContext.getRegistry().findSingleByType(PropertyBindingListener.class);
        }
        boolean answer = false;
        if (optionPrefix != null) {
            properties = new OptionPrefixMap(properties, optionPrefix);
        }
        if (properties.size() > 1) {
            sorted = new TreeMap(new PropertyBindingKeyComparator(properties));
            sorted.putAll(properties);
        } else {
            sorted = properties;
        }
        for (Map.Entry entry : sorted.entrySet()) {
            boolean hit;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!nesting && PropertyBindingSupport.isDotKey(key)) continue;
            if (listener != null) {
                listener.bindProperty(target, key, value);
            }
            if ((hit = PropertyBindingSupport.doBuildPropertyOgnlPath(camelContext, target, key, value, deepNesting, fluentBuilder, allowPrivateSetter, ignoreCase, reference, placeholder, mandatory, optional, reflection, configurer)) && removeParameter) {
                properties.remove(key);
            }
            answer |= hit;
        }
        return answer;
    }

    private static boolean doBuildPropertyOgnlPath(CamelContext camelContext, Object originalTarget, String name, Object value, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase, boolean reference, boolean placeholder, boolean mandatory, boolean optional, boolean reflection, PropertyConfigurer configurer) {
        String[] parts;
        boolean quoted;
        if (name.startsWith("?")) {
            name = name.substring(1);
            optional = true;
        }
        Object newTarget = originalTarget;
        Class<?> newClass = originalTarget.getClass();
        String newName = name;
        if (configurer == null) {
            configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, newClass);
        }
        if (quoted = StringHelper.isQuoted(name)) {
            newName = name = StringHelper.removeLeadingAndEndingQuotes(name);
            parts = new String[]{name};
        } else {
            parts = PropertyBindingSupport.isDotKey(name) ? PropertyBindingSupport.splitKey(name) : new String[]{name};
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            Object prop = null;
            if (configurer != null) {
                prop = PropertyBindingSupport.getOrCreatePropertyOgnlPathViaConfigurer(camelContext, newTarget, part, ignoreCase, configurer);
            }
            if (prop == null && reflection) {
                prop = PropertyBindingSupport.getOrCreatePropertyOgnlPathViaReflection(camelContext, newTarget, part, ignoreCase);
            }
            if (prop == null) {
                if (!deepNesting) {
                    return false;
                }
                if (configurer != null) {
                    prop = PropertyBindingSupport.attemptCreateNewInstanceViaConfigurer(camelContext, newTarget, part, ignoreCase, configurer);
                }
                if (prop == null && reflection) {
                    prop = PropertyBindingSupport.attemptCreateNewInstanceViaReflection(camelContext, newTarget, newClass, part, fluentBuilder, allowPrivateSetter, ignoreCase);
                }
            }
            if (prop == null) {
                if (optional) {
                    return false;
                }
                if (!mandatory) continue;
                throw new IllegalArgumentException("Cannot find getter method: " + part + " on bean: " + String.valueOf(newClass) + " when binding property: " + name);
            }
            if (configurer instanceof PropertyConfigurerGetter) {
                PropertyConfigurerGetter propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
                String key = StringHelper.before(part, "[", part);
                Class<?> collectionType = (Class<?>)propertyConfigurerGetter.getCollectionValueType(newTarget, PropertyBindingSupport.undashKey(key), ignoreCase);
                if (collectionType == null) {
                    collectionType = prop.getClass();
                }
                if ((configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, collectionType)) == null && Map.class.isAssignableFrom(collectionType)) {
                    configurer = MapConfigurer.INSTANCE;
                }
            }
            newTarget = prop;
            newClass = newTarget.getClass();
            newName = Arrays.stream(parts, i + 1, parts.length).collect(Collectors.joining("."));
            if (configurer != null) continue;
            configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, newTarget);
        }
        return PropertyBindingSupport.doSetPropertyValue(camelContext, newTarget, newName, value, ignoreCase, mandatory, fluentBuilder, allowPrivateSetter, reference, placeholder, optional, reflection, configurer);
    }

    private static Object attemptCreateNewInstanceViaReflection(CamelContext camelContext, Object newTarget, Class<?> newClass, String name, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase) {
        Class<?> parameterType;
        Object obj;
        String key = StringHelper.before(name, "[", name);
        Object answer = null;
        Method method = PropertyBindingSupport.findBestSetterMethod(camelContext, newClass, key, fluentBuilder, allowPrivateSetter, ignoreCase);
        if (method != null && (obj = PropertyBindingSupport.getObjectForType(camelContext, parameterType = method.getParameterTypes()[0])) != null) {
            ObjectHelper.invokeMethod(method, newTarget, obj);
            answer = obj;
        }
        return answer;
    }

    private static Object attemptCreateNewInstanceViaConfigurer(CamelContext camelContext, Object newTarget, String name, boolean ignoreCase, PropertyConfigurer configurer) {
        boolean hit;
        Object obj;
        String key = StringHelper.before(name, "[", name);
        Object answer = null;
        Class<?> parameterType = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            PropertyConfigurerGetter propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
            parameterType = propertyConfigurerGetter.getOptionType(key, true);
        }
        if (parameterType != null && (obj = PropertyBindingSupport.getObjectForType(camelContext, parameterType)) != null && (hit = configurer.configure(camelContext, newTarget, PropertyBindingSupport.undashKey(key), obj, ignoreCase))) {
            answer = obj;
        }
        return answer;
    }

    private static Object getObjectForCollectionType(Class<?> type) {
        if (Properties.class.isAssignableFrom(type)) {
            return new Properties();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new LinkedHashMap();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new ArrayList();
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        return null;
    }

    private static Object getObjectForCollectionType(Class<?> type, String errorMessage) {
        Object ret = PropertyBindingSupport.getObjectForCollectionType(type);
        if (ret == null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return ret;
    }

    private static Object getObjectForType(CamelContext camelContext, Class<?> parameterType) {
        Object obj = PropertyBindingSupport.getObjectForCollectionType(parameterType);
        if (obj == null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
            obj = camelContext.getInjector().newInstance(parameterType);
        }
        return obj;
    }

    private static boolean doSetPropertyValue(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase, boolean mandatory, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder, boolean optional, boolean reflection, PropertyConfigurer configurer) {
        String key = name;
        Object text = value;
        if (placeholder) {
            String s2;
            key = camelContext.resolvePropertyPlaceholders(key);
            if (text instanceof String && (text = camelContext.resolvePropertyPlaceholders(s2 = (String)text)) == null && s2.startsWith("{{?")) {
                return true;
            }
        }
        try {
            Object str = PropertyBindingSupport.resolveValue(camelContext, target, key, text, ignoreCase, fluentBuilder, allowPrivateSetter, reflection, configurer);
            if (str instanceof String) {
                String strValue = (String)str;
                str = camelContext.resolvePropertyPlaceholders(strValue);
            }
            if (str == null && reference && mandatory && !optional) {
                throw new PropertyBindingException(target, key, value);
            }
            value = str;
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, text, e);
        }
        boolean bound = false;
        try {
            if (PropertyBindingSupport.isCollectionKey(name)) {
                if (configurer != null) {
                    bound = PropertyBindingSupport.setPropertyCollectionViaConfigurer(camelContext, target, key, value, ignoreCase, configurer);
                }
                if (!bound && reflection) {
                    bound = PropertyBindingSupport.setPropertyCollectionViaReflection(camelContext, target, key, value, ignoreCase, reference, optional);
                }
            } else {
                if (configurer != null) {
                    bound = PropertyBindingSupport.setSimplePropertyViaConfigurer(camelContext, target, key, value, ignoreCase, configurer);
                }
                if (!bound && reflection) {
                    bound = PropertyBindingSupport.setSimplePropertyViaReflection(camelContext, target, key, value, fluentBuilder, allowPrivateSetter, reflection, ignoreCase);
                }
                if (!bound && target instanceof Map) {
                    ((Map)target).put(key, value);
                    bound = true;
                }
                if (!bound && target instanceof List && StringHelper.isDigit(key)) {
                    try {
                        int idx = Integer.parseInt(key);
                        org.apache.camel.util.ObjectHelper.addListByIndex((List)target, idx, value);
                        bound = true;
                    }
                    catch (NumberFormatException idx) {}
                }
            }
        }
        catch (PropertyBindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, value, e);
        }
        if (mandatory && !optional && !bound) {
            throw new PropertyBindingException(target, key, value);
        }
        return bound;
    }

    private static boolean isCollectionKey(String name) {
        return name.contains("[") && name.endsWith("]");
    }

    private static boolean setPropertyCollectionViaReflection(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean reference, boolean optional) throws Exception {
        BeanIntrospection bi = PluginHelper.getBeanIntrospection(context);
        int pos = name.indexOf(91);
        String lookupKey = name.substring(pos + 1, name.length() - 1);
        lookupKey = StringHelper.removeLeadingAndEndingQuotes(lookupKey);
        String key = name.substring(0, pos);
        Object[] obj = null;
        if (pos == 0) {
            if (target instanceof Map || target instanceof List || target.getClass().isArray()) {
                obj = target;
            }
        } else {
            obj = bi.getOrElseProperty(target, key, null, ignoreCase);
        }
        if (obj == null) {
            Method getter = bi.getPropertyGetter(target.getClass(), key, ignoreCase);
            if (getter != null) {
                Class<?> returnType = getter.getReturnType();
                obj = PropertyBindingSupport.getObjectForCollectionType(returnType);
            } else {
                obj = new LinkedHashMap();
            }
            boolean hit = bi.setProperty(context, target, key, obj);
            if (!hit) {
                if (optional) {
                    return false;
                }
                throw new IllegalArgumentException("Cannot set property: " + name + " as a Map because target bean has no setter method for the Map");
            }
        }
        if (value instanceof String) {
            Object bean;
            String str = (String)value;
            if (reference && PropertyBindingSupport.isReferenceParameter(str) && (bean = CamelContextHelper.lookup(context, str.substring(1))) != null) {
                value = bean;
            }
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(lookupKey, value);
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                org.apache.camel.util.ObjectHelper.addListByIndex(list, idx, value);
            } else {
                list.add(value);
            }
            return true;
        }
        if (obj != null && obj.getClass().isArray() && lookupKey != null) {
            boolean hit;
            int size;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = Array.getLength(obj)) && !(hit = bi.setProperty(context, target, key, obj = Arrays.copyOf((Object[])obj, idx + 1)))) {
                throw new IllegalArgumentException("Cannot set property: " + name + " as an array because target bean has no setter method for the array");
            }
            Array.set(obj, idx, value);
            return true;
        }
        throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target));
    }

    private static boolean setPropertyCollectionViaConfigurer(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase, PropertyConfigurer configurer) {
        Object originalTarget = target;
        int pos = name.indexOf(91);
        String lookupKey = name.substring(pos + 1, name.length() - 1);
        lookupKey = StringHelper.removeLeadingAndEndingQuotes(lookupKey);
        String key = name.substring(0, pos);
        String undashKey = PropertyBindingSupport.undashKey(key);
        Object obj = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            PropertyConfigurerGetter propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
            obj = propertyConfigurerGetter.getOptionValue(target, undashKey, ignoreCase);
        }
        if (obj == null) {
            Class<?> returnType = null;
            if (configurer instanceof PropertyConfigurerGetter) {
                PropertyConfigurerGetter propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
                returnType = propertyConfigurerGetter.getOptionType(undashKey, true);
            }
            if (returnType == null) {
                return false;
            }
            obj = PropertyBindingSupport.getObjectForCollectionType(returnType);
            if (obj != null) {
                boolean hit = configurer.configure(camelContext, target, undashKey, obj, ignoreCase);
                if (!hit) {
                    throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target));
                }
                target = obj = ((PropertyConfigurerGetter)((Object)configurer)).getOptionValue(target, undashKey, ignoreCase);
            }
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(lookupKey, value);
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                if (idx < list.size()) {
                    list.set(idx, value);
                } else if (idx == list.size()) {
                    list.add(value);
                } else {
                    if (list instanceof ArrayList) {
                        ((ArrayList)list).ensureCapacity(idx + 1);
                    }
                    while (list.size() < idx) {
                        list.add(null);
                    }
                    list.add(idx, value);
                }
            } else {
                list.add(value);
            }
            return true;
        }
        if (obj.getClass().isArray()) {
            boolean hit;
            int size;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = Array.getLength(obj)) && !(hit = configurer.configure(camelContext, originalTarget, undashKey, obj = Arrays.copyOf((Object[])obj, idx + 1), ignoreCase))) {
                throw new IllegalArgumentException("Cannot set property: " + name + " as an array because target bean has no setter method for the array");
            }
            Array.set(obj, idx, value);
            return true;
        }
        throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target));
    }

    private static boolean setSimplePropertyViaConfigurer(CamelContext camelContext, Object target, String key, Object value, boolean ignoreCase, PropertyConfigurer configurer) {
        try {
            return configurer.configure(camelContext, target, PropertyBindingSupport.undashKey(key), value, ignoreCase);
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, value, e);
        }
    }

    private static boolean setSimplePropertyViaReflection(CamelContext camelContext, Object target, String name, Object value, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean ignoreCase) {
        try {
            if (name != null) {
                return PropertyBindingSupport.doSetSimplePropertyViaReflection(camelContext, target, name, value, false, ignoreCase, fluentBuilder, allowPrivateSetter, reference);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, value, e);
        }
        return false;
    }

    private static Object resolveAutowired(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reflection, PropertyConfigurer configurer) {
        String str;
        String undashKey = PropertyBindingSupport.undashKey(name);
        if (value instanceof String && (str = (String)value).equals("#autowired")) {
            Class<?> parameterType = null;
            if (configurer instanceof PropertyConfigurerGetter) {
                PropertyConfigurerGetter propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
                parameterType = propertyConfigurerGetter.getOptionType(undashKey, true);
            }
            if (parameterType == null && reflection) {
                Method method = PropertyBindingSupport.findBestSetterMethod(context, target.getClass(), undashKey, fluentBuilder, allowPrivateSetter, ignoreCase);
                if (method != null) {
                    parameterType = method.getParameterTypes()[0];
                } else {
                    throw new IllegalStateException("Cannot find setter method with name: " + undashKey + " on class: " + target.getClass().getName() + " to use for autowiring");
                }
            }
            if (parameterType != null) {
                value = context.getRegistry().mandatoryFindSingleByType(parameterType);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object resolveValue(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reflection, PropertyConfigurer configurer) throws Exception {
        if (!(value instanceof String)) return value;
        String str = (String)value;
        if (str.startsWith("#property:")) {
            String key = str.substring(10);
            key = context.resolvePropertyPlaceholders(key);
            Optional<String> resolved = context.getPropertiesComponent().resolveProperty(key);
            if (!resolved.isPresent()) throw new IllegalArgumentException("Property with key " + key + " not found by properties component");
            return resolved.get();
        }
        if (!str.equals("#autowired")) return PropertyBindingSupport.resolveBean(context, value);
        return PropertyBindingSupport.resolveAutowired(context, target, name, value, ignoreCase, fluentBuilder, allowPrivateSetter, reflection, configurer);
    }

    private static boolean doSetSimplePropertyViaReflection(CamelContext context, Object target, String name, Object value, boolean mandatory, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference) throws Exception {
        boolean hit;
        String refName = null;
        if (reference && value instanceof String) {
            Object bean;
            String str = (String)value;
            if (str.startsWith("#bean:")) {
                refName = "#" + str.substring(6);
                value = null;
            } else if (str.equals("#autowired")) {
                value = PropertyBindingSupport.resolveAutowired(context, target, name, value, ignoreCase, fluentBuilder, allowPrivateSetter, true, null);
            } else if (PropertyBindingSupport.isReferenceParameter(str) && (bean = CamelContextHelper.lookup(context, str.substring(1))) != null) {
                value = bean;
            }
        }
        if (!(hit = PluginHelper.getBeanIntrospection(context).setProperty(context, context.getTypeConverter(), target, name, value, refName, fluentBuilder, allowPrivateSetter, ignoreCase)) && mandatory) {
            throw new IllegalArgumentException("Cannot find setter method: " + name + " on bean: " + String.valueOf(target) + " of type: " + target.getClass().getName() + " when binding property: " + name);
        }
        return hit;
    }

    private static Object getOrCreatePropertyOgnlPathViaConfigurer(CamelContext context, Object target, String property, boolean ignoreCase, PropertyConfigurer configurer) {
        boolean hit;
        PropertyConfigurerGetter propertyConfigurerGetter;
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        String undashKey = PropertyBindingSupport.undashKey(key);
        Object answer = null;
        Class<?> type = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
            answer = propertyConfigurerGetter.getOptionValue(target, undashKey, ignoreCase);
        }
        if (answer != null) {
            type = answer.getClass();
        } else if (configurer instanceof PropertyConfigurerGetter) {
            propertyConfigurerGetter = (PropertyConfigurerGetter)((Object)configurer);
            type = propertyConfigurerGetter.getOptionType(undashKey, true);
        }
        if (answer == null && type == null) {
            return null;
        }
        if (answer == null && lookupKey != null && !(hit = configurer.configure(context, target, undashKey, answer = PropertyBindingSupport.getObjectForCollectionType(type, "Cannot set property: " + property + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target)), ignoreCase))) {
            throw new IllegalArgumentException("Cannot set property: " + key + " as an map/list/array because target bean has no suitable setter method");
        }
        if (answer instanceof Map && lookupKey != null) {
            Class parameterType;
            Map map = (Map)answer;
            if ((answer = map.get(lookupKey)) == null && (parameterType = (Class)((PropertyConfigurerGetter)((Object)configurer)).getCollectionValueType(target, undashKey, ignoreCase)) != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                Object instance = context.getInjector().newInstance(parameterType);
                map.put(lookupKey, instance);
                answer = instance;
            }
        } else if (answer instanceof List) {
            Class parameterType;
            List list = (List)answer;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                answer = list.size() > idx ? list.get(idx) : null;
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
            if (answer == null && (parameterType = (Class)((PropertyConfigurerGetter)((Object)configurer)).getCollectionValueType(target, undashKey, ignoreCase)) != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                Object instance = context.getInjector().newInstance(parameterType);
                list.add(instance);
                answer = instance;
            }
        } else if (type.isArray() && lookupKey != null) {
            boolean hit2;
            int size;
            Object[] arr = (Object[])answer;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = arr.length) && !(hit2 = configurer.configure(context, target, undashKey, arr = Arrays.copyOf(arr, idx + 1), true))) {
                throw new IllegalArgumentException("Cannot set property: " + key + " as an array because target bean has no setter method for the array");
            }
            Object instance = arr[idx];
            if (instance == null) {
                instance = context.getInjector().newInstance(type.getComponentType());
                Array.set(arr, idx, instance);
            }
            answer = instance;
        }
        return answer;
    }

    private static Object getOrCreatePropertyOgnlPathViaReflection(CamelContext context, Object target, String property, boolean ignoreCase) {
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        Class<?> type = null;
        BeanIntrospection introspection = PluginHelper.getBeanIntrospection(context);
        Object answer = introspection.getOrElseProperty(target, key, null, ignoreCase);
        if (answer != null) {
            type = answer.getClass();
        } else {
            try {
                Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                if (method != null) {
                    type = method.getReturnType();
                }
            }
            catch (NoSuchMethodException method) {
                // empty catch block
            }
        }
        if (answer == null && type == null) {
            return null;
        }
        if (answer == null && lookupKey != null) {
            answer = PropertyBindingSupport.getObjectForCollectionType(type, "Cannot set property: " + property + " as either a Map/List/array because target bean is not a Map, List or array type: " + String.valueOf(target));
            boolean hit = false;
            try {
                hit = introspection.setProperty(context, target, key, answer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hit) {
                throw new IllegalArgumentException("Cannot set property: " + key + " as an map/list/array because target bean has no suitable setter method");
            }
        }
        if (answer instanceof Map && lookupKey != null) {
            Map map = (Map)answer;
            if ((answer = map.get(lookupKey)) == null) {
                Class<?> parameterType = null;
                try {
                    String typeName;
                    String fqn;
                    Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                    if (method != null && (fqn = StringHelper.between(typeName = method.getGenericReturnType().getTypeName(), ",", ">")) != null) {
                        fqn = fqn.trim();
                        parameterType = context.getClassResolver().resolveClass(fqn);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    map.put(lookupKey, instance);
                    answer = instance;
                }
            }
        } else if (answer instanceof List) {
            List list = (List)answer;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                answer = list.size() > idx ? list.get(idx) : null;
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
            if (answer == null) {
                Class<?> parameterType = null;
                try {
                    String typeName;
                    String fqn;
                    Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                    if (method != null && (fqn = StringHelper.between(typeName = method.getGenericReturnType().getTypeName(), "<", ">")) != null) {
                        parameterType = context.getClassResolver().resolveClass(fqn);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    list.add(instance);
                    answer = instance;
                }
            }
        } else if (type.isArray() && lookupKey != null) {
            Object instance;
            int size;
            Object[] arr = (Object[])answer;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = arr.length)) {
                arr = Arrays.copyOf(arr, idx + 1);
                boolean hit = false;
                try {
                    hit = introspection.setProperty(context, target, key, arr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!hit) {
                    throw new IllegalArgumentException("Cannot set property: " + key + " as an array because target bean has no setter method for the array");
                }
            }
            if ((instance = arr[idx]) == null) {
                instance = context.getInjector().newInstance(type.getComponentType());
                Array.set(arr, idx, instance);
            }
            answer = instance;
        }
        return answer;
    }

    private static Method findBestSetterMethod(CamelContext context, Class<?> clazz, String name, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase) {
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(context);
        Set<Method> candidates = beanIntrospection.findSetterMethods(clazz, name, false, allowPrivateSetter, ignoreCase);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if (fluentBuilder && (candidates = beanIntrospection.findSetterMethods(clazz, name, fluentBuilder, allowPrivateSetter, ignoreCase)).size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    private static boolean isReferenceParameter(Object obj) {
        if (obj == null) {
            return false;
        }
        String parameter = obj.toString();
        if (!(parameter = parameter.trim()).startsWith("#")) {
            return false;
        }
        return !parameter.equals("#autowired") && !parameter.startsWith("#bean:") && !parameter.startsWith("#class:") && !parameter.startsWith("#type:") && !parameter.startsWith("#property:") && !parameter.startsWith("#valueAs(:");
    }

    public static Object newInstanceConstructorParameters(CamelContext camelContext, Class<?> type, String parameters) throws Exception {
        String[] params = StringQuoteHelper.splitSafeQuote(parameters, ',');
        Constructor<?> found = PropertyBindingSupport.findMatchingConstructor(camelContext, type.getConstructors(), params);
        if (found != null) {
            Object[] arr = new Object[found.getParameterCount()];
            for (int i = 0; i < found.getParameterCount(); ++i) {
                Object bean;
                String str;
                Class<?> paramType = found.getParameterTypes()[i];
                String param = params[i];
                Object val = null;
                if (param instanceof String && (str = param).startsWith("#") && (bean = PropertyBindingSupport.resolveBean(camelContext, param)) != null) {
                    val = bean;
                }
                if (val instanceof String) {
                    String strVal = (String)val;
                    val = StringHelper.removeLeadingAndEndingQuotes(strVal);
                }
                val = val != null ? camelContext.getTypeConverter().tryConvertTo(paramType, val) : camelContext.getTypeConverter().convertTo(paramType, param);
                arr[i] = val;
            }
            return found.newInstance(arr);
        }
        return null;
    }

    private static Constructor<?> findMatchingConstructor(CamelContext camelContext, Constructor<?>[] constructors, String[] params) {
        ArrayList candidates = new ArrayList();
        Constructor<?> fallbackCandidate = null;
        for (Constructor<?> ctr : constructors) {
            if (ctr.getParameterCount() != params.length) continue;
            boolean matches = true;
            for (int i = 0; i < ctr.getParameterCount(); ++i) {
                String parameter = params[i];
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = PropertyBindingSupport.getValidParameterType(camelContext, parameter);
                Class<?> expectedType = ctr.getParameterTypes()[i];
                if (parameterType == null || expectedType == null) continue;
                if (Object.class.equals(expectedType)) {
                    fallbackCandidate = ctr;
                    matches = false;
                    break;
                }
                boolean matchingTypes = PropertyBindingSupport.isParameterMatchingType(parameterType, expectedType);
                if (matchingTypes) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            candidates.add(ctr);
        }
        return candidates.size() == 1 ? (Constructor<?>)candidates.get(0) : fallbackCandidate;
    }

    public static Object newInstanceFactoryParameters(CamelContext camelContext, Class<?> type, String factoryMethod, String parameters) throws Exception {
        String[] params = StringQuoteHelper.splitSafeQuote(parameters, ',');
        Method found = PropertyBindingSupport.findMatchingFactoryMethod(camelContext, type.getMethods(), factoryMethod, params);
        if (found != null) {
            Object[] arr = new Object[found.getParameterCount()];
            for (int i = 0; i < found.getParameterCount(); ++i) {
                Object bean;
                String str;
                Class<?> paramType = found.getParameterTypes()[i];
                String param = params[i];
                Object val = null;
                if (param instanceof String && (str = param).startsWith("#") && (bean = PropertyBindingSupport.resolveBean(camelContext, param)) != null) {
                    val = bean;
                }
                if (val instanceof String) {
                    String strVal = (String)val;
                    val = StringHelper.removeLeadingAndEndingQuotes(strVal);
                }
                val = val != null ? camelContext.getTypeConverter().tryConvertTo(paramType, val) : camelContext.getTypeConverter().convertTo(paramType, param);
                arr[i] = val;
            }
            return found.invoke(null, arr);
        }
        return null;
    }

    private static Method findMatchingFactoryMethod(CamelContext camelContext, Method[] methods, String factoryMethod, String[] params) {
        ArrayList<Method> candidates = new ArrayList<Method>();
        Method fallbackCandidate = null;
        for (Method method : methods) {
            if (!factoryMethod.equals(method.getName()) || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() == Void.TYPE || method.getParameterCount() != params.length) continue;
            boolean matches = true;
            for (int i = 0; i < method.getParameterCount(); ++i) {
                String parameter = params[i];
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = PropertyBindingSupport.getValidParameterType(camelContext, parameter);
                Class<?> expectedType = method.getParameterTypes()[i];
                if (parameterType == null || expectedType == null) continue;
                if (Object.class.equals(expectedType)) {
                    fallbackCandidate = method;
                    matches = false;
                    break;
                }
                boolean matchingTypes = PropertyBindingSupport.isParameterMatchingType(parameterType, expectedType);
                if (matchingTypes) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            candidates.add(method);
        }
        return candidates.size() == 1 ? (Method)candidates.get(0) : fallbackCandidate;
    }

    private static Class<?> getValidParameterType(CamelContext camelContext, String value) {
        Object bean;
        if (org.apache.camel.util.ObjectHelper.isEmpty(value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'")) {
            return String.class;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return String.class;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.class;
        }
        if (value.equals("null")) {
            return Object.class;
        }
        if (value.startsWith("#") && (bean = CamelContextHelper.lookup(camelContext, value = value.startsWith("#bean:") ? value.substring(6) : value.substring(1))) != null) {
            return bean.getClass();
        }
        if (StringHelper.hasStartToken(value, "simple")) {
            return Object.class;
        }
        boolean numeric = true;
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            return Number.class;
        }
        return null;
    }

    private static boolean isParameterMatchingType(Class<?> parameterType, Class<?> expectedType) {
        if (Number.class.equals(parameterType) && (Integer.class.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType) || Integer.TYPE.isAssignableFrom(expectedType) || Long.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        if (Boolean.class.equals(parameterType) && (Boolean.class.isAssignableFrom(expectedType) || Boolean.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        boolean match = false;
        while (!match && parameterType != null && parameterType != Object.class) {
            match = parameterType.isAssignableFrom(expectedType) || expectedType.isAssignableFrom(parameterType);
            if (match) continue;
            parameterType = parameterType.getSuperclass();
        }
        return match;
    }

    public static Object resolveBean(CamelContext camelContext, Object value) throws Exception {
        if (!(value instanceof String)) {
            return value;
        }
        String strval = (String)value;
        Object answer = value;
        strval = camelContext.resolvePropertyPlaceholders(strval);
        if (strval.startsWith("#class:")) {
            String className = strval.substring(7);
            String factoryMethod = null;
            String parameters = null;
            if (className.endsWith(")") && className.indexOf(40) != -1) {
                parameters = StringHelper.after(className, "(");
                parameters = parameters.substring(0, parameters.length() - 1);
                className = StringHelper.before(className, "(");
            }
            if (className != null && className.indexOf(35) != -1) {
                factoryMethod = StringHelper.after(className, "#");
                className = StringHelper.before(className, "#");
            }
            Class<?> type = camelContext.getClassResolver().resolveMandatoryClass(className);
            if (factoryMethod != null) {
                Class<?> factoryClass = null;
                String typeOrRef = StringHelper.before(factoryMethod, ":");
                if (typeOrRef != null) {
                    factoryMethod = StringHelper.after(factoryMethod, ":");
                    Object existing = camelContext.getRegistry().lookupByName(typeOrRef);
                    factoryClass = existing != null ? existing.getClass() : camelContext.getClassResolver().resolveMandatoryClass(typeOrRef);
                }
                if (parameters != null) {
                    Class<?> target = factoryClass != null ? factoryClass : type;
                    answer = PropertyBindingSupport.newInstanceFactoryParameters(camelContext, target, factoryMethod, parameters);
                } else {
                    answer = camelContext.getInjector().newInstance(type, factoryClass, factoryMethod);
                }
                if (answer == null) {
                    throw new IllegalStateException("Cannot create bean instance using factory method: " + className + "#" + factoryMethod);
                }
            } else {
                answer = parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(camelContext, type, parameters) : camelContext.getInjector().newInstance(type);
            }
            if (answer == null) {
                throw new IllegalStateException("Cannot create instance of class: " + className);
            }
        } else if (strval.startsWith("#type:")) {
            String typeName = strval.substring(6);
            Class<?> type = camelContext.getClassResolver().resolveMandatoryClass(typeName);
            answer = camelContext.getRegistry().mandatoryFindSingleByType(type);
        } else if (strval.startsWith("#bean:")) {
            String key = strval.substring(6);
            answer = CamelContextHelper.mandatoryLookup(camelContext, key);
        } else if (strval.startsWith("#valueAs(")) {
            String text = strval.substring(8);
            String typeName = StringHelper.between(text, "(", ")");
            String constant = StringHelper.after(text, ":");
            if (typeName == null || constant == null) {
                throw new IllegalArgumentException("Illegal syntax: " + text + " when using function #valueAs(type):value");
            }
            Class<?> type = camelContext.getClassResolver().resolveMandatoryClass(typeName);
            answer = camelContext.getTypeConverter().mandatoryConvertTo(type, constant);
        }
        return answer;
    }

    private static String undashKey(String key) {
        key = StringHelper.dashToCamelCase(key);
        return key;
    }

    private static boolean isDotKey(String key) {
        if (key.indexOf(91) == -1 && key.indexOf(46) != -1) {
            return true;
        }
        boolean mapKey = false;
        for (char ch : key.toCharArray()) {
            if (ch == '[') {
                mapKey = true;
            } else if (ch == ']') {
                mapKey = false;
            }
            if (ch != '.' || mapKey) continue;
            return true;
        }
        return false;
    }

    private static String[] splitKey(String key) {
        ArrayList<String> parts = new ArrayList<String>();
        boolean mapKey = false;
        StringBuilder sb = new StringBuilder(key.length() + 16);
        for (char ch : key.toCharArray()) {
            if (ch == '[') {
                mapKey = true;
            } else if (ch == ']') {
                mapKey = false;
            }
            if (ch == '.' && !mapKey) {
                parts.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (!sb.isEmpty()) {
            parts.add(sb.toString());
        }
        return parts.toArray(new String[0]);
    }

    public static class Builder {
        private CamelContext camelContext;
        private Object target;
        private Map<String, Object> properties;
        private boolean removeParameters = true;
        private boolean flattenProperties;
        private boolean mandatory;
        private boolean optional;
        private boolean nesting = true;
        private boolean deepNesting = true;
        private boolean reference = true;
        private boolean placeholder = true;
        private boolean fluentBuilder = true;
        private boolean allowPrivateSetter = true;
        private boolean ignoreCase;
        private String optionPrefix;
        private boolean reflection = true;
        private PropertyConfigurer configurer;
        private PropertyBindingListener listener;

        public Builder withCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
            return this;
        }

        public Builder withTarget(Object target) {
            this.target = target;
            return this;
        }

        public Builder withProperties(Map<String, Object> properties) {
            if (this.properties != null) {
                this.properties.forEach(properties::putIfAbsent);
            }
            this.properties = properties;
            return this;
        }

        public Builder withProperty(String key, Object value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder withRemoveParameters(boolean removeParameters) {
            this.removeParameters = removeParameters;
            return this;
        }

        public Builder withFlattenProperties(boolean flattenProperties) {
            this.flattenProperties = flattenProperties;
            return this;
        }

        public Builder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public Builder withOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder withNesting(boolean nesting) {
            this.nesting = nesting;
            return this;
        }

        public Builder withDeepNesting(boolean deepNesting) {
            this.deepNesting = deepNesting;
            return this;
        }

        public Builder withReference(boolean reference) {
            this.reference = reference;
            return this;
        }

        public Builder withPlaceholder(boolean placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder withFluentBuilder(boolean fluentBuilder) {
            this.fluentBuilder = fluentBuilder;
            return this;
        }

        public Builder withAllowPrivateSetter(boolean allowPrivateSetter) {
            this.allowPrivateSetter = allowPrivateSetter;
            return this;
        }

        public Builder withIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public Builder withOptionPrefix(String optionPrefix) {
            this.optionPrefix = optionPrefix;
            return this;
        }

        public Builder withConfigurer(PropertyConfigurer configurer) {
            this.configurer = configurer;
            return this;
        }

        public Builder withReflection(boolean reflection) {
            this.reflection = reflection;
            return this;
        }

        public Builder withListener(PropertyBindingListener listener) {
            this.listener = listener;
            return this;
        }

        public <T> T build(Class<T> type) {
            return this.build(type, "build");
        }

        public <T> T build(Class<T> type, String buildMethod) {
            this.bind();
            try {
                Object out = ObjectHelper.invokeMethodSafe(buildMethod, this.target, new Object[0]);
                return this.camelContext.getTypeConverter().convertTo(type, out);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }

        public boolean bind() {
            org.apache.camel.util.ObjectHelper.notNull(this.camelContext, "camelContext");
            org.apache.camel.util.ObjectHelper.notNull(this.target, "target");
            if (this.properties == null || this.properties.isEmpty()) {
                return false;
            }
            return PropertyBindingSupport.doBindProperties(this.camelContext, this.target, this.removeParameters ? this.properties : new HashMap<String, Object>(this.properties), this.optionPrefix, this.ignoreCase, this.removeParameters, this.flattenProperties, this.mandatory, this.optional, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer, this.listener);
        }

        public boolean bind(CamelContext camelContext, Object target, Map<String, Object> properties) {
            CamelContext context = camelContext != null ? camelContext : this.camelContext;
            Object obj = target != null ? target : this.target;
            HashMap<String, Object> prop = properties != null ? properties : this.properties;
            return PropertyBindingSupport.doBindProperties(context, obj, this.removeParameters ? prop : new HashMap<String, Object>(prop), this.optionPrefix, this.ignoreCase, this.removeParameters, this.flattenProperties, this.mandatory, this.optional, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer, this.listener);
        }

        public boolean bind(CamelContext camelContext, Object target, String key, Object value) {
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            properties.put(key, value);
            return PropertyBindingSupport.doBindProperties(camelContext, target, properties, this.optionPrefix, this.ignoreCase, true, false, this.mandatory, this.optional, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer, this.listener);
        }
    }

    private static class FlattenMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, Object> originalMap;

        public FlattenMap(Map<String, Object> map) {
            this.originalMap = map;
            this.flatten("", this.originalMap);
        }

        private void flatten(String prefix, Map<?, Object> map) {
            for (Map.Entry<?, Object> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                boolean optional = key.startsWith("?");
                if (optional) {
                    key = key.substring(1);
                }
                Object value = entry.getValue();
                String keyPrefix = (optional ? "?" : "") + (String)(prefix.isEmpty() ? key : prefix + "." + key);
                if (value instanceof Map) {
                    this.flatten(keyPrefix, (Map)value);
                    continue;
                }
                this.put(keyPrefix, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String[] parts = PropertyBindingSupport.splitKey(key.toString());
            Map map = this.originalMap;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                Object obj = map.get(part);
                if (i == parts.length - 1) {
                    map.remove(part);
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                map = (Map)obj;
            }
            Object answer = super.remove(key);
            if (super.isEmpty()) {
                this.originalMap.clear();
            }
            return answer;
        }
    }

    private static class OptionPrefixMap
    extends LinkedHashMap<String, Object> {
        private final String optionPrefix;
        private final Map<String, Object> originalMap;

        public OptionPrefixMap(Map<String, Object> map, String optionPrefix) {
            this.originalMap = map;
            this.optionPrefix = optionPrefix;
            map.forEach((k, v) -> {
                if (StringHelper.startsWithIgnoreCase(k, optionPrefix)) {
                    this.put(k.substring(optionPrefix.length()), v);
                } else if (StringHelper.startsWithIgnoreCase(k, "?" + optionPrefix)) {
                    this.put(k.substring(optionPrefix.length() + 1), v);
                }
            });
        }

        @Override
        public Object remove(Object key) {
            HashSet toBeRemoved = new HashSet();
            this.originalMap.forEach((k, v) -> {
                if (StringHelper.startsWithIgnoreCase(k, this.optionPrefix)) {
                    toBeRemoved.add(k);
                } else if (StringHelper.startsWithIgnoreCase(k, "?" + this.optionPrefix)) {
                    toBeRemoved.add(k);
                }
            });
            toBeRemoved.forEach(this.originalMap::remove);
            return super.remove(key);
        }
    }

    private static final class PropertyBindingKeyComparator
    implements Comparator<String> {
        private final Map<String, Object> map;

        private PropertyBindingKeyComparator(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            boolean ref2;
            int n2;
            int n1 = StringHelper.countChar(o1, '.');
            if (n1 != (n2 = StringHelper.countChar(o2, '.'))) {
                return Integer.compare(n1, n2);
            }
            Object v1 = this.map.get(o1);
            Object v2 = this.map.get(o2);
            boolean ref1 = v1 instanceof String && ((String)v1).startsWith("#");
            boolean bl = ref2 = v2 instanceof String && ((String)v2).startsWith("#");
            if (ref1 != ref2) {
                return Boolean.compare(ref1, ref2);
            }
            return o1.compareTo(o2);
        }
    }

    private static final class MapConfigurer
    implements PropertyConfigurer {
        public static final PropertyConfigurer INSTANCE = new MapConfigurer();

        private MapConfigurer() {
        }

        @Override
        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            ((Map)target).put(name, value);
            return true;
        }
    }

    @FunctionalInterface
    public static interface OnAutowiring {
        public void onAutowire(Object var1, String var2, Class<?> var3, Object var4);
    }
}

