/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.console;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.console.DevConsole;
import org.apache.camel.support.service.ServiceSupport;

public abstract class AbstractDevConsole
extends ServiceSupport
implements DevConsole,
CamelContextAware {
    private CamelContext camelContext;
    private final Lock lock = new ReentrantLock();
    private final String group;
    private final String id;
    private final String displayName;
    private final String description;

    public AbstractDevConsole(String group, String id, String displayName, String description) {
        this.group = group;
        this.id = id;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean supportMediaType(DevConsole.MediaType mediaType) {
        return true;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDevConsole)) {
            return false;
        }
        AbstractDevConsole that = (AbstractDevConsole)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(DevConsole.MediaType mediaType, Map<String, Object> options) {
        this.lock.lock();
        try {
            if (mediaType == DevConsole.MediaType.JSON) {
                Map<String, Object> map = this.doCallJson(options);
                return map;
            }
            String string = this.doCallText(options);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract Map<String, Object> doCallJson(Map<String, Object> var1);

    protected abstract String doCallText(Map<String, Object> var1);
}

