/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Task;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class CompensationTaskValidator
implements ModelElementValidator<Task> {
    @Override
    public Class<Task> getElementType() {
        return Task.class;
    }

    @Override
    public void validate(Task element, ValidationResultCollector validationResultCollector) {
        String isForCompensation = element.getAttributeValue("isForCompensation");
        if (Boolean.parseBoolean(isForCompensation)) {
            if (!element.getIncoming().isEmpty()) {
                validationResultCollector.addError(0, "A compensation handler should have no incoming sequence flows");
            }
            if (!element.getOutgoing().isEmpty()) {
                validationResultCollector.addError(0, "A compensation handler should have no outgoing sequence flows");
            }
            if (element.getBoundaryEvents().count() > 0) {
                validationResultCollector.addError(0, "A compensation handler should have no boundary events");
            }
        }
    }
}

