/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListeners;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ExecutionListenersValidator
implements ModelElementValidator<ZeebeExecutionListeners> {
    private static final Set<String> ELEMENTS_THAT_SUPPORT_EXECUTION_LISTENERS = Collections.singleton("serviceTask");

    @Override
    public Class<ZeebeExecutionListeners> getElementType() {
        return ZeebeExecutionListeners.class;
    }

    @Override
    public void validate(ZeebeExecutionListeners element, ValidationResultCollector validationResultCollector) {
        Collection<ZeebeExecutionListener> executionListeners = element.getExecutionListeners();
        if (executionListeners == null || executionListeners.isEmpty()) {
            return;
        }
        String parentElementTypeName = element.getParentElement().getParentElement().getElementType().getTypeName();
        if (!ELEMENTS_THAT_SUPPORT_EXECUTION_LISTENERS.contains(parentElementTypeName)) {
            String errorMessage = String.format("Execution listeners are not supported for the '%s' element. Currently, only %s elements can have execution listeners.", parentElementTypeName, ELEMENTS_THAT_SUPPORT_EXECUTION_LISTENERS);
            validationResultCollector.addError(0, errorMessage);
            return;
        }
        Function<ZeebeExecutionListener, String> eventTypeAndTypeClassifier = listener -> (Object)((Object)listener.getEventType()) + "|" + listener.getType();
        Map<String, List<ZeebeExecutionListener>> listenersGroupedByType = executionListeners.stream().collect(Collectors.groupingBy(eventTypeAndTypeClassifier));
        listenersGroupedByType.values().stream().filter(duplicates -> duplicates.size() > 1).forEach(duplicates -> this.reportDuplicateListeners((List<ZeebeExecutionListener>)duplicates, validationResultCollector));
    }

    private void reportDuplicateListeners(List<ZeebeExecutionListener> duplicates, ValidationResultCollector validationResultCollector) {
        ZeebeExecutionListener representative = duplicates.get(0);
        String errorMessage = String.format("Found '%d' duplicates based on eventType[%s] and type[%s], these combinations should be unique.", new Object[]{duplicates.size(), representative.getEventType(), representative.getType()});
        validationResultCollector.addError(0, errorMessage);
    }
}

