/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe;

import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.OperationName;
import org.apache.camel.component.zeebe.processor.DeploymentProcessor;
import org.apache.camel.component.zeebe.processor.JobProcessor;
import org.apache.camel.component.zeebe.processor.MessageProcessor;
import org.apache.camel.component.zeebe.processor.ProcessProcessor;
import org.apache.camel.component.zeebe.processor.ZeebeProcessor;
import org.apache.camel.support.DefaultProducer;

public class ZeebeProducer
extends DefaultProducer {
    private ZeebeProcessor processor;

    public ZeebeProducer(ZeebeEndpoint endpoint) {
        super(endpoint);
        OperationName operationName = endpoint.getOperationName();
        if (ZeebeProducer.isProcessOperation(operationName)) {
            this.processor = new ProcessProcessor(endpoint);
        } else if (ZeebeProducer.isMessageOperation(operationName)) {
            this.processor = new MessageProcessor(endpoint);
        } else if (ZeebeProducer.isJobOperation(operationName)) {
            this.processor = new JobProcessor(endpoint);
        } else if (ZeebeProducer.isDeploymentOperation(operationName)) {
            this.processor = new DeploymentProcessor(endpoint);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.processor == null) {
            throw new CamelException("No processor set");
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.processor == null) {
            throw new CamelException("No Processor Found");
        }
        this.processor.process(exchange);
    }

    @Override
    public ZeebeEndpoint getEndpoint() {
        return (ZeebeEndpoint)super.getEndpoint();
    }

    private static boolean isProcessOperation(OperationName operationName) {
        switch (operationName) {
            case START_PROCESS: 
            case CANCEL_PROCESS: {
                return true;
            }
        }
        return false;
    }

    private static boolean isMessageOperation(OperationName operationName) {
        switch (operationName) {
            case PUBLISH_MESSAGE: {
                return true;
            }
        }
        return false;
    }

    private static boolean isJobOperation(OperationName operationName) {
        switch (operationName) {
            case COMPLETE_JOB: 
            case FAIL_JOB: 
            case UPDATE_JOB_RETRIES: 
            case THROW_ERROR: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDeploymentOperation(OperationName operationName) {
        switch (operationName) {
            case DEPLOY_RESOURCE: {
                return true;
            }
        }
        return false;
    }
}

