/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.component.zeebe.model.ZeebeMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessRequest
implements ZeebeMessage {
    @JsonProperty(value="process_id")
    private String processId;
    @JsonProperty(value="process_version")
    private int processVersion = -1;
    private Map<String, Object> variables = Collections.emptyMap();
    @JsonProperty(value="process_key")
    private long processKey = -1L;
    @JsonProperty(value="process_instance_key")
    private long processInstanceKey = -1L;

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public long getProcessKey() {
        return this.processKey;
    }

    public void setProcessKey(long processKey) {
        this.processKey = processKey;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProcessMessage{");
        sb.append("processId='").append(this.processId).append('\'');
        sb.append(", processVersion=").append(this.processVersion);
        sb.append(", variables=").append(this.variables);
        sb.append(", processKey=").append(this.processKey);
        sb.append(", processInstanceKey=").append(this.processInstanceKey);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessRequest that = (ProcessRequest)o;
        return this.processVersion == that.processVersion && this.processKey == that.processKey && this.processInstanceKey == that.processInstanceKey && this.processId.equals(that.processId) && this.variables.equals(that.variables);
    }

    public int hashCode() {
        return Objects.hash(this.processId, this.processVersion, this.variables, this.processKey, this.processInstanceKey);
    }
}

