/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.DefaultExchange;

public class ExtendedExchangeExtension
implements ExchangeExtension {
    private final AbstractExchange exchange;
    private Boolean errorHandlerHandled;
    private boolean failureHandled;
    private Endpoint fromEndpoint;
    private String fromRouteId;
    private boolean streamCacheDisabled;
    private boolean redeliveryExhausted;
    private String historyNodeId;
    private String historyNodeSource;
    private String historyNodeLabel;
    private boolean transacted;
    private boolean notifyEvent;
    private boolean interruptable = true;
    private boolean interrupted;
    private AsyncCallback defaultConsumerCallback;
    private UnitOfWork unitOfWork;
    private List<Synchronization> onCompletions;

    ExtendedExchangeExtension(AbstractExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setFromEndpoint(Endpoint fromEndpoint) {
        this.fromEndpoint = fromEndpoint;
    }

    @Override
    public Endpoint getFromEndpoint() {
        return this.fromEndpoint;
    }

    @Override
    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    @Override
    public boolean isStreamCacheDisabled() {
        return this.streamCacheDisabled;
    }

    @Override
    public void setStreamCacheDisabled(boolean streamCacheDisabled) {
        this.streamCacheDisabled = streamCacheDisabled;
    }

    @Override
    public void addOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork == null) {
            if (this.onCompletions == null) {
                this.onCompletions = new ArrayList<Synchronization>();
            }
            this.onCompletions.add(onCompletion);
        } else {
            this.unitOfWork.addSynchronization(onCompletion);
        }
    }

    @Override
    public boolean isErrorHandlerHandledSet() {
        return this.errorHandlerHandled != null;
    }

    @Override
    public Boolean getErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    @Override
    public void setErrorHandlerHandled(Boolean errorHandlerHandled) {
        this.errorHandlerHandled = errorHandlerHandled;
    }

    @Override
    public boolean isErrorHandlerHandled() {
        return this.errorHandlerHandled;
    }

    @Override
    public boolean isRedeliveryExhausted() {
        return this.redeliveryExhausted;
    }

    @Override
    public void setRedeliveryExhausted(boolean redeliveryExhausted) {
        this.redeliveryExhausted = redeliveryExhausted;
    }

    @Override
    public void handoverCompletions(Exchange target) {
        if (this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                target.getExchangeExtension().addOnCompletion(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        } else if (this.unitOfWork != null) {
            this.unitOfWork.handoverSynchronization(target);
        }
    }

    @Override
    public List<Synchronization> handoverCompletions() {
        ArrayList<Synchronization> answer = null;
        if (this.onCompletions != null) {
            answer = new ArrayList<Synchronization>(this.onCompletions);
            this.onCompletions.clear();
            this.onCompletions = null;
        }
        return answer;
    }

    @Override
    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
        if (unitOfWork != null && this.onCompletions != null) {
            for (Synchronization onCompletion : this.onCompletions) {
                unitOfWork.addSynchronization(onCompletion);
            }
            this.onCompletions.clear();
            this.onCompletions = null;
        }
    }

    @Override
    public void copyInternalProperties(Exchange target) {
        this.exchange.copyInternalProperties(target);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.exchange.setProperties(properties);
    }

    @Override
    public void setHistoryNodeId(String historyNodeId) {
        this.historyNodeId = historyNodeId;
    }

    @Override
    public String getHistoryNodeId() {
        return this.historyNodeId;
    }

    @Override
    public String getHistoryNodeSource() {
        return this.historyNodeSource;
    }

    @Override
    public void setHistoryNodeSource(String historyNodeSource) {
        this.historyNodeSource = historyNodeSource;
    }

    @Override
    public String getHistoryNodeLabel() {
        return this.historyNodeLabel;
    }

    @Override
    public void setHistoryNodeLabel(String historyNodeLabel) {
        this.historyNodeLabel = historyNodeLabel;
    }

    @Override
    public boolean isNotifyEvent() {
        return this.notifyEvent;
    }

    @Override
    public void setNotifyEvent(boolean notifyEvent) {
        this.notifyEvent = notifyEvent;
    }

    @Override
    public Map<String, Object> getInternalProperties() {
        return this.exchange.getInternalProperties();
    }

    @Override
    public boolean containsOnCompletion(Synchronization onCompletion) {
        if (this.unitOfWork != null) {
            return this.unitOfWork.containsSynchronization(onCompletion);
        }
        return this.onCompletions != null && this.onCompletions.contains(onCompletion);
    }

    @Override
    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    boolean isTransacted() {
        return this.transacted;
    }

    @Override
    public void setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean interrupted) {
        if (this.interruptable) {
            this.interrupted = interrupted;
        }
    }

    @Override
    public <T> T getInOrNull(Class<T> type) {
        return this.exchange.getInOrNull(type);
    }

    @Override
    public AsyncCallback getDefaultConsumerCallback() {
        return this.defaultConsumerCallback;
    }

    @Override
    public void setDefaultConsumerCallback(AsyncCallback callback) {
        this.defaultConsumerCallback = callback;
    }

    @Override
    public void setSafeCopyProperty(String key, SafeCopyProperty value) {
        this.exchange.setSafeCopyProperty(key, value);
    }

    @Override
    public <T> T getSafeCopyProperty(String key, Class<T> type) {
        return this.exchange.getSafeCopyProperty(key, type);
    }

    @Override
    public void copySafeCopyPropertiesTo(ExchangeExtension target) {
        if (this.exchange.safeCopyProperties != null && !this.exchange.safeCopyProperties.isEmpty()) {
            this.exchange.safeCopyProperties.entrySet().stream().forEach(entry -> target.setSafeCopyProperty((String)entry.getKey(), ((SafeCopyProperty)entry.getValue()).safeCopy()));
        }
    }

    @Override
    public boolean isFailureHandled() {
        return this.failureHandled;
    }

    @Override
    public void setFailureHandled(boolean failureHandled) {
        this.failureHandled = failureHandled;
    }

    UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void reset() {
        if (this.unitOfWork != null) {
            this.unitOfWork.reset();
        }
        if (this.onCompletions != null) {
            this.onCompletions.clear();
        }
        if (this.exchange.variableRepository != null) {
            this.exchange.variableRepository.clear();
        }
        this.setHistoryNodeId(null);
        this.setHistoryNodeLabel(null);
        this.setTransacted(false);
        this.setNotifyEvent(false);
        this.setInterrupted(false);
        this.setInterruptable(true);
        this.setRedeliveryExhausted(false);
        this.setErrorHandlerHandled(null);
        this.setStreamCacheDisabled(false);
    }

    @Override
    public Exchange createCopyWithProperties(CamelContext context) {
        DefaultExchange answer = new DefaultExchange(context, this.exchange.internalProperties, this.exchange.properties);
        answer.setPattern(this.exchange.pattern);
        return answer;
    }
}

