/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpoint;
import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class ZendeskEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold(ZendeskEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold(ZendeskEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier(ZendeskEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "delay": {
                target.setDelay(ZendeskEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(ZendeskEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(ZendeskEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "greedy": {
                target.setGreedy(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay(ZendeskEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oauthtoken": 
            case "oauthToken": {
                ((ZendeskConfiguration)target.getConfiguration()).setOauthToken(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "password": {
                ((ZendeskConfiguration)target.getConfiguration()).setPassword(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy(ZendeskEndpointConfigurer.property(camelContext, PollingConsumerPollStrategy.class, value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(ZendeskEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(ZendeskEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService(ZendeskEndpointConfigurer.property(camelContext, ScheduledExecutorService.class, value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(ZendeskEndpointConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties(ZendeskEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                ((ZendeskConfiguration)target.getConfiguration()).setServerUrl(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit(ZendeskEndpointConfigurer.property(camelContext, TimeUnit.class, value));
                return true;
            }
            case "token": {
                ((ZendeskConfiguration)target.getConfiguration()).setToken(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay(ZendeskEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                ((ZendeskConfiguration)target.getConfiguration()).setUsername(ZendeskEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "inbody": 
            case "inBody": {
                return String.class;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "oauthtoken": 
            case "oauthToken": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "token": {
                return String.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oauthtoken": 
            case "oauthToken": {
                return ((ZendeskConfiguration)target.getConfiguration()).getOauthToken();
            }
            case "password": {
                return ((ZendeskConfiguration)target.getConfiguration()).getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serverurl": 
            case "serverUrl": {
                return ((ZendeskConfiguration)target.getConfiguration()).getServerUrl();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "token": {
                return ((ZendeskConfiguration)target.getConfiguration()).getToken();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": {
                return ((ZendeskConfiguration)target.getConfiguration()).getUsername();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("methodName", ZendeskApiMethod.class);
        map.put("inBody", String.class);
        map.put("serverUrl", String.class);
        map.put("sendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("pollStrategy", PollingConsumerPollStrategy.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("backoffErrorThreshold", Integer.TYPE);
        map.put("backoffIdleThreshold", Integer.TYPE);
        map.put("backoffMultiplier", Integer.TYPE);
        map.put("delay", Long.TYPE);
        map.put("greedy", Boolean.TYPE);
        map.put("initialDelay", Long.TYPE);
        map.put("repeatCount", Long.TYPE);
        map.put("runLoggingLevel", LoggingLevel.class);
        map.put("scheduledExecutorService", ScheduledExecutorService.class);
        map.put("scheduler", Object.class);
        map.put("schedulerProperties", Map.class);
        map.put("startScheduler", Boolean.TYPE);
        map.put("timeUnit", TimeUnit.class);
        map.put("useFixedDelay", Boolean.TYPE);
        map.put("oauthToken", String.class);
        map.put("password", String.class);
        map.put("token", String.class);
        map.put("username", String.class);
        ALL_OPTIONS = map;
    }
}

