/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2;

import java.io.IOException;
import org.asynchttpclient.Response;
import org.zendesk.client.v2.ZendeskResponseException;

public class ZendeskResponseRateLimitException
extends ZendeskResponseException {
    private static final long serialVersionUID = 1L;
    private static final String RETRY_AFTER_HEADER = "Retry-After";
    private static final long DEFAULT_RETRY_AFTER = 60L;
    private Long retryAfter = 60L;

    public ZendeskResponseRateLimitException(Response resp) throws IOException {
        super(resp);
        try {
            this.retryAfter = Long.valueOf(resp.getHeader(RETRY_AFTER_HEADER));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ZendeskResponseRateLimitException(ZendeskResponseRateLimitException e) {
        super(e);
        this.retryAfter = e.getRetryAfter();
    }

    public Long getRetryAfter() {
        return this.retryAfter;
    }
}

