/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.zendesk.ZendeskComponent;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.zendesk.client.v2.Zendesk;

public class ZendeskComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskComponent target = (ZendeskComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(ZendeskComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(ZendeskComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(ZendeskComponentConfigurer.property(camelContext, ZendeskConfiguration.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ZendeskComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oauthtoken": 
            case "oauthToken": {
                target.setOauthToken(ZendeskComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "password": {
                target.setPassword(ZendeskComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                target.setServerUrl(ZendeskComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "token": {
                target.setToken(ZendeskComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "username": {
                target.setUsername(ZendeskComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "zendesk": {
                target.setZendesk(ZendeskComponentConfigurer.property(camelContext, Zendesk.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return ZendeskConfiguration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "oauthtoken": 
            case "oauthToken": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "token": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
            case "zendesk": {
                return Zendesk.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskComponent target = (ZendeskComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oauthtoken": 
            case "oauthToken": {
                return target.getOauthToken();
            }
            case "password": {
                return target.getPassword();
            }
            case "serverurl": 
            case "serverUrl": {
                return target.getServerUrl();
            }
            case "token": {
                return target.getToken();
            }
            case "username": {
                return target.getUsername();
            }
            case "zendesk": {
                return target.getZendesk();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ServerUrl", String.class);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("Configuration", ZendeskConfiguration.class);
        map.put("Zendesk", Zendesk.class);
        map.put("OauthToken", String.class);
        map.put("Password", String.class);
        map.put("Token", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

