/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.zendesk.ZendeskEndpointConfiguration;
import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SortOrder;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.dynamic.DynamicContentItem;
import org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.ContentTag;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.Target;

public class ZendeskEndpointConfigurationConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskEndpointConfiguration target = (ZendeskEndpointConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "active": {
                target.setActive(ZendeskEndpointConfigurationConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "article": {
                target.setArticle(ZendeskEndpointConfigurationConfigurer.property(camelContext, Article.class, value));
                return true;
            }
            case "articleattachments": 
            case "articleAttachments": {
                target.setArticleAttachments(ZendeskEndpointConfigurationConfigurer.property(camelContext, ArticleAttachments.class, value));
                return true;
            }
            case "articleid": 
            case "articleId": {
                target.setArticleId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "articleid0": 
            case "articleId0": {
                target.setArticleId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "attachment": {
                target.setAttachment(ZendeskEndpointConfigurationConfigurer.property(camelContext, Attachment.class, value));
                return true;
            }
            case "attachments": {
                target.setAttachments(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "audit": {
                target.setAudit(ZendeskEndpointConfigurationConfigurer.property(camelContext, Audit.class, value));
                return true;
            }
            case "auditid": 
            case "auditId": {
                target.setAuditId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "automation": {
                target.setAutomation(ZendeskEndpointConfigurationConfigurer.property(camelContext, Automation.class, value));
                return true;
            }
            case "automationid": 
            case "automationId": {
                target.setAutomationId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "automationid0": 
            case "automationId0": {
                target.setAutomationId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "category": {
                target.setCategory(ZendeskEndpointConfigurationConfigurer.property(camelContext, Category.class, value));
                return true;
            }
            case "categoryid": 
            case "categoryId": {
                target.setCategoryId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "categoryid0": 
            case "categoryId0": {
                target.setCategoryId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "categoryid1": 
            case "categoryId1": {
                target.setCategoryId1(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "category_id": {
                target.setCategory_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "comment": {
                target.setComment(ZendeskEndpointConfigurationConfigurer.property(camelContext, Comment.class, value));
                return true;
            }
            case "commentid": 
            case "commentId": {
                target.setCommentId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "content": {
                target.setContent(ZendeskEndpointConfigurationConfigurer.property(camelContext, byte[].class, value));
                return true;
            }
            case "contenttag": 
            case "contentTag": {
                target.setContentTag(ZendeskEndpointConfigurationConfigurer.property(camelContext, ContentTag.class, value));
                return true;
            }
            case "contenttagid": 
            case "contentTagId": {
                target.setContentTagId(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "contenttype": 
            case "contentType": {
                target.setContentType(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "email": {
                target.setEmail(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "endtime": 
            case "endTime": {
                target.setEndTime(ZendeskEndpointConfigurationConfigurer.property(camelContext, Date.class, value));
                return true;
            }
            case "externalid": 
            case "externalId": {
                target.setExternalId(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "externalid0": 
            case "externalId0": {
                target.setExternalId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "externalid0s": 
            case "externalId0s": {
                target.setExternalId0s(ZendeskEndpointConfigurationConfigurer.property(camelContext, long[].class, value));
                return true;
            }
            case "externalids": 
            case "externalIds": {
                target.setExternalIds(ZendeskEndpointConfigurationConfigurer.property(camelContext, String[].class, value));
                return true;
            }
            case "field": {
                target.setField(ZendeskEndpointConfigurationConfigurer.property(camelContext, Field.class, value));
                return true;
            }
            case "file": {
                target.setFile(ZendeskEndpointConfigurationConfigurer.property(camelContext, File.class, value));
                return true;
            }
            case "filename": 
            case "fileName": {
                target.setFileName(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "forum": {
                target.setForum(ZendeskEndpointConfigurationConfigurer.property(camelContext, Forum.class, value));
                return true;
            }
            case "forum_id": {
                target.setForum_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "group": {
                target.setGroup(ZendeskEndpointConfigurationConfigurer.property(camelContext, Group.class, value));
                return true;
            }
            case "groupmembership": 
            case "groupMembership": {
                target.setGroupMembership(ZendeskEndpointConfigurationConfigurer.property(camelContext, GroupMembership.class, value));
                return true;
            }
            case "group_id": {
                target.setGroup_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "group_membership_id": {
                target.setGroup_membership_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "id": {
                target.setId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "idarticle": 
            case "idArticle": {
                target.setIdArticle(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "identity": {
                target.setIdentity(ZendeskEndpointConfigurationConfigurer.property(camelContext, Identity.class, value));
                return true;
            }
            case "identityid": 
            case "identityId": {
                target.setIdentityId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "ids": {
                target.setIds(ZendeskEndpointConfigurationConfigurer.property(camelContext, long[].class, value));
                return true;
            }
            case "includearchived": 
            case "includeArchived": {
                target.setIncludeArchived(ZendeskEndpointConfigurationConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "inline": {
                target.setInline(ZendeskEndpointConfigurationConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "installationid": 
            case "installationId": {
                target.setInstallationId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "item": {
                target.setItem(ZendeskEndpointConfigurationConfigurer.property(camelContext, DynamicContentItem.class, value));
                return true;
            }
            case "itemid": 
            case "itemId": {
                target.setItemId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "json": {
                target.setJson(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "labels": {
                target.setLabels(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "locale": {
                target.setLocale(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "macro": {
                target.setMacro(ZendeskEndpointConfigurationConfigurer.property(camelContext, Macro.class, value));
                return true;
            }
            case "macroid": 
            case "macroId": {
                target.setMacroId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "macroid0": 
            case "macroId0": {
                target.setMacroId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "methodname": 
            case "methodName": {
                target.setMethodName(ZendeskEndpointConfigurationConfigurer.property(camelContext, ZendeskApiMethod.class, value));
                return true;
            }
            case "monitorid": 
            case "monitorId": {
                target.setMonitorId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "name": {
                target.setName(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "nameprefix": 
            case "namePrefix": {
                target.setNamePrefix(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "newpassword": 
            case "newPassword": {
                target.setNewPassword(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "notifysubscribers": 
            case "notifySubscribers": {
                target.setNotifySubscribers(ZendeskEndpointConfigurationConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "oauthtoken": 
            case "oauthToken": {
                target.setOauthToken(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "oldpassword": 
            case "oldPassword": {
                target.setOldPassword(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "order": {
                target.setOrder(ZendeskEndpointConfigurationConfigurer.property(camelContext, SortOrder.class, value));
                return true;
            }
            case "organization": {
                target.setOrganization(ZendeskEndpointConfigurationConfigurer.property(camelContext, Organization.class, value));
                return true;
            }
            case "organizationid": 
            case "organizationId": {
                target.setOrganizationId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "organizationlist": 
            case "organizationList": {
                target.setOrganizationList(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "organizationmembership": 
            case "organizationMembership": {
                target.setOrganizationMembership(ZendeskEndpointConfigurationConfigurer.property(camelContext, OrganizationMembership.class, value));
                return true;
            }
            case "organizationmembershiplist": 
            case "organizationMembershipList": {
                target.setOrganizationMembershipList(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "organizationmemberships": 
            case "organizationMemberships": {
                target.setOrganizationMemberships(ZendeskEndpointConfigurationConfigurer.property(camelContext, OrganizationMembership[].class, value));
                return true;
            }
            case "organization_id": {
                target.setOrganization_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "organization_membership_id": {
                target.setOrganization_membership_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "organizations": {
                target.setOrganizations(ZendeskEndpointConfigurationConfigurer.property(camelContext, Organization[].class, value));
                return true;
            }
            case "page": {
                target.setPage(ZendeskEndpointConfigurationConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "pagesize": 
            case "pageSize": {
                target.setPageSize(ZendeskEndpointConfigurationConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "password": {
                target.setPassword(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "permissiongroup": 
            case "permissionGroup": {
                target.setPermissionGroup(ZendeskEndpointConfigurationConfigurer.property(camelContext, PermissionGroup.class, value));
                return true;
            }
            case "query": {
                target.setQuery(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "queryparams": 
            case "queryParams": {
                target.setQueryParams(ZendeskEndpointConfigurationConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "request": {
                target.setRequest(ZendeskEndpointConfigurationConfigurer.property(camelContext, Request.class, value));
                return true;
            }
            case "requestid": 
            case "requestId": {
                target.setRequestId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "role": {
                target.setRole(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "roles": {
                target.setRoles(ZendeskEndpointConfigurationConfigurer.property(camelContext, String[].class, value));
                return true;
            }
            case "satisfactionrating": 
            case "satisfactionRating": {
                target.setSatisfactionRating(ZendeskEndpointConfigurationConfigurer.property(camelContext, SatisfactionRating.class, value));
                return true;
            }
            case "schedule": {
                target.setSchedule(ZendeskEndpointConfigurationConfigurer.property(camelContext, Schedule.class, value));
                return true;
            }
            case "scheduleid": 
            case "scheduleId": {
                target.setScheduleId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "searchterm": 
            case "searchTerm": {
                target.setSearchTerm(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "section": {
                target.setSection(ZendeskEndpointConfigurationConfigurer.property(camelContext, Section.class, value));
                return true;
            }
            case "sectionid": 
            case "sectionId": {
                target.setSectionId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "sectionid0": 
            case "sectionId0": {
                target.setSectionId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                target.setServerUrl(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sortby": 
            case "sortBy": {
                target.setSortBy(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sortorder": 
            case "sortOrder": {
                target.setSortOrder(ZendeskEndpointConfigurationConfigurer.property(camelContext, SortOrder.class, value));
                return true;
            }
            case "starttime": 
            case "startTime": {
                target.setStartTime(ZendeskEndpointConfigurationConfigurer.property(camelContext, Date.class, value));
                return true;
            }
            case "status": {
                target.setStatus(ZendeskEndpointConfigurationConfigurer.property(camelContext, JobStatus.class, value));
                return true;
            }
            case "statuses": {
                target.setStatuses(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "suspendedticket": 
            case "suspendedTicket": {
                target.setSuspendedTicket(ZendeskEndpointConfigurationConfigurer.property(camelContext, SuspendedTicket.class, value));
                return true;
            }
            case "tags": {
                target.setTags(ZendeskEndpointConfigurationConfigurer.property(camelContext, String[].class, value));
                return true;
            }
            case "target": {
                target.setTarget(ZendeskEndpointConfigurationConfigurer.property(camelContext, Target.class, value));
                return true;
            }
            case "targetid": 
            case "targetId": {
                target.setTargetId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "ticket": {
                target.setTicket(ZendeskEndpointConfigurationConfigurer.property(camelContext, Ticket.class, value));
                return true;
            }
            case "ticketform": 
            case "ticketForm": {
                target.setTicketForm(ZendeskEndpointConfigurationConfigurer.property(camelContext, TicketForm.class, value));
                return true;
            }
            case "ticketid": 
            case "ticketId": {
                target.setTicketId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "ticketid0": 
            case "ticketId0": {
                target.setTicketId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "ticketimport": 
            case "ticketImport": {
                target.setTicketImport(ZendeskEndpointConfigurationConfigurer.property(camelContext, TicketImport.class, value));
                return true;
            }
            case "ticketlist": 
            case "ticketList": {
                target.setTicketList(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "tickets": {
                target.setTickets(ZendeskEndpointConfigurationConfigurer.property(camelContext, Ticket[].class, value));
                return true;
            }
            case "token": {
                target.setToken(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "topic": {
                target.setTopic(ZendeskEndpointConfigurationConfigurer.property(camelContext, Topic.class, value));
                return true;
            }
            case "translation": {
                target.setTranslation(ZendeskEndpointConfigurationConfigurer.property(camelContext, Translation.class, value));
                return true;
            }
            case "translationid": 
            case "translationId": {
                target.setTranslationId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "trigger": {
                target.setTrigger(ZendeskEndpointConfigurationConfigurer.property(camelContext, Trigger.class, value));
                return true;
            }
            case "triggerid": 
            case "triggerId": {
                target.setTriggerId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "triggerid0": 
            case "triggerId0": {
                target.setTriggerId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "tweetid": 
            case "tweetId": {
                target.setTweetId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "unixepochtime": 
            case "unixEpochTime": {
                target.setUnixEpochTime(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "upload": {
                target.setUpload(ZendeskEndpointConfigurationConfigurer.property(camelContext, Attachment.Upload.class, value));
                return true;
            }
            case "user": {
                target.setUser(ZendeskEndpointConfigurationConfigurer.property(camelContext, User.class, value));
                return true;
            }
            case "userid": 
            case "userId": {
                target.setUserId(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "userid0": 
            case "userId0": {
                target.setUserId0(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "useridthatwillbemerged": 
            case "userIdThatWillBeMerged": {
                target.setUserIdThatWillBeMerged(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "useridthatwillremain": 
            case "userIdThatWillRemain": {
                target.setUserIdThatWillRemain(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "userlist": 
            case "userList": {
                target.setUserList(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "usersegment": 
            case "userSegment": {
                target.setUserSegment(ZendeskEndpointConfigurationConfigurer.property(camelContext, UserSegment.class, value));
                return true;
            }
            case "user_id": {
                target.setUser_id(ZendeskEndpointConfigurationConfigurer.property(camelContext, Long.class, value));
                return true;
            }
            case "username": {
                target.setUsername(ZendeskEndpointConfigurationConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "users": {
                target.setUsers(ZendeskEndpointConfigurationConfigurer.property(camelContext, User[].class, value));
                return true;
            }
            case "userslist": 
            case "usersList": {
                target.setUsersList(ZendeskEndpointConfigurationConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "variant": {
                target.setVariant(ZendeskEndpointConfigurationConfigurer.property(camelContext, DynamicContentItemVariant.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "active": {
                return Boolean.class;
            }
            case "article": {
                return Article.class;
            }
            case "articleattachments": 
            case "articleAttachments": {
                return ArticleAttachments.class;
            }
            case "articleid": 
            case "articleId": {
                return Long.class;
            }
            case "articleid0": 
            case "articleId0": {
                return Long.class;
            }
            case "attachment": {
                return Attachment.class;
            }
            case "attachments": {
                return List.class;
            }
            case "audit": {
                return Audit.class;
            }
            case "auditid": 
            case "auditId": {
                return Long.class;
            }
            case "automation": {
                return Automation.class;
            }
            case "automationid": 
            case "automationId": {
                return Long.class;
            }
            case "automationid0": 
            case "automationId0": {
                return Long.class;
            }
            case "category": {
                return Category.class;
            }
            case "categoryid": 
            case "categoryId": {
                return Long.class;
            }
            case "categoryid0": 
            case "categoryId0": {
                return String.class;
            }
            case "categoryid1": 
            case "categoryId1": {
                return Long.class;
            }
            case "category_id": {
                return Long.class;
            }
            case "comment": {
                return Comment.class;
            }
            case "commentid": 
            case "commentId": {
                return Long.class;
            }
            case "content": {
                return byte[].class;
            }
            case "contenttag": 
            case "contentTag": {
                return ContentTag.class;
            }
            case "contenttagid": 
            case "contentTagId": {
                return String.class;
            }
            case "contenttype": 
            case "contentType": {
                return String.class;
            }
            case "email": {
                return String.class;
            }
            case "endtime": 
            case "endTime": {
                return Date.class;
            }
            case "externalid": 
            case "externalId": {
                return String.class;
            }
            case "externalid0": 
            case "externalId0": {
                return Long.class;
            }
            case "externalid0s": 
            case "externalId0s": {
                return long[].class;
            }
            case "externalids": 
            case "externalIds": {
                return String[].class;
            }
            case "field": {
                return Field.class;
            }
            case "file": {
                return File.class;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "forum": {
                return Forum.class;
            }
            case "forum_id": {
                return Long.class;
            }
            case "group": {
                return Group.class;
            }
            case "groupmembership": 
            case "groupMembership": {
                return GroupMembership.class;
            }
            case "group_id": {
                return Long.class;
            }
            case "group_membership_id": {
                return Long.class;
            }
            case "id": {
                return Long.class;
            }
            case "idarticle": 
            case "idArticle": {
                return String.class;
            }
            case "identity": {
                return Identity.class;
            }
            case "identityid": 
            case "identityId": {
                return Long.class;
            }
            case "ids": {
                return long[].class;
            }
            case "includearchived": 
            case "includeArchived": {
                return Boolean.class;
            }
            case "inline": {
                return Boolean.class;
            }
            case "installationid": 
            case "installationId": {
                return Integer.class;
            }
            case "item": {
                return DynamicContentItem.class;
            }
            case "itemid": 
            case "itemId": {
                return Long.class;
            }
            case "json": {
                return String.class;
            }
            case "labels": {
                return List.class;
            }
            case "locale": {
                return String.class;
            }
            case "macro": {
                return Macro.class;
            }
            case "macroid": 
            case "macroId": {
                return Long.class;
            }
            case "macroid0": 
            case "macroId0": {
                return Long.class;
            }
            case "methodname": 
            case "methodName": {
                return ZendeskApiMethod.class;
            }
            case "monitorid": 
            case "monitorId": {
                return Long.class;
            }
            case "name": {
                return String.class;
            }
            case "nameprefix": 
            case "namePrefix": {
                return String.class;
            }
            case "newpassword": 
            case "newPassword": {
                return String.class;
            }
            case "notifysubscribers": 
            case "notifySubscribers": {
                return Boolean.class;
            }
            case "oauthtoken": 
            case "oauthToken": {
                return String.class;
            }
            case "oldpassword": 
            case "oldPassword": {
                return String.class;
            }
            case "order": {
                return SortOrder.class;
            }
            case "organization": {
                return Organization.class;
            }
            case "organizationid": 
            case "organizationId": {
                return Long.class;
            }
            case "organizationlist": 
            case "organizationList": {
                return List.class;
            }
            case "organizationmembership": 
            case "organizationMembership": {
                return OrganizationMembership.class;
            }
            case "organizationmembershiplist": 
            case "organizationMembershipList": {
                return List.class;
            }
            case "organizationmemberships": 
            case "organizationMemberships": {
                return OrganizationMembership[].class;
            }
            case "organization_id": {
                return Long.class;
            }
            case "organization_membership_id": {
                return Long.class;
            }
            case "organizations": {
                return Organization[].class;
            }
            case "page": {
                return Integer.class;
            }
            case "pagesize": 
            case "pageSize": {
                return Integer.class;
            }
            case "password": {
                return String.class;
            }
            case "permissiongroup": 
            case "permissionGroup": {
                return PermissionGroup.class;
            }
            case "query": {
                return String.class;
            }
            case "queryparams": 
            case "queryParams": {
                return Map.class;
            }
            case "request": {
                return Request.class;
            }
            case "requestid": 
            case "requestId": {
                return Long.class;
            }
            case "role": {
                return String.class;
            }
            case "roles": {
                return String[].class;
            }
            case "satisfactionrating": 
            case "satisfactionRating": {
                return SatisfactionRating.class;
            }
            case "schedule": {
                return Schedule.class;
            }
            case "scheduleid": 
            case "scheduleId": {
                return Long.class;
            }
            case "searchterm": 
            case "searchTerm": {
                return String.class;
            }
            case "section": {
                return Section.class;
            }
            case "sectionid": 
            case "sectionId": {
                return Long.class;
            }
            case "sectionid0": 
            case "sectionId0": {
                return Long.class;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "sortby": 
            case "sortBy": {
                return String.class;
            }
            case "sortorder": 
            case "sortOrder": {
                return SortOrder.class;
            }
            case "starttime": 
            case "startTime": {
                return Date.class;
            }
            case "status": {
                return JobStatus.class;
            }
            case "statuses": {
                return List.class;
            }
            case "suspendedticket": 
            case "suspendedTicket": {
                return SuspendedTicket.class;
            }
            case "tags": {
                return String[].class;
            }
            case "target": {
                return Target.class;
            }
            case "targetid": 
            case "targetId": {
                return Long.class;
            }
            case "ticket": {
                return Ticket.class;
            }
            case "ticketform": 
            case "ticketForm": {
                return TicketForm.class;
            }
            case "ticketid": 
            case "ticketId": {
                return Long.class;
            }
            case "ticketid0": 
            case "ticketId0": {
                return Long.class;
            }
            case "ticketimport": 
            case "ticketImport": {
                return TicketImport.class;
            }
            case "ticketlist": 
            case "ticketList": {
                return List.class;
            }
            case "tickets": {
                return Ticket[].class;
            }
            case "token": {
                return String.class;
            }
            case "topic": {
                return Topic.class;
            }
            case "translation": {
                return Translation.class;
            }
            case "translationid": 
            case "translationId": {
                return Long.class;
            }
            case "trigger": {
                return Trigger.class;
            }
            case "triggerid": 
            case "triggerId": {
                return Long.class;
            }
            case "triggerid0": 
            case "triggerId0": {
                return Long.class;
            }
            case "tweetid": 
            case "tweetId": {
                return Long.class;
            }
            case "unixepochtime": 
            case "unixEpochTime": {
                return Long.class;
            }
            case "upload": {
                return Attachment.Upload.class;
            }
            case "user": {
                return User.class;
            }
            case "userid": 
            case "userId": {
                return Long.class;
            }
            case "userid0": 
            case "userId0": {
                return Long.class;
            }
            case "useridthatwillbemerged": 
            case "userIdThatWillBeMerged": {
                return Long.class;
            }
            case "useridthatwillremain": 
            case "userIdThatWillRemain": {
                return Long.class;
            }
            case "userlist": 
            case "userList": {
                return List.class;
            }
            case "usersegment": 
            case "userSegment": {
                return UserSegment.class;
            }
            case "user_id": {
                return Long.class;
            }
            case "username": {
                return String.class;
            }
            case "users": {
                return User[].class;
            }
            case "userslist": 
            case "usersList": {
                return List.class;
            }
            case "variant": {
                return DynamicContentItemVariant.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskEndpointConfiguration target = (ZendeskEndpointConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "active": {
                return target.getActive();
            }
            case "article": {
                return target.getArticle();
            }
            case "articleattachments": 
            case "articleAttachments": {
                return target.getArticleAttachments();
            }
            case "articleid": 
            case "articleId": {
                return target.getArticleId();
            }
            case "articleid0": 
            case "articleId0": {
                return target.getArticleId0();
            }
            case "attachment": {
                return target.getAttachment();
            }
            case "attachments": {
                return target.getAttachments();
            }
            case "audit": {
                return target.getAudit();
            }
            case "auditid": 
            case "auditId": {
                return target.getAuditId();
            }
            case "automation": {
                return target.getAutomation();
            }
            case "automationid": 
            case "automationId": {
                return target.getAutomationId();
            }
            case "automationid0": 
            case "automationId0": {
                return target.getAutomationId0();
            }
            case "category": {
                return target.getCategory();
            }
            case "categoryid": 
            case "categoryId": {
                return target.getCategoryId();
            }
            case "categoryid0": 
            case "categoryId0": {
                return target.getCategoryId0();
            }
            case "categoryid1": 
            case "categoryId1": {
                return target.getCategoryId1();
            }
            case "category_id": {
                return target.getCategory_id();
            }
            case "comment": {
                return target.getComment();
            }
            case "commentid": 
            case "commentId": {
                return target.getCommentId();
            }
            case "content": {
                return target.getContent();
            }
            case "contenttag": 
            case "contentTag": {
                return target.getContentTag();
            }
            case "contenttagid": 
            case "contentTagId": {
                return target.getContentTagId();
            }
            case "contenttype": 
            case "contentType": {
                return target.getContentType();
            }
            case "email": {
                return target.getEmail();
            }
            case "endtime": 
            case "endTime": {
                return target.getEndTime();
            }
            case "externalid": 
            case "externalId": {
                return target.getExternalId();
            }
            case "externalid0": 
            case "externalId0": {
                return target.getExternalId0();
            }
            case "externalid0s": 
            case "externalId0s": {
                return target.getExternalId0s();
            }
            case "externalids": 
            case "externalIds": {
                return target.getExternalIds();
            }
            case "field": {
                return target.getField();
            }
            case "file": {
                return target.getFile();
            }
            case "filename": 
            case "fileName": {
                return target.getFileName();
            }
            case "forum": {
                return target.getForum();
            }
            case "forum_id": {
                return target.getForum_id();
            }
            case "group": {
                return target.getGroup();
            }
            case "groupmembership": 
            case "groupMembership": {
                return target.getGroupMembership();
            }
            case "group_id": {
                return target.getGroup_id();
            }
            case "group_membership_id": {
                return target.getGroup_membership_id();
            }
            case "id": {
                return target.getId();
            }
            case "idarticle": 
            case "idArticle": {
                return target.getIdArticle();
            }
            case "identity": {
                return target.getIdentity();
            }
            case "identityid": 
            case "identityId": {
                return target.getIdentityId();
            }
            case "ids": {
                return target.getIds();
            }
            case "includearchived": 
            case "includeArchived": {
                return target.getIncludeArchived();
            }
            case "inline": {
                return target.getInline();
            }
            case "installationid": 
            case "installationId": {
                return target.getInstallationId();
            }
            case "item": {
                return target.getItem();
            }
            case "itemid": 
            case "itemId": {
                return target.getItemId();
            }
            case "json": {
                return target.getJson();
            }
            case "labels": {
                return target.getLabels();
            }
            case "locale": {
                return target.getLocale();
            }
            case "macro": {
                return target.getMacro();
            }
            case "macroid": 
            case "macroId": {
                return target.getMacroId();
            }
            case "macroid0": 
            case "macroId0": {
                return target.getMacroId0();
            }
            case "methodname": 
            case "methodName": {
                return target.getMethodName();
            }
            case "monitorid": 
            case "monitorId": {
                return target.getMonitorId();
            }
            case "name": {
                return target.getName();
            }
            case "nameprefix": 
            case "namePrefix": {
                return target.getNamePrefix();
            }
            case "newpassword": 
            case "newPassword": {
                return target.getNewPassword();
            }
            case "notifysubscribers": 
            case "notifySubscribers": {
                return target.getNotifySubscribers();
            }
            case "oauthtoken": 
            case "oauthToken": {
                return target.getOauthToken();
            }
            case "oldpassword": 
            case "oldPassword": {
                return target.getOldPassword();
            }
            case "order": {
                return target.getOrder();
            }
            case "organization": {
                return target.getOrganization();
            }
            case "organizationid": 
            case "organizationId": {
                return target.getOrganizationId();
            }
            case "organizationlist": 
            case "organizationList": {
                return target.getOrganizationList();
            }
            case "organizationmembership": 
            case "organizationMembership": {
                return target.getOrganizationMembership();
            }
            case "organizationmembershiplist": 
            case "organizationMembershipList": {
                return target.getOrganizationMembershipList();
            }
            case "organizationmemberships": 
            case "organizationMemberships": {
                return target.getOrganizationMemberships();
            }
            case "organization_id": {
                return target.getOrganization_id();
            }
            case "organization_membership_id": {
                return target.getOrganization_membership_id();
            }
            case "organizations": {
                return target.getOrganizations();
            }
            case "page": {
                return target.getPage();
            }
            case "pagesize": 
            case "pageSize": {
                return target.getPageSize();
            }
            case "password": {
                return target.getPassword();
            }
            case "permissiongroup": 
            case "permissionGroup": {
                return target.getPermissionGroup();
            }
            case "query": {
                return target.getQuery();
            }
            case "queryparams": 
            case "queryParams": {
                return target.getQueryParams();
            }
            case "request": {
                return target.getRequest();
            }
            case "requestid": 
            case "requestId": {
                return target.getRequestId();
            }
            case "role": {
                return target.getRole();
            }
            case "roles": {
                return target.getRoles();
            }
            case "satisfactionrating": 
            case "satisfactionRating": {
                return target.getSatisfactionRating();
            }
            case "schedule": {
                return target.getSchedule();
            }
            case "scheduleid": 
            case "scheduleId": {
                return target.getScheduleId();
            }
            case "searchterm": 
            case "searchTerm": {
                return target.getSearchTerm();
            }
            case "section": {
                return target.getSection();
            }
            case "sectionid": 
            case "sectionId": {
                return target.getSectionId();
            }
            case "sectionid0": 
            case "sectionId0": {
                return target.getSectionId0();
            }
            case "serverurl": 
            case "serverUrl": {
                return target.getServerUrl();
            }
            case "sortby": 
            case "sortBy": {
                return target.getSortBy();
            }
            case "sortorder": 
            case "sortOrder": {
                return target.getSortOrder();
            }
            case "starttime": 
            case "startTime": {
                return target.getStartTime();
            }
            case "status": {
                return target.getStatus();
            }
            case "statuses": {
                return target.getStatuses();
            }
            case "suspendedticket": 
            case "suspendedTicket": {
                return target.getSuspendedTicket();
            }
            case "tags": {
                return target.getTags();
            }
            case "target": {
                return target.getTarget();
            }
            case "targetid": 
            case "targetId": {
                return target.getTargetId();
            }
            case "ticket": {
                return target.getTicket();
            }
            case "ticketform": 
            case "ticketForm": {
                return target.getTicketForm();
            }
            case "ticketid": 
            case "ticketId": {
                return target.getTicketId();
            }
            case "ticketid0": 
            case "ticketId0": {
                return target.getTicketId0();
            }
            case "ticketimport": 
            case "ticketImport": {
                return target.getTicketImport();
            }
            case "ticketlist": 
            case "ticketList": {
                return target.getTicketList();
            }
            case "tickets": {
                return target.getTickets();
            }
            case "token": {
                return target.getToken();
            }
            case "topic": {
                return target.getTopic();
            }
            case "translation": {
                return target.getTranslation();
            }
            case "translationid": 
            case "translationId": {
                return target.getTranslationId();
            }
            case "trigger": {
                return target.getTrigger();
            }
            case "triggerid": 
            case "triggerId": {
                return target.getTriggerId();
            }
            case "triggerid0": 
            case "triggerId0": {
                return target.getTriggerId0();
            }
            case "tweetid": 
            case "tweetId": {
                return target.getTweetId();
            }
            case "unixepochtime": 
            case "unixEpochTime": {
                return target.getUnixEpochTime();
            }
            case "upload": {
                return target.getUpload();
            }
            case "user": {
                return target.getUser();
            }
            case "userid": 
            case "userId": {
                return target.getUserId();
            }
            case "userid0": 
            case "userId0": {
                return target.getUserId0();
            }
            case "useridthatwillbemerged": 
            case "userIdThatWillBeMerged": {
                return target.getUserIdThatWillBeMerged();
            }
            case "useridthatwillremain": 
            case "userIdThatWillRemain": {
                return target.getUserIdThatWillRemain();
            }
            case "userlist": 
            case "userList": {
                return target.getUserList();
            }
            case "usersegment": 
            case "userSegment": {
                return target.getUserSegment();
            }
            case "user_id": {
                return target.getUser_id();
            }
            case "username": {
                return target.getUsername();
            }
            case "users": {
                return target.getUsers();
            }
            case "userslist": 
            case "usersList": {
                return target.getUsersList();
            }
            case "variant": {
                return target.getVariant();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "attachments": {
                return Attachment.class;
            }
            case "labels": {
                return String.class;
            }
            case "organizationlist": 
            case "organizationList": {
                return Organization.class;
            }
            case "organizationmembershiplist": 
            case "organizationMembershipList": {
                return OrganizationMembership.class;
            }
            case "queryparams": 
            case "queryParams": {
                return Object.class;
            }
            case "statuses": {
                return JobStatus.class;
            }
            case "ticketlist": 
            case "ticketList": {
                return Ticket.class;
            }
            case "userlist": 
            case "userList": {
                return User.class;
            }
            case "userslist": 
            case "usersList": {
                return User.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Active", Boolean.class);
        map.put("Article", Article.class);
        map.put("ArticleAttachments", ArticleAttachments.class);
        map.put("ArticleId", Long.class);
        map.put("ArticleId0", Long.class);
        map.put("Attachment", Attachment.class);
        map.put("Attachments", List.class);
        map.put("Audit", Audit.class);
        map.put("AuditId", Long.class);
        map.put("Automation", Automation.class);
        map.put("AutomationId", Long.class);
        map.put("AutomationId0", Long.class);
        map.put("Category", Category.class);
        map.put("CategoryId", Long.class);
        map.put("CategoryId0", String.class);
        map.put("CategoryId1", Long.class);
        map.put("Category_id", Long.class);
        map.put("Comment", Comment.class);
        map.put("CommentId", Long.class);
        map.put("Content", byte[].class);
        map.put("ContentTag", ContentTag.class);
        map.put("ContentTagId", String.class);
        map.put("ContentType", String.class);
        map.put("Email", String.class);
        map.put("EndTime", Date.class);
        map.put("ExternalId", String.class);
        map.put("ExternalId0", Long.class);
        map.put("ExternalId0s", long[].class);
        map.put("ExternalIds", String[].class);
        map.put("Field", Field.class);
        map.put("File", File.class);
        map.put("FileName", String.class);
        map.put("Forum", Forum.class);
        map.put("Forum_id", Long.class);
        map.put("Group", Group.class);
        map.put("GroupMembership", GroupMembership.class);
        map.put("Group_id", Long.class);
        map.put("Group_membership_id", Long.class);
        map.put("Id", Long.class);
        map.put("IdArticle", String.class);
        map.put("Identity", Identity.class);
        map.put("IdentityId", Long.class);
        map.put("Ids", long[].class);
        map.put("IncludeArchived", Boolean.class);
        map.put("Inline", Boolean.class);
        map.put("InstallationId", Integer.class);
        map.put("Item", DynamicContentItem.class);
        map.put("ItemId", Long.class);
        map.put("Json", String.class);
        map.put("Labels", List.class);
        map.put("Locale", String.class);
        map.put("Macro", Macro.class);
        map.put("MacroId", Long.class);
        map.put("MacroId0", Long.class);
        map.put("MethodName", ZendeskApiMethod.class);
        map.put("MonitorId", Long.class);
        map.put("Name", String.class);
        map.put("NamePrefix", String.class);
        map.put("NewPassword", String.class);
        map.put("NotifySubscribers", Boolean.class);
        map.put("OauthToken", String.class);
        map.put("OldPassword", String.class);
        map.put("Order", SortOrder.class);
        map.put("Organization", Organization.class);
        map.put("OrganizationId", Long.class);
        map.put("OrganizationList", List.class);
        map.put("OrganizationMembership", OrganizationMembership.class);
        map.put("OrganizationMembershipList", List.class);
        map.put("OrganizationMemberships", OrganizationMembership[].class);
        map.put("Organization_id", Long.class);
        map.put("Organization_membership_id", Long.class);
        map.put("Organizations", Organization[].class);
        map.put("Page", Integer.class);
        map.put("PageSize", Integer.class);
        map.put("Password", String.class);
        map.put("PermissionGroup", PermissionGroup.class);
        map.put("Query", String.class);
        map.put("QueryParams", Map.class);
        map.put("Request", Request.class);
        map.put("RequestId", Long.class);
        map.put("Role", String.class);
        map.put("Roles", String[].class);
        map.put("SatisfactionRating", SatisfactionRating.class);
        map.put("Schedule", Schedule.class);
        map.put("ScheduleId", Long.class);
        map.put("SearchTerm", String.class);
        map.put("Section", Section.class);
        map.put("SectionId", Long.class);
        map.put("SectionId0", Long.class);
        map.put("ServerUrl", String.class);
        map.put("SortBy", String.class);
        map.put("SortOrder", SortOrder.class);
        map.put("StartTime", Date.class);
        map.put("Status", JobStatus.class);
        map.put("Statuses", List.class);
        map.put("SuspendedTicket", SuspendedTicket.class);
        map.put("Tags", String[].class);
        map.put("Target", Target.class);
        map.put("TargetId", Long.class);
        map.put("Ticket", Ticket.class);
        map.put("TicketForm", TicketForm.class);
        map.put("TicketId", Long.class);
        map.put("TicketId0", Long.class);
        map.put("TicketImport", TicketImport.class);
        map.put("TicketList", List.class);
        map.put("Tickets", Ticket[].class);
        map.put("Token", String.class);
        map.put("Topic", Topic.class);
        map.put("Translation", Translation.class);
        map.put("TranslationId", Long.class);
        map.put("Trigger", Trigger.class);
        map.put("TriggerId", Long.class);
        map.put("TriggerId0", Long.class);
        map.put("TweetId", Long.class);
        map.put("UnixEpochTime", Long.class);
        map.put("Upload", Attachment.Upload.class);
        map.put("User", User.class);
        map.put("UserId", Long.class);
        map.put("UserId0", Long.class);
        map.put("UserIdThatWillBeMerged", Long.class);
        map.put("UserIdThatWillRemain", Long.class);
        map.put("UserList", List.class);
        map.put("UserSegment", UserSegment.class);
        map.put("User_id", Long.class);
        map.put("Username", String.class);
        map.put("Users", User[].class);
        map.put("UsersList", List.class);
        map.put("Variant", DynamicContentItemVariant.class);
        ALL_OPTIONS = map;
    }
}

