/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyRequestSender requestSender;
    private final NettyResponseFuture<T> future;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, ConnectionSemaphore connectionSemaphore) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.connectionSemaphore = connectionSemaphore;
    }

    private boolean futureIsAlreadyCancelled(Channel channel) {
        if (this.future.isCancelled()) {
            Channels.silentlyCloseChannel(channel);
            return true;
        }
        return false;
    }

    private void writeRequest(Channel channel) {
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = this.future.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using new Channel '{}' for '{}' to '{}'", new Object[]{channel, httpRequest.method(), httpRequest.uri()});
        }
        Channels.setAttribute(channel, this.future);
        this.channelManager.registerOpenChannel(channel);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    public void onSuccess(final Channel channel, InetSocketAddress remoteAddress) {
        Object partitionKeyLock;
        if (this.connectionSemaphore != null && (partitionKeyLock = this.future.takePartitionKeyLock()) != null) {
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.connectionSemaphore.releaseChannelLock(partitionKeyLock)));
        }
        Channels.setActiveToken(channel);
        TimeoutsHolder timeoutsHolder = this.future.getTimeoutsHolder();
        if (this.futureIsAlreadyCancelled(channel)) {
            return;
        }
        Request request = this.future.getTargetRequest();
        Uri uri = request.getUri();
        timeoutsHolder.setResolvedRemoteAddress(remoteAddress);
        ProxyServer proxyServer = this.future.getProxyServer();
        if ((proxyServer == null || proxyServer.getProxyType().isSocks()) && uri.isSecured()) {
            SslHandler sslHandler;
            try {
                sslHandler = this.channelManager.addSslHandler(channel.pipeline(), uri, request.getVirtualHost(), proxyServer != null);
            }
            catch (Exception sslError) {
                this.onFailure(channel, sslError);
                return;
            }
            final AsyncHandler<T> asyncHandler = this.future.getAsyncHandler();
            try {
                asyncHandler.onTlsHandshakeAttempt();
            }
            catch (Exception e) {
                LOGGER.error("onTlsHandshakeAttempt crashed", (Throwable)e);
                this.onFailure(channel, e);
                return;
            }
            sslHandler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new SimpleFutureListener<Channel>(){

                @Override
                protected void onSuccess(Channel value) {
                    try {
                        asyncHandler.onTlsHandshakeSuccess(sslHandler.engine().getSession());
                    }
                    catch (Exception e) {
                        LOGGER.error("onTlsHandshakeSuccess crashed", (Throwable)e);
                        NettyConnectListener.this.onFailure(channel, e);
                        return;
                    }
                    NettyConnectListener.this.writeRequest(channel);
                }

                @Override
                protected void onFailure(Throwable cause) {
                    try {
                        asyncHandler.onTlsHandshakeFailure(cause);
                    }
                    catch (Exception e) {
                        LOGGER.error("onTlsHandshakeFailure crashed", (Throwable)e);
                        NettyConnectListener.this.onFailure(channel, e);
                        return;
                    }
                    NettyConnectListener.this.onFailure(channel, cause);
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    public void onFailure(Channel channel, Throwable cause) {
        Channels.silentlyCloseChannel(channel);
        boolean canRetry = this.future.incrementRetryAndCheck();
        LOGGER.debug("Trying to recover from failing to connect channel {} with a retry value of {} ", (Object)channel, (Object)canRetry);
        if (canRetry && cause != null && (this.future.getChannelState() != ChannelState.NEW || StackTraceInspector.recoverOnNettyDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        String message = cause.getMessage() != null ? cause.getMessage() : this.future.getUri().getBaseUrl();
        ConnectException e = new ConnectException(message);
        e.initCause(cause);
        this.future.abort(e);
    }
}

