/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.io.Closeable;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpoint;
import org.apache.camel.component.zendesk.internal.ZendeskApiCollection;
import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.component.zendesk.internal.ZendeskApiName;
import org.apache.camel.component.zendesk.internal.ZendeskHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.util.IOHelper;
import org.zendesk.client.v2.Zendesk;

@Component(value="zendesk")
public class ZendeskComponent
extends AbstractApiComponent<ZendeskApiName, ZendeskConfiguration, ZendeskApiCollection> {
    @Metadata
    private String serverUrl;
    @Metadata(label="security", secret=true)
    private String username;
    @Metadata(label="security", secret=true)
    private String oauthToken;
    @Metadata(label="security", secret=true)
    private String token;
    @Metadata(label="security", secret=true)
    private String password;
    @Metadata(label="advanced")
    private Zendesk zendesk;

    public ZendeskComponent() {
        super(ZendeskApiName.class, ZendeskApiCollection.getCollection());
    }

    public ZendeskComponent(CamelContext context) {
        super(context, ZendeskApiName.class, ZendeskApiCollection.getCollection());
    }

    @Override
    protected ZendeskApiName getApiName(String apiNameStr) {
        return this.getCamelContext().getTypeConverter().convertTo(ZendeskApiName.class, apiNameStr);
    }

    @Override
    public void setConfiguration(ZendeskConfiguration configuration) {
        super.setConfiguration(configuration);
    }

    @Override
    public ZendeskConfiguration getConfiguration() {
        return (ZendeskConfiguration)super.getConfiguration();
    }

    public Zendesk getZendesk() {
        return this.zendesk;
    }

    public void setZendesk(Zendesk zendesk) {
        this.zendesk = zendesk;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String user) {
        this.username = user;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String token) {
        this.oauthToken = token;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String methodName, ZendeskApiName apiName, ZendeskConfiguration endpointConfiguration) {
        endpointConfiguration.setMethodName(this.getCamelContext().getTypeConverter().convertTo(ZendeskApiMethod.class, methodName));
        if (endpointConfiguration.getServerUrl() == null) {
            endpointConfiguration.setServerUrl(this.serverUrl);
        }
        if (endpointConfiguration.getUsername() == null) {
            endpointConfiguration.setUsername(this.username);
        }
        if (endpointConfiguration.getPassword() == null) {
            endpointConfiguration.setPassword(this.password);
        }
        if (endpointConfiguration.getOauthToken() == null) {
            endpointConfiguration.setOauthToken(this.oauthToken);
        }
        return new ZendeskEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.zendesk == null && this.configuration != null) {
            this.zendesk = ZendeskHelper.create((ZendeskConfiguration)this.configuration);
        }
    }

    @Override
    protected void doStop() throws Exception {
        IOHelper.close((Closeable)this.zendesk);
        super.doStop();
    }
}

