/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.asynchttpclient.ListenableFuture;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Metric;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SortOrder;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketCount;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.UserRelatedInfo;
import org.zendesk.client.v2.model.dynamic.DynamicContentItem;
import org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.ContentTag;
import org.zendesk.client.v2.model.hc.Locales;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.Target;

public enum ZendeskApiMethod implements ApiMethod
{
    ADD_TAG_TO_ORGANISATIONS(List.class, "addTagToOrganisations", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    ADD_TAG_TO_TICKET(List.class, "addTagToTicket", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    ADD_TAG_TO_TOPICS(List.class, "addTagToTopics", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    ASSOCIATE_ATTACHMENTS_TO_ARTICLE(Void.TYPE, "associateAttachmentsToArticle", ApiMethodArg.arg("idArticle", String.class), ApiMethodArg.arg("attachments", List.class)),
    CHANGE_USER_PASSWORD(Void.TYPE, "changeUserPassword", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("oldPassword", String.class), ApiMethodArg.arg("newPassword", String.class)),
    CREATE_ARTICLE(Article.class, "createArticle", ApiMethodArg.arg("article", Article.class)),
    CREATE_ARTICLE_1(Article.class, "createArticle", ApiMethodArg.arg("article", Article.class), ApiMethodArg.arg("notifySubscribers", Boolean.TYPE)),
    CREATE_ARTICLE_TRANSLATION(Translation.class, "createArticleTranslation", ApiMethodArg.arg("articleId", Long.class), ApiMethodArg.arg("translation", Translation.class)),
    CREATE_AUTOMATION(Automation.class, "createAutomation", ApiMethodArg.arg("automation", Automation.class)),
    CREATE_CATEGORY(Category.class, "createCategory", ApiMethodArg.arg("category", Category.class)),
    CREATE_CATEGORY_TRANSLATION(Translation.class, "createCategoryTranslation", ApiMethodArg.arg("categoryId", Long.class), ApiMethodArg.arg("translation", Translation.class)),
    CREATE_COMMENT(Ticket.class, "createComment", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("comment", Comment.class)),
    CREATE_CONTENT_TAG(ContentTag.class, "createContentTag", ApiMethodArg.arg("contentTag", ContentTag.class)),
    CREATE_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "createDynamicContentItem", ApiMethodArg.arg("item", DynamicContentItem.class)),
    CREATE_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "createDynamicContentItemVariant", ApiMethodArg.arg("itemId", Long.class), ApiMethodArg.arg("variant", DynamicContentItemVariant.class)),
    CREATE_FORUM(Forum.class, "createForum", ApiMethodArg.arg("forum", Forum.class)),
    CREATE_GROUP(Group.class, "createGroup", ApiMethodArg.arg("group", Group.class)),
    CREATE_GROUP_MEMBERSHIP(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg("groupMembership", GroupMembership.class)),
    CREATE_GROUP_MEMBERSHIP_1(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("groupMembership", GroupMembership.class)),
    CREATE_MACRO(Macro.class, "createMacro", ApiMethodArg.arg("macro", Macro.class)),
    CREATE_OR_UPDATE_ORGANIZATION(Organization.class, "createOrUpdateOrganization", ApiMethodArg.arg("organization", Organization.class)),
    CREATE_OR_UPDATE_USER(User.class, "createOrUpdateUser", ApiMethodArg.arg("user", User.class)),
    CREATE_OR_UPDATE_USERS(JobStatus.class, "createOrUpdateUsers", ApiMethodArg.arg("users", new User[0].getClass())),
    CREATE_OR_UPDATE_USERS_1(JobStatus.class, "createOrUpdateUsers", ApiMethodArg.arg("usersList", List.class)),
    CREATE_OR_UPDATE_USERS_ASYNC(ListenableFuture.class, "createOrUpdateUsersAsync", ApiMethodArg.arg("usersList", List.class)),
    CREATE_ORGANIZATION(Organization.class, "createOrganization", ApiMethodArg.arg("organization", Organization.class)),
    CREATE_ORGANIZATION_MEMBERSHIP(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg("organizationMembership", OrganizationMembership.class)),
    CREATE_ORGANIZATION_MEMBERSHIP_1(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("organizationMembership", OrganizationMembership.class)),
    CREATE_ORGANIZATION_MEMBERSHIPS(JobStatus.class, "createOrganizationMemberships", ApiMethodArg.arg("organizationMembershipList", List.class)),
    CREATE_ORGANIZATION_MEMBERSHIPS_1(JobStatus.class, "createOrganizationMemberships", ApiMethodArg.arg("organizationMemberships", new OrganizationMembership[0].getClass())),
    CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC(ListenableFuture.class, "createOrganizationMembershipsAsync", ApiMethodArg.arg("organizationMembershipList", List.class)),
    CREATE_ORGANIZATIONS(JobStatus.class, "createOrganizations", ApiMethodArg.arg("organizationList", List.class)),
    CREATE_ORGANIZATIONS_1(JobStatus.class, "createOrganizations", ApiMethodArg.arg("organizations", new Organization[0].getClass())),
    CREATE_ORGANIZATIONS_ASYNC(ListenableFuture.class, "createOrganizationsAsync", ApiMethodArg.arg("organizationList", List.class)),
    CREATE_PERMISSION_GROUP(PermissionGroup.class, "createPermissionGroup", ApiMethodArg.arg("permissionGroup", PermissionGroup.class)),
    CREATE_REQUEST(Request.class, "createRequest", ApiMethodArg.arg("request", Request.class)),
    CREATE_SATISFACTION_RATING(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("satisfactionRating", SatisfactionRating.class)),
    CREATE_SATISFACTION_RATING_1(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("satisfactionRating", SatisfactionRating.class)),
    CREATE_SECTION(Section.class, "createSection", ApiMethodArg.arg("section", Section.class)),
    CREATE_SECTION_TRANSLATION(Translation.class, "createSectionTranslation", ApiMethodArg.arg("sectionId", Long.class), ApiMethodArg.arg("translation", Translation.class)),
    CREATE_TARGET(Target.class, "createTarget", ApiMethodArg.arg("target", Target.class)),
    CREATE_TICKET(Ticket.class, "createTicket", ApiMethodArg.arg("ticket", Ticket.class)),
    CREATE_TICKET_ASYNC(ListenableFuture.class, "createTicketAsync", ApiMethodArg.arg("ticket", Ticket.class)),
    CREATE_TICKET_FIELD(Field.class, "createTicketField", ApiMethodArg.arg("field", Field.class)),
    CREATE_TICKET_FORM(TicketForm.class, "createTicketForm", ApiMethodArg.arg("ticketForm", TicketForm.class)),
    CREATE_TICKET_FROM_TWEET(Ticket.class, "createTicketFromTweet", ApiMethodArg.arg("tweetId", Long.TYPE), ApiMethodArg.arg("monitorId", Long.TYPE)),
    CREATE_TICKETS(JobStatus.class, "createTickets", ApiMethodArg.arg("ticketList", List.class)),
    CREATE_TICKETS_1(JobStatus.class, "createTickets", ApiMethodArg.arg("tickets", new Ticket[0].getClass())),
    CREATE_TICKETS_ASYNC(ListenableFuture.class, "createTicketsAsync", ApiMethodArg.arg("ticketList", List.class)),
    CREATE_TOPIC(Topic.class, "createTopic", ApiMethodArg.arg("topic", Topic.class)),
    CREATE_TRIGGER(Trigger.class, "createTrigger", ApiMethodArg.arg("trigger", Trigger.class)),
    CREATE_UPLOAD(Attachment.Upload.class, "createUpload", ApiMethodArg.arg("fileName", String.class), ApiMethodArg.arg("content", byte[].class)),
    CREATE_UPLOAD_1(Attachment.Upload.class, "createUpload", ApiMethodArg.arg("fileName", String.class), ApiMethodArg.arg("contentType", String.class), ApiMethodArg.arg("content", byte[].class)),
    CREATE_UPLOAD_2(Attachment.Upload.class, "createUpload", ApiMethodArg.arg("token", String.class), ApiMethodArg.arg("fileName", String.class), ApiMethodArg.arg("contentType", String.class), ApiMethodArg.arg("content", byte[].class)),
    CREATE_UPLOAD_ARTICLE(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg("articleId0", Long.TYPE), ApiMethodArg.arg("file", File.class)),
    CREATE_UPLOAD_ARTICLE_1(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg("articleId0", Long.TYPE), ApiMethodArg.arg("file", File.class), ApiMethodArg.arg("inline", Boolean.TYPE)),
    CREATE_USER(User.class, "createUser", ApiMethodArg.arg("user", User.class)),
    CREATE_USER_IDENTITY(Identity.class, "createUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    CREATE_USER_IDENTITY_1(Identity.class, "createUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identity", Identity.class)),
    CREATE_USER_SEGMENT(UserSegment.class, "createUserSegment", ApiMethodArg.arg("userSegment", UserSegment.class)),
    CREATE_USERS(JobStatus.class, "createUsers", ApiMethodArg.arg("userList", List.class)),
    CREATE_USERS_1(JobStatus.class, "createUsers", ApiMethodArg.arg("users", new User[0].getClass())),
    CREATE_USERS_ASYNC(ListenableFuture.class, "createUsersAsync", ApiMethodArg.arg("userList", List.class)),
    DELETE_ARTICLE(Void.TYPE, "deleteArticle", ApiMethodArg.arg("article", Article.class)),
    DELETE_ARTICLE_ATTACHMENT(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg("articleAttachments", ArticleAttachments.class)),
    DELETE_ARTICLE_ATTACHMENT_1(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_ATTACHMENT(Void.TYPE, "deleteAttachment", ApiMethodArg.arg("attachment", Attachment.class)),
    DELETE_ATTACHMENT_1(Void.TYPE, "deleteAttachment", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_AUTOMATION(Void.TYPE, "deleteAutomation", ApiMethodArg.arg("automationId0", Long.TYPE)),
    DELETE_CATEGORY(Void.TYPE, "deleteCategory", ApiMethodArg.arg("category", Category.class)),
    DELETE_CONTENT_TAG(Void.TYPE, "deleteContentTag", ApiMethodArg.arg("contentTag", ContentTag.class)),
    DELETE_DYNAMIC_CONTENT_ITEM(Void.TYPE, "deleteDynamicContentItem", ApiMethodArg.arg("item", DynamicContentItem.class)),
    DELETE_DYNAMIC_CONTENT_ITEM_VARIANT(Void.TYPE, "deleteDynamicContentItemVariant", ApiMethodArg.arg("itemId", Long.class), ApiMethodArg.arg("variant", DynamicContentItemVariant.class)),
    DELETE_FORUM(Void.TYPE, "deleteForum", ApiMethodArg.arg("forum", Forum.class)),
    DELETE_GROUP(Void.TYPE, "deleteGroup", ApiMethodArg.arg("group", Group.class)),
    DELETE_GROUP_1(Void.TYPE, "deleteGroup", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_GROUP_MEMBERSHIP(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg("groupMembership", GroupMembership.class)),
    DELETE_GROUP_MEMBERSHIP_1(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_GROUP_MEMBERSHIP_2(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("groupMembership", GroupMembership.class)),
    DELETE_GROUP_MEMBERSHIP_3(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("group_membership_id", Long.TYPE)),
    DELETE_ORGANIZATION(Void.TYPE, "deleteOrganization", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_ORGANIZATION_1(Void.TYPE, "deleteOrganization", ApiMethodArg.arg("organization", Organization.class)),
    DELETE_ORGANIZATION_MEMBERSHIP(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_ORGANIZATION_MEMBERSHIP_1(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("organizationMembership", OrganizationMembership.class)),
    DELETE_ORGANIZATION_MEMBERSHIP_2(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("organization_membership_id", Long.TYPE)),
    DELETE_ORGANIZATION_MEMBERSHIPS(Void.TYPE, "deleteOrganizationMemberships", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    DELETE_ORGANIZATIONS(JobStatus.class, "deleteOrganizations", ApiMethodArg.arg("ids", long[].class)),
    DELETE_PERMISSION_GROUP(Void.TYPE, "deletePermissionGroup", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_PERMISSION_GROUP_1(Void.TYPE, "deletePermissionGroup", ApiMethodArg.arg("permissionGroup", PermissionGroup.class)),
    DELETE_SECTION(Void.TYPE, "deleteSection", ApiMethodArg.arg("section", Section.class)),
    DELETE_SUSPENDED_TICKET(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_SUSPENDED_TICKET_1(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg("suspendedTicket", SuspendedTicket.class)),
    DELETE_TARGET(Void.TYPE, "deleteTarget", ApiMethodArg.arg("targetId", Long.TYPE)),
    DELETE_TICKET(Void.TYPE, "deleteTicket", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_TICKET_1(Void.TYPE, "deleteTicket", ApiMethodArg.arg("ticket", Ticket.class)),
    DELETE_TICKET_FIELD(Void.TYPE, "deleteTicketField", ApiMethodArg.arg("field", Field.class)),
    DELETE_TICKET_FIELD_1(Void.TYPE, "deleteTicketField", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_TICKET_FORM(Void.TYPE, "deleteTicketForm", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_TICKET_FORM_1(Void.TYPE, "deleteTicketForm", ApiMethodArg.arg("ticketForm", TicketForm.class)),
    DELETE_TICKETS(JobStatus.class, "deleteTickets", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    DELETE_TOPIC(Void.TYPE, "deleteTopic", ApiMethodArg.arg("topic", Topic.class)),
    DELETE_TRANSLATION(Void.TYPE, "deleteTranslation", ApiMethodArg.arg("translation", Translation.class)),
    DELETE_TRANSLATION_1(Void.TYPE, "deleteTranslation", ApiMethodArg.arg("translationId", Long.class)),
    DELETE_TRIGGER(Void.TYPE, "deleteTrigger", ApiMethodArg.arg("triggerId", Long.TYPE)),
    DELETE_UPLOAD(Void.TYPE, "deleteUpload", ApiMethodArg.arg("token", String.class)),
    DELETE_UPLOAD_1(Void.TYPE, "deleteUpload", ApiMethodArg.arg("upload", Attachment.Upload.class)),
    DELETE_USER(Void.TYPE, "deleteUser", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_USER_1(Void.TYPE, "deleteUser", ApiMethodArg.arg("user", User.class)),
    DELETE_USER_IDENTITY(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    DELETE_USER_IDENTITY_1(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identityId", Long.TYPE)),
    DELETE_USER_IDENTITY_2(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identityId", Long.TYPE)),
    DELETE_USER_SEGMENT(Void.TYPE, "deleteUserSegment", ApiMethodArg.arg("id", Long.TYPE)),
    DELETE_USER_SEGMENT_1(Void.TYPE, "deleteUserSegment", ApiMethodArg.arg("userSegment", UserSegment.class)),
    DELETE_USERS(JobStatus.class, "deleteUsers", ApiMethodArg.arg("ids", long[].class)),
    GET_ACTIVE_TRIGGERS(Iterable.class, "getActiveTriggers", new ApiMethodArg[0]),
    GET_ARTICLE(Article.class, "getArticle", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ARTICLE_FROM_SEARCH(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg("searchTerm", String.class)),
    GET_ARTICLE_FROM_SEARCH_1(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg("searchTerm", String.class), ApiMethodArg.arg("sectionId", Long.class)),
    GET_ARTICLE_SUBSCRIPTIONS(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg("articleId", Long.class)),
    GET_ARTICLE_SUBSCRIPTIONS_1(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg("articleId", Long.class), ApiMethodArg.arg("locale", String.class)),
    GET_ARTICLE_TRANSLATIONS(Iterable.class, "getArticleTranslations", ApiMethodArg.arg("articleId", Long.class)),
    GET_ARTICLES(Iterable.class, "getArticles", new ApiMethodArg[0]),
    GET_ARTICLES_1(Iterable.class, "getArticles", ApiMethodArg.arg("category", Category.class)),
    GET_ARTICLES_2(Iterable.class, "getArticles", ApiMethodArg.arg("locale", String.class)),
    GET_ARTICLES_3(Iterable.class, "getArticles", ApiMethodArg.arg("section", Section.class)),
    GET_ARTICLES_4(Iterable.class, "getArticles", ApiMethodArg.arg("category", Category.class), ApiMethodArg.arg("locale", String.class)),
    GET_ARTICLES_5(Iterable.class, "getArticles", ApiMethodArg.arg("section", Section.class), ApiMethodArg.arg("locale", String.class)),
    GET_ARTICLES_FROM_ALL_LABELS(Iterable.class, "getArticlesFromAllLabels", ApiMethodArg.arg("labels", List.class)),
    GET_ARTICLES_FROM_ANY_LABELS(Iterable.class, "getArticlesFromAnyLabels", ApiMethodArg.arg("labels", List.class)),
    GET_ARTICLES_FROM_PAGE(List.class, "getArticlesFromPage", ApiMethodArg.arg("page", Integer.TYPE)),
    GET_ARTICLES_INCREMENTALLY(Iterable.class, "getArticlesIncrementally", ApiMethodArg.arg("startTime", Date.class)),
    GET_ASSIGNABLE_GROUP_MEMBERSHIPS(Iterable.class, "getAssignableGroupMemberships", new ApiMethodArg[0]),
    GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1(Iterable.class, "getAssignableGroupMemberships", ApiMethodArg.arg("group_id", Long.TYPE)),
    GET_ASSIGNABLE_GROUPS(Iterable.class, "getAssignableGroups", new ApiMethodArg[0]),
    GET_ASSIGNED_TICKETS_COUNT_FOR_USER(TicketCount.class, "getAssignedTicketsCountForUser", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ATTACHMENT(Attachment.class, "getAttachment", ApiMethodArg.arg("attachment", Attachment.class)),
    GET_ATTACHMENT_1(Attachment.class, "getAttachment", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ATTACHMENTS_FROM_ARTICLE(List.class, "getAttachmentsFromArticle", ApiMethodArg.arg("articleId", Long.class)),
    GET_AUTHENTICATED_USER(User.class, "getAuthenticatedUser", new ApiMethodArg[0]),
    GET_AUTO_COMPLETE_ORGANIZATIONS(Iterable.class, "getAutoCompleteOrganizations", ApiMethodArg.arg("name", String.class)),
    GET_AUTOMATION(Automation.class, "getAutomation", ApiMethodArg.arg("id", Long.TYPE)),
    GET_AUTOMATIONS(Iterable.class, "getAutomations", new ApiMethodArg[0]),
    GET_BRANDS(Iterable.class, "getBrands", new ApiMethodArg[0]),
    GET_CC_REQUESTS(Iterable.class, "getCCRequests", new ApiMethodArg[0]),
    GET_CATEGORIES(Iterable.class, "getCategories", new ApiMethodArg[0]),
    GET_CATEGORY(Category.class, "getCategory", ApiMethodArg.arg("id", Long.TYPE)),
    GET_CATEGORY_TRANSLATIONS(Iterable.class, "getCategoryTranslations", ApiMethodArg.arg("categoryId", Long.class)),
    GET_CCD_TICKETS_COUNT_FOR_USER(TicketCount.class, "getCcdTicketsCountForUser", ApiMethodArg.arg("id", Long.TYPE)),
    GET_COMPLIANCE_DELETION_STATUSES(Iterable.class, "getComplianceDeletionStatuses", ApiMethodArg.arg("userId", Long.TYPE)),
    GET_CONTENT_TAG(ContentTag.class, "getContentTag", ApiMethodArg.arg("contentTagId", String.class)),
    GET_CONTENT_TAGS(Iterable.class, "getContentTags", new ApiMethodArg[0]),
    GET_CONTENT_TAGS_1(Iterable.class, "getContentTags", ApiMethodArg.arg("pageSize", Integer.TYPE)),
    GET_CONTENT_TAGS_2(Iterable.class, "getContentTags", ApiMethodArg.arg("pageSize", Integer.TYPE), ApiMethodArg.arg("namePrefix", String.class)),
    GET_CURRENT_USER(User.class, "getCurrentUser", new ApiMethodArg[0]),
    GET_CUSTOM_AGENT_ROLES(Iterable.class, "getCustomAgentRoles", new ApiMethodArg[0]),
    GET_CUSTOM_TICKET_STATUSES(Iterable.class, "getCustomTicketStatuses", new ApiMethodArg[0]),
    GET_DELETED_TICKETS(Iterable.class, "getDeletedTickets", new ApiMethodArg[0]),
    GET_DELETED_TICKETS_1(Iterable.class, "getDeletedTickets", ApiMethodArg.arg("sortBy", String.class), ApiMethodArg.arg("sortOrder", SortOrder.class)),
    GET_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "getDynamicContentItem", ApiMethodArg.arg("id", Long.TYPE)),
    GET_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "getDynamicContentItemVariant", ApiMethodArg.arg("itemId", Long.class), ApiMethodArg.arg("id", Long.TYPE)),
    GET_DYNAMIC_CONTENT_ITEM_VARIANTS(Iterable.class, "getDynamicContentItemVariants", ApiMethodArg.arg("item", DynamicContentItem.class)),
    GET_DYNAMIC_CONTENT_ITEMS(Iterable.class, "getDynamicContentItems", new ApiMethodArg[0]),
    GET_FORUM(Forum.class, "getForum", ApiMethodArg.arg("id", Long.TYPE)),
    GET_FORUMS(Iterable.class, "getForums", new ApiMethodArg[0]),
    GET_FORUMS_1(List.class, "getForums", ApiMethodArg.arg("category_id", Long.TYPE)),
    GET_GROUP(Group.class, "getGroup", ApiMethodArg.arg("id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg("id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP_1(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("group_membership_id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP_BY_USER(Iterable.class, "getGroupMembershipByUser", ApiMethodArg.arg("user_id", Long.TYPE)),
    GET_GROUP_MEMBERSHIPS(Iterable.class, "getGroupMemberships", new ApiMethodArg[0]),
    GET_GROUP_MEMBERSHIPS_1(Iterable.class, "getGroupMemberships", ApiMethodArg.arg("group_id", Long.TYPE)),
    GET_GROUP_ORGANIZATION(OrganizationMembership.class, "getGroupOrganization", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("organization_membership_id", Long.TYPE)),
    GET_GROUP_USERS(Iterable.class, "getGroupUsers", ApiMethodArg.arg("id", Long.TYPE)),
    GET_GROUPS(Iterable.class, "getGroups", new ApiMethodArg[0]),
    GET_HELP_CENTER_LOCALES(List.class, "getHelpCenterLocales", new ApiMethodArg[0]),
    GET_HOLIDAYS_FOR_SCHEDULE(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg("schedule", Schedule.class)),
    GET_HOLIDAYS_FOR_SCHEDULE_1(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg("scheduleId", Long.class)),
    GET_INCREMENTAL_TICKETS_RESULT(Map.class, "getIncrementalTicketsResult", ApiMethodArg.arg("unixEpochTime", Long.TYPE)),
    GET_JIRA_LINKS(Iterable.class, "getJiraLinks", new ApiMethodArg[0]),
    GET_JOB_STATUS(JobStatus.class, "getJobStatus", ApiMethodArg.arg("status", JobStatus.class)),
    GET_JOB_STATUS_ASYNC(ListenableFuture.class, "getJobStatusAsync", ApiMethodArg.arg("status", JobStatus.class)),
    GET_JOB_STATUSES(List.class, "getJobStatuses", ApiMethodArg.arg("statuses", List.class)),
    GET_JOB_STATUSES_ASYNC(ListenableFuture.class, "getJobStatusesAsync", ApiMethodArg.arg("statuses", List.class)),
    GET_LOCALES(Iterable.class, "getLocales", new ApiMethodArg[0]),
    GET_MACRO(Macro.class, "getMacro", ApiMethodArg.arg("macroId", Long.TYPE)),
    GET_MACROS(Iterable.class, "getMacros", new ApiMethodArg[0]),
    GET_OPEN_REQUESTS(Iterable.class, "getOpenRequests", new ApiMethodArg[0]),
    GET_ORGANIZATION(Organization.class, "getOrganization", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ORGANIZATION_FIELDS(Iterable.class, "getOrganizationFields", new ApiMethodArg[0]),
    GET_ORGANIZATION_MEMBERSHIP(OrganizationMembership.class, "getOrganizationMembership", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIP_BY_USER(Iterable.class, "getOrganizationMembershipByUser", ApiMethodArg.arg("user_id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIP_FOR_USER(OrganizationMembership.class, "getOrganizationMembershipForUser", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIPS(Iterable.class, "getOrganizationMemberships", new ApiMethodArg[0]),
    GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG(Iterable.class, "getOrganizationMembershipsForOrg", ApiMethodArg.arg("organization_id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIPS_FOR_USER(Iterable.class, "getOrganizationMembershipsForUser", ApiMethodArg.arg("user_id", Long.TYPE)),
    GET_ORGANIZATION_REQUESTS(Iterable.class, "getOrganizationRequests", ApiMethodArg.arg("organizationId", Long.TYPE)),
    GET_ORGANIZATION_TICKETS(Iterable.class, "getOrganizationTickets", ApiMethodArg.arg("organizationId", Long.TYPE)),
    GET_ORGANIZATION_USERS(Iterable.class, "getOrganizationUsers", ApiMethodArg.arg("id", Long.TYPE)),
    GET_ORGANIZATIONS(Iterable.class, "getOrganizations", new ApiMethodArg[0]),
    GET_ORGANIZATIONS_1(List.class, "getOrganizations", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    GET_ORGANIZATIONS_INCREMENTALLY(Iterable.class, "getOrganizationsIncrementally", ApiMethodArg.arg("startTime", Date.class)),
    GET_PERMISSION_GROUP(PermissionGroup.class, "getPermissionGroup", ApiMethodArg.arg("id", Long.TYPE)),
    GET_PERMISSION_GROUPS(Iterable.class, "getPermissionGroups", new ApiMethodArg[0]),
    GET_RECENT_TICKETS(Iterable.class, "getRecentTickets", new ApiMethodArg[0]),
    GET_REQUEST(Request.class, "getRequest", ApiMethodArg.arg("id", Long.TYPE)),
    GET_REQUEST_COMMENT(Comment.class, "getRequestComment", ApiMethodArg.arg("request", Request.class), ApiMethodArg.arg("comment", Comment.class)),
    GET_REQUEST_COMMENT_1(Comment.class, "getRequestComment", ApiMethodArg.arg("request", Request.class), ApiMethodArg.arg("commentId", Long.TYPE)),
    GET_REQUEST_COMMENT_2(Comment.class, "getRequestComment", ApiMethodArg.arg("requestId", Long.TYPE), ApiMethodArg.arg("commentId", Long.TYPE)),
    GET_REQUEST_COMMENTS(Iterable.class, "getRequestComments", ApiMethodArg.arg("id", Long.TYPE)),
    GET_REQUEST_COMMENTS_1(Iterable.class, "getRequestComments", ApiMethodArg.arg("request", Request.class)),
    GET_REQUESTS(Iterable.class, "getRequests", new ApiMethodArg[0]),
    GET_SATISFACTION_RATING(SatisfactionRating.class, "getSatisfactionRating", ApiMethodArg.arg("id", Long.TYPE)),
    GET_SATISFACTION_RATINGS(Iterable.class, "getSatisfactionRatings", new ApiMethodArg[0]),
    GET_SCHEDULE(Schedule.class, "getSchedule", ApiMethodArg.arg("schedule", Schedule.class)),
    GET_SCHEDULE_1(Schedule.class, "getSchedule", ApiMethodArg.arg("scheduleId", Long.class)),
    GET_SCHEDULES(Iterable.class, "getSchedules", new ApiMethodArg[0]),
    GET_SEARCH_TICKET_RESULTS(Optional.class, "getSearchTicketResults", ApiMethodArg.arg("query", String.class), ApiMethodArg.arg("queryParams", Map.class), ApiMethodArg.arg("sortBy", String.class), ApiMethodArg.arg("sortOrder", SortOrder.class)),
    GET_SECTION(Section.class, "getSection", ApiMethodArg.arg("id", Long.TYPE)),
    GET_SECTION_SUBSCRIPTIONS(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg("sectionId", Long.class)),
    GET_SECTION_SUBSCRIPTIONS_1(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg("sectionId", Long.class), ApiMethodArg.arg("locale", String.class)),
    GET_SECTION_TRANSLATIONS(Iterable.class, "getSectionTranslations", ApiMethodArg.arg("sectionId", Long.class)),
    GET_SECTIONS(Iterable.class, "getSections", new ApiMethodArg[0]),
    GET_SECTIONS_1(Iterable.class, "getSections", ApiMethodArg.arg("category", Category.class)),
    GET_SECTIONS_2(Iterable.class, "getSections", ApiMethodArg.arg("userSegment", UserSegment.class)),
    GET_SOLVED_REQUESTS(Iterable.class, "getSolvedRequests", new ApiMethodArg[0]),
    GET_SUSPENDED_TICKETS(Iterable.class, "getSuspendedTickets", new ApiMethodArg[0]),
    GET_TARGET(Target.class, "getTarget", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TARGETS(Iterable.class, "getTargets", new ApiMethodArg[0]),
    GET_TICKET(Ticket.class, "getTicket", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_AUDIT(Audit.class, "getTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("audit", Audit.class)),
    GET_TICKET_AUDIT_1(Audit.class, "getTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_AUDIT_2(Audit.class, "getTicketAudit", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("auditId", Long.TYPE)),
    GET_TICKET_AUDITS(Iterable.class, "getTicketAudits", ApiMethodArg.arg("ticket", Ticket.class)),
    GET_TICKET_AUDITS_1(Iterable.class, "getTicketAudits", ApiMethodArg.arg("ticketId0", Long.class)),
    GET_TICKET_COLLABORATORS(List.class, "getTicketCollaborators", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_COMMENTS(Iterable.class, "getTicketComments", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_COMMENTS_1(Iterable.class, "getTicketComments", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("order", SortOrder.class)),
    GET_TICKET_FIELD(Field.class, "getTicketField", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_FIELDS(Iterable.class, "getTicketFields", new ApiMethodArg[0]),
    GET_TICKET_FORM(TicketForm.class, "getTicketForm", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_FORMS(List.class, "getTicketForms", new ApiMethodArg[0]),
    GET_TICKET_INCIDENTS(Iterable.class, "getTicketIncidents", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_METRIC(Metric.class, "getTicketMetric", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_METRIC_BY_TICKET(Metric.class, "getTicketMetricByTicket", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKET_METRICS(Iterable.class, "getTicketMetrics", new ApiMethodArg[0]),
    GET_TICKETS(Iterable.class, "getTickets", new ApiMethodArg[0]),
    GET_TICKETS_1(List.class, "getTickets", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    GET_TICKETS_BY_EXTERNAL_ID(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg("externalId", String.class)),
    GET_TICKETS_BY_EXTERNAL_ID_1(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg("externalId", String.class), ApiMethodArg.arg("includeArchived", Boolean.TYPE)),
    GET_TICKETS_COUNT(TicketCount.class, "getTicketsCount", new ApiMethodArg[0]),
    GET_TICKETS_COUNT_FOR_ORGANIZATION(TicketCount.class, "getTicketsCountForOrganization", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TICKETS_FROM_SEARCH(Iterable.class, "getTicketsFromSearch", ApiMethodArg.arg("searchTerm", String.class)),
    GET_TICKETS_INCREMENTALLY(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg("startTime", Date.class)),
    GET_TICKETS_INCREMENTALLY_1(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg("startTime", Date.class), ApiMethodArg.arg("endTime", Date.class)),
    GET_TIME_ZONES(List.class, "getTimeZones", new ApiMethodArg[0]),
    GET_TOPIC(Topic.class, "getTopic", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TOPICS(Iterable.class, "getTopics", new ApiMethodArg[0]),
    GET_TOPICS_1(List.class, "getTopics", ApiMethodArg.arg("forum_id", Long.TYPE)),
    GET_TOPICS_2(Iterable.class, "getTopics", ApiMethodArg.arg("userSegment", UserSegment.class)),
    GET_TOPICS_3(List.class, "getTopics", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    GET_TOPICS_BY_USER(List.class, "getTopicsByUser", ApiMethodArg.arg("user_id", Long.TYPE)),
    GET_TRIGGER(Trigger.class, "getTrigger", ApiMethodArg.arg("id", Long.TYPE)),
    GET_TRIGGERS(Iterable.class, "getTriggers", new ApiMethodArg[0]),
    GET_TRIGGERS_1(Iterable.class, "getTriggers", ApiMethodArg.arg("categoryId0", String.class), ApiMethodArg.arg("active", Boolean.TYPE), ApiMethodArg.arg("sortBy", String.class), ApiMethodArg.arg("sortOrder", SortOrder.class)),
    GET_TWITTER_MONITORS(Iterable.class, "getTwitterMonitors", new ApiMethodArg[0]),
    GET_USER(User.class, "getUser", ApiMethodArg.arg("id", Long.TYPE)),
    GET_USER_CCD_TICKETS(Iterable.class, "getUserCCDTickets", ApiMethodArg.arg("userId", Long.TYPE)),
    GET_USER_FIELDS(Iterable.class, "getUserFields", new ApiMethodArg[0]),
    GET_USER_IDENTITIES(List.class, "getUserIdentities", ApiMethodArg.arg("user", User.class)),
    GET_USER_IDENTITIES_1(List.class, "getUserIdentities", ApiMethodArg.arg("userId", Long.TYPE)),
    GET_USER_IDENTITY(Identity.class, "getUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    GET_USER_IDENTITY_1(Identity.class, "getUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identityId", Long.TYPE)),
    GET_USER_IDENTITY_2(Identity.class, "getUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identityId", Long.TYPE)),
    GET_USER_RELATED_INFO(UserRelatedInfo.class, "getUserRelatedInfo", ApiMethodArg.arg("userId", Long.TYPE)),
    GET_USER_REQUESTED_TICKETS(Iterable.class, "getUserRequestedTickets", ApiMethodArg.arg("userId", Long.TYPE)),
    GET_USER_REQUESTS(Iterable.class, "getUserRequests", ApiMethodArg.arg("id", Long.TYPE)),
    GET_USER_REQUESTS_1(Iterable.class, "getUserRequests", ApiMethodArg.arg("user", User.class)),
    GET_USER_SEGMENT(UserSegment.class, "getUserSegment", ApiMethodArg.arg("id", Long.TYPE)),
    GET_USER_SEGMENTS(Iterable.class, "getUserSegments", new ApiMethodArg[0]),
    GET_USER_SEGMENTS_1(Iterable.class, "getUserSegments", ApiMethodArg.arg("id", Long.TYPE)),
    GET_USER_SEGMENTS_APPLICABLE(Iterable.class, "getUserSegmentsApplicable", new ApiMethodArg[0]),
    GET_USER_SUBSCRIPTIONS(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg("user", User.class)),
    GET_USER_SUBSCRIPTIONS_1(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg("userId0", Long.class)),
    GET_USERS(Iterable.class, "getUsers", new ApiMethodArg[0]),
    GET_USERS_1(List.class, "getUsers", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    GET_USERS_BY_EXTERNAL_IDS(List.class, "getUsersByExternalIds", ApiMethodArg.arg("externalId", String.class), ApiMethodArg.arg("externalIds", new String[0].getClass())),
    GET_USERS_BY_EXTERNAL_IDS_1(List.class, "getUsersByExternalIds", ApiMethodArg.arg("externalId0", Long.TYPE), ApiMethodArg.arg("externalId0s", long[].class)),
    GET_USERS_BY_ROLE(Iterable.class, "getUsersByRole", ApiMethodArg.arg("role", String.class), ApiMethodArg.arg("roles", new String[0].getClass())),
    GET_USERS_INCREMENTALLY(Iterable.class, "getUsersIncrementally", ApiMethodArg.arg("startTime", Date.class)),
    GET_VIEW(Iterable.class, "getView", ApiMethodArg.arg("id", Long.TYPE)),
    GET_VIEWS(Iterable.class, "getViews", new ApiMethodArg[0]),
    IMPORT_TICKET(Ticket.class, "importTicket", ApiMethodArg.arg("ticketImport", TicketImport.class)),
    IMPORT_TOPIC(Topic.class, "importTopic", ApiMethodArg.arg("topic", Topic.class)),
    LIST_HELP_CENTER_LOCALES(Locales.class, "listHelpCenterLocales", new ApiMethodArg[0]),
    LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID(Iterable.class, "lookupOrganizationsByExternalId", ApiMethodArg.arg("externalId", String.class)),
    LOOKUP_USER_BY_EMAIL(Iterable.class, "lookupUserByEmail", ApiMethodArg.arg("email", String.class)),
    LOOKUP_USER_BY_EXTERNAL_ID(Iterable.class, "lookupUserByExternalId", ApiMethodArg.arg("externalId", String.class)),
    MACROS_SHOW_CHANGES_TO_TICKET(Ticket.class, "macrosShowChangesToTicket", ApiMethodArg.arg("macroId", Long.TYPE)),
    MACROS_SHOW_TICKET_AFTER_CHANGES(Ticket.class, "macrosShowTicketAfterChanges", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("macroId", Long.TYPE)),
    MAKE_PRIVATE_TICKET_AUDIT(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("audit", Audit.class)),
    MAKE_PRIVATE_TICKET_AUDIT_1(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("id", Long.TYPE)),
    MAKE_PRIVATE_TICKET_AUDIT_2(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("auditId", Long.TYPE)),
    MARK_TICKET_AS_SPAM(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg("id", Long.TYPE)),
    MARK_TICKET_AS_SPAM_1(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg("ticket", Ticket.class)),
    MERGE_USERS(User.class, "mergeUsers", ApiMethodArg.arg("userIdThatWillRemain", Long.TYPE), ApiMethodArg.arg("userIdThatWillBeMerged", Long.TYPE)),
    NOTIFY_APP(Void.TYPE, "notifyApp", ApiMethodArg.arg("json", String.class)),
    PERMANENTLY_DELETE_TICKET(JobStatus.class, "permanentlyDeleteTicket", ApiMethodArg.arg("id", Long.TYPE)),
    PERMANENTLY_DELETE_TICKET_1(JobStatus.class, "permanentlyDeleteTicket", ApiMethodArg.arg("ticket", Ticket.class)),
    PERMANENTLY_DELETE_TICKETS(JobStatus.class, "permanentlyDeleteTickets", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("ids", long[].class)),
    PERMANENTLY_DELETE_USER(User.class, "permanentlyDeleteUser", ApiMethodArg.arg("id", Long.TYPE)),
    PERMANENTLY_DELETE_USER_1(User.class, "permanentlyDeleteUser", ApiMethodArg.arg("user", User.class)),
    QUEUE_CREATE_TICKET_ASYNC(ListenableFuture.class, "queueCreateTicketAsync", ApiMethodArg.arg("ticket", Ticket.class)),
    REMOVE_TAG_FROM_ORGANISATIONS(List.class, "removeTagFromOrganisations", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    REMOVE_TAG_FROM_TICKET(List.class, "removeTagFromTicket", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    REMOVE_TAG_FROM_TOPICS(List.class, "removeTagFromTopics", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    REQUEST_VERIFY_USER_IDENTITY(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    REQUEST_VERIFY_USER_IDENTITY_1(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identityId", Long.TYPE)),
    REQUEST_VERIFY_USER_IDENTITY_2(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identityId", Long.TYPE)),
    RESET_USER_PASSWORD(Void.TYPE, "resetUserPassword", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("password", String.class)),
    RESET_USER_PASSWORD_1(Void.TYPE, "resetUserPassword", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("password", String.class)),
    SEARCH_TRIGGERS(Iterable.class, "searchTriggers", ApiMethodArg.arg("query", String.class)),
    SEARCH_TRIGGERS_1(Iterable.class, "searchTriggers", ApiMethodArg.arg("query", String.class), ApiMethodArg.arg("active", Boolean.TYPE), ApiMethodArg.arg("sortBy", String.class), ApiMethodArg.arg("sortOrder", SortOrder.class)),
    SET_GROUP_MEMBERSHIP_AS_DEFAULT(List.class, "setGroupMembershipAsDefault", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("groupMembership", GroupMembership.class)),
    SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT(List.class, "setOrganizationMembershipAsDefault", ApiMethodArg.arg("user_id", Long.TYPE), ApiMethodArg.arg("organizationMembership", OrganizationMembership.class)),
    SET_TAG_ON_ORGANISATIONS(List.class, "setTagOnOrganisations", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    SET_TAG_ON_TICKET(List.class, "setTagOnTicket", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    SET_TAG_ON_TOPICS(List.class, "setTagOnTopics", ApiMethodArg.arg("id", Long.TYPE), ApiMethodArg.arg("tags", new String[0].getClass())),
    SET_USER_PRIMARY_IDENTITY(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    SET_USER_PRIMARY_IDENTITY_1(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identityId", Long.TYPE)),
    SET_USER_PRIMARY_IDENTITY_2(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identityId", Long.TYPE)),
    SHOW_ARTICLE_TRANSLATION(Translation.class, "showArticleTranslation", ApiMethodArg.arg("articleId0", Long.TYPE), ApiMethodArg.arg("locale", String.class)),
    SHOW_CATEGORY_TRANSLATION(Translation.class, "showCategoryTranslation", ApiMethodArg.arg("categoryId1", Long.TYPE), ApiMethodArg.arg("locale", String.class)),
    SHOW_SECTION_TRANSLATION(Translation.class, "showSectionTranslation", ApiMethodArg.arg("sectionId0", Long.TYPE), ApiMethodArg.arg("locale", String.class)),
    SUSPEND_USER(User.class, "suspendUser", ApiMethodArg.arg("id", Long.TYPE)),
    TRUST_TICKET_AUDIT(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("audit", Audit.class)),
    TRUST_TICKET_AUDIT_1(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg("ticket", Ticket.class), ApiMethodArg.arg("id", Long.TYPE)),
    TRUST_TICKET_AUDIT_2(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg("ticketId", Long.TYPE), ApiMethodArg.arg("auditId", Long.TYPE)),
    UNSUSPEND_USER(User.class, "unsuspendUser", ApiMethodArg.arg("id", Long.TYPE)),
    UPDATE_ARTICLE(Article.class, "updateArticle", ApiMethodArg.arg("article", Article.class)),
    UPDATE_ARTICLE_TRANSLATION(Translation.class, "updateArticleTranslation", ApiMethodArg.arg("articleId", Long.class), ApiMethodArg.arg("locale", String.class), ApiMethodArg.arg("translation", Translation.class)),
    UPDATE_AUTOMATION(Automation.class, "updateAutomation", ApiMethodArg.arg("automationId", Long.class), ApiMethodArg.arg("automation", Automation.class)),
    UPDATE_CATEGORY(Category.class, "updateCategory", ApiMethodArg.arg("category", Category.class)),
    UPDATE_CATEGORY_TRANSLATION(Translation.class, "updateCategoryTranslation", ApiMethodArg.arg("categoryId", Long.class), ApiMethodArg.arg("locale", String.class), ApiMethodArg.arg("translation", Translation.class)),
    UPDATE_CONTENT_TAG(ContentTag.class, "updateContentTag", ApiMethodArg.arg("contentTag", ContentTag.class)),
    UPDATE_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "updateDynamicContentItem", ApiMethodArg.arg("item", DynamicContentItem.class)),
    UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "updateDynamicContentItemVariant", ApiMethodArg.arg("itemId", Long.class), ApiMethodArg.arg("variant", DynamicContentItemVariant.class)),
    UPDATE_FORUM(Forum.class, "updateForum", ApiMethodArg.arg("forum", Forum.class)),
    UPDATE_GROUP(Group.class, "updateGroup", ApiMethodArg.arg("group", Group.class)),
    UPDATE_INSTALLATION(Void.TYPE, "updateInstallation", ApiMethodArg.arg("installationId", Integer.TYPE), ApiMethodArg.arg("json", String.class)),
    UPDATE_MACRO(Macro.class, "updateMacro", ApiMethodArg.arg("macroId0", Long.class), ApiMethodArg.arg("macro", Macro.class)),
    UPDATE_ORGANIZATION(Organization.class, "updateOrganization", ApiMethodArg.arg("organization", Organization.class)),
    UPDATE_ORGANIZATIONS(JobStatus.class, "updateOrganizations", ApiMethodArg.arg("organizationList", List.class)),
    UPDATE_ORGANIZATIONS_1(JobStatus.class, "updateOrganizations", ApiMethodArg.arg("organizations", new Organization[0].getClass())),
    UPDATE_ORGANIZATIONS_ASYNC(ListenableFuture.class, "updateOrganizationsAsync", ApiMethodArg.arg("organizationList", List.class)),
    UPDATE_PERMISSION_GROUP(PermissionGroup.class, "updatePermissionGroup", ApiMethodArg.arg("permissionGroup", PermissionGroup.class)),
    UPDATE_REQUEST(Request.class, "updateRequest", ApiMethodArg.arg("request", Request.class)),
    UPDATE_SECTION(Section.class, "updateSection", ApiMethodArg.arg("section", Section.class)),
    UPDATE_SECTION_TRANSLATION(Translation.class, "updateSectionTranslation", ApiMethodArg.arg("sectionId", Long.class), ApiMethodArg.arg("locale", String.class), ApiMethodArg.arg("translation", Translation.class)),
    UPDATE_TICKET(Ticket.class, "updateTicket", ApiMethodArg.arg("ticket", Ticket.class)),
    UPDATE_TICKET_FIELD(Field.class, "updateTicketField", ApiMethodArg.arg("field", Field.class)),
    UPDATE_TICKET_FORM(TicketForm.class, "updateTicketForm", ApiMethodArg.arg("ticketForm", TicketForm.class)),
    UPDATE_TICKETS(JobStatus.class, "updateTickets", ApiMethodArg.arg("ticketList", List.class)),
    UPDATE_TICKETS_1(JobStatus.class, "updateTickets", ApiMethodArg.arg("tickets", new Ticket[0].getClass())),
    UPDATE_TICKETS_ASYNC(ListenableFuture.class, "updateTicketsAsync", ApiMethodArg.arg("ticketList", List.class)),
    UPDATE_TOPIC(Topic.class, "updateTopic", ApiMethodArg.arg("topic", Topic.class)),
    UPDATE_TRIGGER(Trigger.class, "updateTrigger", ApiMethodArg.arg("triggerId0", Long.class), ApiMethodArg.arg("trigger", Trigger.class)),
    UPDATE_USER(User.class, "updateUser", ApiMethodArg.arg("user", User.class)),
    UPDATE_USER_IDENTITY(Identity.class, "updateUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    UPDATE_USER_IDENTITY_1(Identity.class, "updateUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identity", Identity.class)),
    UPDATE_USER_SEGMENT(UserSegment.class, "updateUserSegment", ApiMethodArg.arg("userSegment", UserSegment.class)),
    UPDATE_USERS(JobStatus.class, "updateUsers", ApiMethodArg.arg("users", new User[0].getClass())),
    UPDATE_USERS_1(JobStatus.class, "updateUsers", ApiMethodArg.arg("usersList", List.class)),
    UPDATE_USERS_ASYNC(ListenableFuture.class, "updateUsersAsync", ApiMethodArg.arg("usersList", List.class)),
    VERIFY_USER_IDENTITY(Identity.class, "verifyUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identity", Identity.class)),
    VERIFY_USER_IDENTITY_1(Identity.class, "verifyUserIdentity", ApiMethodArg.arg("user", User.class), ApiMethodArg.arg("identityId", Long.TYPE)),
    VERIFY_USER_IDENTITY_2(Identity.class, "verifyUserIdentity", ApiMethodArg.arg("userId", Long.TYPE), ApiMethodArg.arg("identityId", Long.TYPE));

    private final ApiMethod apiMethod;

    private ZendeskApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(Zendesk.class, resultType, name, args);
    }

    @Override
    public String getName() {
        return this.apiMethod.getName();
    }

    @Override
    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    @Override
    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    @Override
    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    @Override
    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

