/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import org.asynchttpclient.request.body.RandomAccessBody;
import org.asynchttpclient.util.MiscUtils;

class BodyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final RandomAccessBody body;
    private long transferred;

    BodyFileRegion(RandomAccessBody body) {
        this.body = Objects.requireNonNull(body, "body");
    }

    @Override
    public long position() {
        return 0L;
    }

    @Override
    public long count() {
        return this.body.getContentLength();
    }

    @Override
    public long transfered() {
        return this.transferred();
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object hint) {
        return this;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long written = this.body.transferTo(target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    @Override
    protected void deallocate() {
        MiscUtils.closeSilently(this.body);
    }
}

