/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.deflater;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

@Dataformat(value="gzipDeflater")
public class GzipDeflaterDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    @Override
    public String getDataFormatName() {
        return "gzipDeflater";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        GzipCompressorOutputStream zipOutput = new GzipCompressorOutputStream(stream);
        try {
            IOHelper.copy(is, zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, zipOutput);
            throw throwable;
        }
        IOHelper.close(is, zipOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        GzipCompressorInputStream unzipInput = null;
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        try {
            unzipInput = new GzipCompressorInputStream(inputStream);
            IOHelper.copy(unzipInput, osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close(osb, unzipInput, inputStream);
            throw throwable;
        }
        IOHelper.close(osb, unzipInput, inputStream);
        return object;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

