/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public class ServicePortPropertiesFunction
implements PropertiesFunction {
    private static final String PORT_PREFIX = "_SERVICE_PORT";

    @Override
    public String getName() {
        return "service.port";
    }

    @Override
    public String apply(String remainder) {
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = StringHelper.before(remainder, ":");
            defaultValue = StringHelper.after(remainder, ":");
        }
        if (key != null) {
            String port = IOHelper.lookupEnvironmentVariable(key + PORT_PREFIX);
            if (port != null) {
                return port;
            }
            return defaultValue;
        }
        return defaultValue;
    }
}

