/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.zipfile.ZipIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

@Dataformat(value="zipFile")
public class ZipFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final long DEFAULT_MAXIMUM_DECOMPRESSED_SIZE = 0x40000000L;
    private boolean usingIterator;
    private boolean allowEmptyDirectory;
    private boolean preservePathElements;
    private long maxDecompressedSize = 0x40000000L;

    @Override
    public String getDataFormatName() {
        return "zipFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filename;
        String filepath = exchange.getIn().getHeader("CamelFileName", String.class);
        if (filepath == null) {
            filename = filepath = StringHelper.sanitize(exchange.getIn().getMessageId());
        } else {
            Path filenamePath = Paths.get(filepath, new String[0]).getFileName();
            if (filenamePath != null) {
                filename = filenamePath.toString();
            } else {
                return;
            }
        }
        ZipOutputStream zos = new ZipOutputStream(stream);
        if (this.preservePathElements) {
            this.createZipEntries(zos, filepath);
        } else {
            this.createZipEntries(zos, filename);
        }
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        try {
            IOHelper.copy(is, zos);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, zos);
            throw throwable;
        }
        IOHelper.close(is, zos);
        String newFilename = filename + ".zip";
        exchange.getMessage().setHeader("CamelFileName", newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        if (this.usingIterator) {
            ZipIterator zipIterator = new ZipIterator(exchange, inputStream);
            zipIterator.setAllowEmptyDirectory(this.allowEmptyDirectory);
            return zipIterator;
        }
        ZipInputStream zis = new ZipInputStream(inputStream);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange(exchange);
        try {
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                throw new IllegalStateException("Unable to unzip the file, it may be corrupted.");
            }
            exchange.getMessage().setHeader("CamelFileName", entry.getName());
            IOHelper.copy(zis, osb, 16384, false, this.maxDecompressedSize);
            entry = zis.getNextEntry();
            if (entry != null) {
                throw new IllegalStateException("Zip file has more than 1 entry.");
            }
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close(zis, osb);
            throw throwable;
        }
        IOHelper.close(zis, osb);
        return object;
    }

    private void createZipEntries(ZipOutputStream zos, String filepath) throws IOException {
        Iterator<Path> elements = Paths.get(filepath, new String[0]).iterator();
        StringBuilder sb = new StringBuilder(256);
        while (elements.hasNext()) {
            Path path = elements.next();
            Object element = path.toString();
            if (elements.hasNext()) {
                element = (String)element + "/";
            }
            zos.putNextEntry(new ZipEntry(String.valueOf(sb) + (String)element));
            sb.append((String)element);
        }
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    public boolean isAllowEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }

    public boolean isPreservePathElements() {
        return this.preservePathElements;
    }

    public void setPreservePathElements(boolean preservePathElements) {
        this.preservePathElements = preservePathElements;
    }

    public long getMaxDecompressedSize() {
        return this.maxDecompressedSize;
    }

    public void setMaxDecompressedSize(long maxDecompressedSize) {
        this.maxDecompressedSize = maxDecompressedSize;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

