/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.Endpoint;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="configuration")
@XmlRootElement(name="routeTemplate")
@XmlType(propOrder={"templateParameters", "templateBeans", "route"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplateDefinition
extends OptionalIdentifiedDefinition<RouteTemplateDefinition>
implements ResourceAware {
    @XmlTransient
    private Consumer<RouteTemplateContext> configurer;
    @XmlElement(name="templateParameter")
    @Metadata(description="Adds a template parameter the route template uses")
    private List<RouteTemplateParameterDefinition> templateParameters;
    @XmlElement(name="templateBean")
    @Metadata(description="Adds a local bean the route template uses")
    private List<BeanFactoryDefinition<RouteTemplateDefinition>> templateBeans;
    @XmlElement(name="route", required=true)
    private RouteDefinition route = new RouteDefinition();
    @XmlTransient
    private Resource resource;

    public List<RouteTemplateParameterDefinition> getTemplateParameters() {
        return this.templateParameters;
    }

    public void setTemplateParameters(List<RouteTemplateParameterDefinition> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public List<BeanFactoryDefinition<RouteTemplateDefinition>> getTemplateBeans() {
        return this.templateBeans;
    }

    public void setTemplateBeans(List<BeanFactoryDefinition<RouteTemplateDefinition>> templateBeans) {
        this.templateBeans = templateBeans;
    }

    public RouteDefinition getRoute() {
        return this.route;
    }

    public void setRoute(RouteDefinition route) {
        this.route = route;
    }

    public void setConfigurer(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
    }

    public Consumer<RouteTemplateContext> getConfigurer() {
        return this.configurer;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        return this.route.from(uri);
    }

    public RouteDefinition from(Endpoint endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition from(EndpointConsumerBuilder endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition route() {
        return this.route;
    }

    @Override
    public RouteTemplateDefinition description(String description) {
        this.setDescription(description);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name) {
        this.addTemplateParameter(name, null);
        return this;
    }

    public RouteTemplateDefinition templateOptionalParameter(String name) {
        this.addTemplateOptionalParameter(name, null);
        return this;
    }

    public RouteTemplateDefinition templateOptionalParameter(String name, String description) {
        this.addTemplateOptionalParameter(name, description);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue, String description) {
        this.addTemplateParameter(name, defaultValue, description);
        return this;
    }

    public RouteTemplateDefinition templateParameters(Map<String, String> parameters) {
        parameters.forEach(this::addTemplateParameter);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        def.setBeanType(type);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Object bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier)bean);
        } else if (bean instanceof Supplier) {
            def.setBeanSupplier(ctx -> ((Supplier)bean).get());
        } else if (bean instanceof String) {
            String str = (String)bean;
            def.setType(str);
        } else {
            def.setBeanSupplier(ctx -> bean);
        }
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Supplier<Object> bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        def.setBeanSupplier(ctx -> bean.get());
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type, RouteTemplateContext.BeanSupplier<Object> bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setBeanSupplier(bean);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, String language, String script) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        def.setScriptLanguage(language);
        def.setScript(script);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type, String language, String script) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition def = new BeanFactoryDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setScriptLanguage(language);
        def.setScript(script);
        this.templateBeans.add(def);
        return this;
    }

    public BeanFactoryDefinition<RouteTemplateDefinition> templateBean(String name) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<BeanFactoryDefinition<RouteTemplateDefinition>>();
        }
        BeanFactoryDefinition<RouteTemplateDefinition> def = new BeanFactoryDefinition<RouteTemplateDefinition>();
        def.setParent(this);
        def.setName(name);
        this.templateBeans.add(def);
        return def;
    }

    public RouteTemplateDefinition configure(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
        return this;
    }

    @Override
    public String getShortName() {
        return "routeTemplate";
    }

    @Override
    public String getLabel() {
        return "RouteTemplate[" + this.route.getInput().getLabel() + "]";
    }

    private void addTemplateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue, null);
    }

    private void addTemplateParameter(String name, String defaultValue, String description) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<RouteTemplateParameterDefinition>();
        }
        this.templateParameters.add(new RouteTemplateParameterDefinition(name, defaultValue, description));
    }

    private void addTemplateOptionalParameter(String name, String description) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<RouteTemplateParameterDefinition>();
        }
        RouteTemplateParameterDefinition def = new RouteTemplateParameterDefinition(name, null, description);
        def.setRequired(false);
        this.templateParameters.add(def);
    }

    public RouteDefinition asRouteDefinition() {
        RouteDefinition copy = new RouteDefinition();
        copy.setErrorHandlerRef(this.route.getErrorHandlerRef());
        if (this.route.isErrorHandlerFactorySet()) {
            copy.setErrorHandlerFactory(this.route.getErrorHandlerFactory());
        }
        copy.setErrorHandler(this.route.getErrorHandler());
        copy.setAutoStartup(this.route.getAutoStartup());
        copy.setDelayer(this.route.getDelayer());
        copy.setGroup(this.route.getGroup());
        copy.setInheritErrorHandler(this.route.isInheritErrorHandler());
        copy.setInput(this.route.getInput().copy());
        copy.setInputType(this.route.getInputType());
        copy.setLogMask(this.route.getLogMask());
        copy.setMessageHistory(this.route.getMessageHistory());
        copy.setOutputType(this.route.getOutputType());
        copy.setOutputs(ProcessorDefinitionHelper.deepCopyDefinitions(this.route.getOutputs()));
        copy.setRoutePolicies(this.shallowCopy(this.route.getRoutePolicies()));
        copy.setRoutePolicyRef(this.route.getRoutePolicyRef());
        copy.setRouteProperties(this.shallowCopy(this.route.getRouteProperties()));
        copy.setShutdownRoute(this.route.getShutdownRoute());
        copy.setShutdownRunningTask(this.route.getShutdownRunningTask());
        copy.setStartupOrder(this.route.getStartupOrder());
        copy.setStreamCache(this.route.getStreamCache());
        copy.setTemplate(true);
        copy.setTrace(this.route.getTrace());
        if (this.route.getDescription() != null) {
            copy.setDescription(this.route.getDescription());
        } else {
            copy.setDescription(this.getDescription());
        }
        copy.setPrecondition(this.route.getPrecondition());
        copy.setRouteConfigurationId(this.route.getRouteConfigurationId());
        copy.setTemplateParameters(this.shallowCopy(this.route.getTemplateParameters()));
        return copy;
    }

    private <T> List<T> shallowCopy(List<T> list) {
        return list != null ? new ArrayList<T>(list) : null;
    }

    private <K, V> Map<K, V> shallowCopy(Map<K, V> map) {
        return map != null ? new HashMap<K, V>(map) : null;
    }

    @FunctionalInterface
    public static interface Converter {
        public static final Converter DEFAULT_CONVERTER = new Converter(){

            @Override
            public RouteDefinition apply(RouteTemplateDefinition in, Map<String, Object> parameters) throws Exception {
                return in.asRouteDefinition();
            }
        };

        public RouteDefinition apply(RouteTemplateDefinition var1, Map<String, Object> var2) throws Exception;
    }
}

