/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.details;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.EnsureContainers;
import org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.curator.x.discovery.details.ServiceDiscoveryImpl;

public class ServiceCacheImpl<T>
implements ServiceCache<T>,
PathChildrenCacheListener {
    private final StandardListenerManager<ServiceCacheListener> listenerContainer = StandardListenerManager.standard();
    private final ServiceDiscoveryImpl<T> discovery;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final CuratorCacheBridge cache;
    private final ConcurrentMap<String, ServiceInstance<T>> instances = Maps.newConcurrentMap();
    private final EnsureContainers ensureContainers;
    private final CountDownLatch initializedLatch = new CountDownLatch(1);
    @VisibleForTesting
    volatile CountDownLatch debugStartLatch = null;
    volatile CountDownLatch debugStartWaitLatch = null;

    private static ExecutorService convertThreadFactory(ThreadFactory threadFactory) {
        Preconditions.checkNotNull(threadFactory, "threadFactory cannot be null");
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    ServiceCacheImpl(ServiceDiscoveryImpl<T> discovery, String name, ThreadFactory threadFactory) {
        this(discovery, name, ServiceCacheImpl.convertThreadFactory(threadFactory));
    }

    ServiceCacheImpl(ServiceDiscoveryImpl<T> discovery, String name, ExecutorService executorService) {
        Preconditions.checkNotNull(discovery, "discovery cannot be null");
        Preconditions.checkNotNull(name, "name cannot be null");
        this.discovery = discovery;
        String path = discovery.pathForName(name);
        this.cache = CuratorCache.bridgeBuilder(discovery.getClient(), path).withExecutorService(executorService).withDataNotCached().build();
        CuratorCacheListener listener = CuratorCacheListener.builder().forPathChildrenCache(path, discovery.getClient(), this).forInitialized(this::initialized).build();
        this.cache.listenable().addListener(listener);
        this.ensureContainers = new EnsureContainers(discovery.getClient(), path);
    }

    @Override
    public List<ServiceInstance<T>> getInstances() {
        return Lists.newArrayList(this.instances.values());
    }

    @Override
    public void start() throws Exception {
        this.startImmediate().await();
    }

    @Override
    public CountDownLatch startImmediate() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.ensureContainers.ensure();
        this.cache.start();
        if (this.debugStartLatch != null) {
            this.initializedLatch.await();
            this.debugStartLatch.countDown();
            this.debugStartLatch = null;
        }
        if (this.debugStartWaitLatch != null) {
            this.debugStartWaitLatch.await();
            this.debugStartWaitLatch = null;
        }
        return this.initializedLatch;
    }

    @Override
    public void close() {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.STOPPED), "Already closed or has not been started");
        this.listenerContainer.forEach(l -> this.discovery.getClient().getConnectionStateListenable().removeListener((ConnectionStateListener)l));
        this.listenerContainer.clear();
        CloseableUtils.closeQuietly(this.cache);
        this.discovery.cacheClosed(this);
    }

    @Override
    public void addListener(ServiceCacheListener listener) {
        this.listenerContainer.addListener(listener);
        this.discovery.getClient().getConnectionStateListenable().addListener(listener);
    }

    @Override
    public void addListener(ServiceCacheListener listener, Executor executor) {
        this.listenerContainer.addListener(listener, executor);
        this.discovery.getClient().getConnectionStateListenable().addListener(listener, executor);
    }

    @Override
    public void removeListener(ServiceCacheListener listener) {
        this.listenerContainer.removeListener(listener);
        this.discovery.getClient().getConnectionStateListenable().removeListener(listener);
    }

    @Override
    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
        boolean notifyListeners = false;
        switch (event.getType()) {
            case CHILD_ADDED: 
            case CHILD_UPDATED: {
                this.addInstance(event.getData());
                notifyListeners = true;
                break;
            }
            case CHILD_REMOVED: {
                this.instances.remove(this.instanceIdFromData(event.getData()));
                notifyListeners = true;
            }
        }
        if (notifyListeners && this.initializedLatch.getCount() == 0L) {
            this.listenerContainer.forEach(ServiceCacheListener::cacheChanged);
        }
    }

    private String instanceIdFromData(ChildData childData) {
        return ZKPaths.getNodeFromPath(childData.getPath());
    }

    private void addInstance(ChildData childData) {
        try {
            String instanceId = this.instanceIdFromData(childData);
            ServiceInstance<T> serviceInstance = this.discovery.getSerializer().deserialize(childData.getData());
            this.instances.put(instanceId, serviceInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialized() {
        this.discovery.cacheOpened(this);
        this.initializedLatch.countDown();
    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

