/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cluster;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZooKeeperClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterView.class);
    private final ZooKeeperCuratorConfiguration configuration;
    private final CuratorFramework client;
    private final CuratorLocalMember localMember = new CuratorLocalMember();
    private volatile LeaderSelector leaderSelector;

    public ZooKeeperClusterView(CamelClusterService cluster, ZooKeeperCuratorConfiguration configuration, CuratorFramework client, String namespace) {
        super(cluster, namespace);
        this.configuration = configuration;
        this.client = client;
    }

    @Override
    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    @Override
    public Optional<CamelClusterMember> getLeader() {
        if (this.leaderSelector == null || this.isStoppingOrStopped()) {
            return Optional.empty();
        }
        try {
            Participant participant = this.leaderSelector.getLeader();
            return ObjectHelper.equal(participant.getId(), this.localMember.getId()) ? Optional.of(this.localMember) : Optional.of(new CuratorClusterMember(participant));
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.debug("Failed to get get master because node '{}' does not yet exist (error: '{}')", (Object)this.getFullPath(), (Object)e.getMessage());
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public List<CamelClusterMember> getMembers() {
        if (this.leaderSelector == null) {
            return Collections.emptyList();
        }
        try {
            return this.leaderSelector.getParticipants().stream().map(x$0 -> new CuratorClusterMember((Participant)x$0)).collect(Collectors.toList());
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.debug("Failed to get members because node '{}' does not yet exist (error: '{}')", (Object)this.getFullPath(), (Object)e.getMessage());
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.leaderSelector == null) {
            this.leaderSelector = new LeaderSelector(this.client, this.getFullPath(), new CamelLeaderElectionListener());
            this.leaderSelector.setId(this.getClusterService().getId());
            this.leaderSelector.start();
        } else {
            this.leaderSelector.requeue();
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.leaderSelector != null) {
            this.leaderSelector.interruptLeadership();
            this.fireLeadershipChangedEvent((CamelClusterMember)this.getLeader().orElse(null));
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.leaderSelector != null) {
            this.leaderSelector.close();
        }
    }

    private String getFullPath() {
        return this.configuration.getBasePath() + "/" + this.getNamespace();
    }

    private final class CuratorLocalMember
    implements CamelClusterMember {
        private CuratorLocalMember() {
        }

        @Override
        public boolean isLeader() {
            return ZooKeeperClusterView.this.leaderSelector != null && ZooKeeperClusterView.this.leaderSelector.hasLeadership();
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public String getId() {
            return ZooKeeperClusterView.this.getClusterService().getId();
        }
    }

    private final class CuratorClusterMember
    implements CamelClusterMember {
        private final Participant participant;

        CuratorClusterMember(Participant participant) {
            this.participant = participant;
        }

        @Override
        public String getId() {
            return this.participant.getId();
        }

        @Override
        public boolean isLocal() {
            return this.participant.getId() != null && ObjectHelper.equal(this.participant.getId(), ZooKeeperClusterView.this.localMember.getId());
        }

        @Override
        public boolean isLeader() {
            try {
                return ZooKeeperClusterView.this.leaderSelector.getLeader().equals(this.participant);
            }
            catch (Exception e) {
                LOGGER.debug("{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
    }

    private final class CamelLeaderElectionListener
    extends LeaderSelectorListenerAdapter {
        private CamelLeaderElectionListener() {
        }

        @Override
        public void takeLeadership(CuratorFramework curatorFramework) throws Exception {
            ZooKeeperClusterView.this.fireLeadershipChangedEvent(ZooKeeperClusterView.this.localMember);
            ForegroundTask task = Tasks.foregroundTask().withBudget(Budgets.iterationBudget().withMaxIterations(-1).withInterval(Duration.ofSeconds(5L)).build()).build();
            task.run(() -> !ZooKeeperClusterView.this.isRunAllowed());
            ZooKeeperClusterView.this.fireLeadershipChangedEvent(ZooKeeperClusterView.this.getLeader().orElse(null));
        }
    }
}

