/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.FutureEventDrivenOperation;
import org.apache.camel.component.zookeeper.operations.GetDataOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class DataChangedOperation
extends FutureEventDrivenOperation<byte[]> {
    protected static final Class[] CONSTRUCTOR_ARGS = new Class[]{ZooKeeper.class, String.class, Boolean.TYPE, Boolean.TYPE};
    private boolean getChangedData;
    private boolean sendEmptyMessageOnDelete;

    public DataChangedOperation(ZooKeeper connection, String znode, boolean getChangedData) {
        this(connection, znode, getChangedData, false);
    }

    public DataChangedOperation(ZooKeeper connection, String znode, boolean getChangedData, boolean sendEmptyMessageOnDelete) {
        super(connection, znode, Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted);
        this.getChangedData = getChangedData;
        this.sendEmptyMessageOnDelete = sendEmptyMessageOnDelete;
    }

    @Override
    protected void installWatch() {
        this.connection.getData(this.getNode(), this, (rc, path, ctx, data, stat) -> {}, null);
    }

    @Override
    public OperationResult<byte[]> getResult() {
        OperationResult<byte[]> answer = Watcher.Event.EventType.NodeDeleted.equals((Object)this.getWatchedEvent().getType()) && this.sendEmptyMessageOnDelete ? new OperationResult<byte[]>(null, null) : (this.getChangedData ? new GetDataOperation(this.connection, this.getNode()).getResult() : null);
        return answer;
    }

    @Override
    public ZooKeeperOperation<?> createCopy() throws Exception {
        return (ZooKeeperOperation)this.getClass().getConstructor(CONSTRUCTOR_ARGS).newInstance(this.connection, this.node, this.getChangedData, this.sendEmptyMessageOnDelete);
    }
}

