/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.FutureEventDrivenOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ExistenceChangedOperation
extends FutureEventDrivenOperation<String> {
    public ExistenceChangedOperation(ZooKeeper connection, String znode) {
        super(connection, znode, Watcher.Event.EventType.NodeCreated, Watcher.Event.EventType.NodeDeleted);
    }

    @Override
    protected void installWatch() {
        this.connection.exists(this.getNode(), this, (rc, path, ctx, stat) -> {}, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Installed exists watch");
        }
    }

    @Override
    public OperationResult<String> getResult() {
        try {
            String path = this.getNode();
            Stat statistics = this.connection.exists(path, true);
            return new OperationResult<String>(path, statistics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<String>(e);
        }
        catch (Exception e) {
            return new OperationResult<String>(e);
        }
    }
}

