/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.List;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class GetChildrenOperation
extends ZooKeeperOperation<List<String>> {
    public GetChildrenOperation(ZooKeeper connection, String node) {
        super(connection, node);
    }

    @Override
    public OperationResult<List<String>> getResult() {
        try {
            Stat statistics = new Stat();
            List<String> children = this.connection.getChildren(this.node, true, statistics);
            if (LOG.isDebugEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Received children from '%s' path with statistics '%s'", this.node, statistics));
                } else {
                    LOG.debug(String.format("Received children from '%s' path ", this.node));
                }
            }
            return new OperationResult<List<String>>(children, statistics);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<List<String>>(e);
        }
        catch (Exception e) {
            return new OperationResult<List<String>>(e);
        }
    }
}

