/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCache {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseCache.class);
    public static final int DEFAULT_RESPONSE_CACHE_SIZE = 400;
    private final int cacheSize;
    private final Map<String, Entry> cache;

    public ResponseCache(int cacheSize, String requestType) {
        this.cacheSize = cacheSize;
        this.cache = Collections.synchronizedMap(new LRUCache(cacheSize));
        LOG.info("{} response cache size is initialized with value {}.", (Object)requestType, (Object)cacheSize);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void put(String path, byte[] data, Stat stat) {
        this.cache.put(path, new Entry(stat, data));
    }

    public byte[] get(String key, Stat stat) {
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        if (!stat.equals(entry.stat)) {
            this.cache.remove(key);
            return null;
        }
        return entry.data;
    }

    public boolean isEnabled() {
        return this.cacheSize > 0;
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int cacheSize;

        LRUCache(int cacheSize) {
            super(cacheSize / 4, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.cacheSize;
        }
    }

    private static class Entry {
        public final Stat stat;
        public final byte[] data;

        Entry(Stat stat, byte[] data) {
            this.stat = stat;
            this.data = data;
        }
    }
}

