/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import org.apache.camel.component.zookeepermaster.CamelNodeState;
import org.apache.camel.component.zookeepermaster.ZookeeperGroupSupport;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.curator.framework.CuratorFramework;

public abstract class ZookeeperComponentSupport
extends DefaultComponent {
    private final ZookeeperGroupSupport zookeeperGroupSupport = new ZookeeperGroupSupport();
    @Metadata(label="advanced")
    private CuratorFramework curator;
    @Metadata(defaultValue="10000")
    private int maximumConnectionTimeout = 10000;
    @Metadata(defaultValue="localhost:2181")
    private String zooKeeperUrl;
    @Metadata(label="security", secret=true)
    private String zooKeeperPassword;

    public Group<CamelNodeState> createGroup(String path) {
        return this.zookeeperGroupSupport.createGroup(path);
    }

    public CuratorFramework getCurator() {
        return this.zookeeperGroupSupport.getCurator();
    }

    public void setCurator(CuratorFramework curator) {
        this.zookeeperGroupSupport.setCurator(curator);
    }

    public int getMaximumConnectionTimeout() {
        return this.zookeeperGroupSupport.getMaximumConnectionTimeout();
    }

    public void setMaximumConnectionTimeout(int maximumConnectionTimeout) {
        this.zookeeperGroupSupport.setMaximumConnectionTimeout(maximumConnectionTimeout);
    }

    public String getZooKeeperUrl() {
        return this.zookeeperGroupSupport.getZooKeeperUrl();
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zookeeperGroupSupport.setZooKeeperUrl(zooKeeperUrl);
    }

    public String getZooKeeperPassword() {
        return this.zookeeperGroupSupport.getZooKeeperPassword();
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zookeeperGroupSupport.setZooKeeperPassword(zooKeeperPassword);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.zookeeperGroupSupport.setCamelContext(this.getCamelContext());
        ServiceHelper.startService((Object)this.zookeeperGroupSupport);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopAndShutdownServices(this.zookeeperGroupSupport);
    }
}

