/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group.internal;

import java.util.Arrays;
import org.apache.zookeeper.data.Stat;

public class ChildData<T>
implements Comparable<ChildData> {
    private final String path;
    private final Stat stat;
    private final byte[] data;
    private final T node;

    ChildData(String path, Stat stat, byte[] data, T node) {
        this.path = path;
        this.stat = stat;
        this.data = data;
        this.node = node;
    }

    @Override
    public int compareTo(ChildData rhs) {
        if (this == rhs) {
            return 0;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return -1;
        }
        return this.path.compareTo(rhs.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildData childData = (ChildData)o;
        if (!Arrays.equals(this.data, childData.data)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(childData.path) : childData.path != null) {
            return false;
        }
        return !(this.stat != null ? !this.stat.equals(childData.stat) : childData.stat != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.stat != null ? this.stat.hashCode() : 0);
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public Stat getStat() {
        return this.stat;
    }

    public byte[] getData() {
        return this.data;
    }

    public T getNode() {
        return this.node;
    }

    public String toString() {
        return "ChildData{path='" + this.path + "', stat=" + this.stat + ", data=" + Arrays.toString(this.data) + "}";
    }
}

