/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.policy;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeepermaster.CamelNodeState;
import org.apache.camel.component.zookeepermaster.ContainerIdFactory;
import org.apache.camel.component.zookeepermaster.DefaultContainerIdFactory;
import org.apache.camel.component.zookeepermaster.ZookeeperGroupListenerSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed MasterRoutePolicy")
public class MasterRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRoutePolicy.class);
    private CuratorFramework curator;
    private int maximumConnectionTimeout = 10000;
    private String zooKeeperUrl;
    private String zooKeeperPassword;
    private String zkRoot = "/camel/zookeepermaster/clusters/master";
    private String groupName;
    private ContainerIdFactory containerIdFactory = new DefaultContainerIdFactory();
    private final AtomicBoolean masterConsumer = new AtomicBoolean();
    private ZookeeperGroupListenerSupport groupListener;
    private volatile CamelNodeState thisNodeState;
    private CamelContext camelContext;
    private Route route;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    @ManagedAttribute(description="The name of the cluster group to use")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public ContainerIdFactory getContainerIdFactory() {
        return this.containerIdFactory;
    }

    public void setContainerIdFactory(ContainerIdFactory containerIdFactory) {
        this.containerIdFactory = containerIdFactory;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    @ManagedAttribute(description="Timeout in millis to use when connecting to the zookeeper ensemble")
    public int getMaximumConnectionTimeout() {
        return this.maximumConnectionTimeout;
    }

    public void setMaximumConnectionTimeout(int maximumConnectionTimeout) {
        this.maximumConnectionTimeout = maximumConnectionTimeout;
    }

    @ManagedAttribute(description="The url for the zookeeper ensemble")
    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public String getZooKeeperPassword() {
        return this.zooKeeperPassword;
    }

    public void setZooKeeperPassword(String zooKeeperPassword) {
        this.zooKeeperPassword = zooKeeperPassword;
    }

    @ManagedAttribute(description="Are we connected to ZooKeeper")
    public boolean isConnected() {
        if (this.groupListener == null) {
            return false;
        }
        return this.groupListener.getGroup().isConnected();
    }

    @ManagedAttribute(description="Are we the master")
    public boolean isMaster() {
        if (this.groupListener == null) {
            return false;
        }
        return this.groupListener.getGroup().isMaster();
    }

    @ManagedOperation(description="Information about all the slaves")
    public String slaves() {
        if (this.groupListener == null) {
            return null;
        }
        try {
            return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).writeValueAsString(this.groupListener.getGroup().slaves());
        }
        catch (Exception e) {
            return null;
        }
    }

    @ManagedOperation(description="Information about the last event in the cluster group")
    public String lastEvent() {
        if (this.groupListener == null) {
            return null;
        }
        CamelNodeState event = this.groupListener.getGroup().getLastState();
        return event != null ? ((Object)event).toString() : null;
    }

    @ManagedOperation(description="Information about this node")
    public String thisNode() {
        return this.thisNodeState != null ? this.thisNodeState.toString() : null;
    }

    @Override
    public void onInit(Route route) {
        super.onInit(route);
        this.route = route;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        StringHelper.notEmpty("groupName", this.groupName);
        String path = this.getCamelClusterPath(this.groupName);
        this.groupListener = new ZookeeperGroupListenerSupport(path, this.route.getEndpoint(), this.onLockOwned(), this.onDisconnected());
        this.groupListener.setCamelContext(this.camelContext);
        this.groupListener.setCurator(this.curator);
        this.groupListener.setMaximumConnectionTimeout(this.maximumConnectionTimeout);
        this.groupListener.setZooKeeperUrl(this.zooKeeperUrl);
        this.groupListener.setZooKeeperPassword(this.zooKeeperPassword);
        ServiceHelper.startService((Object)this.groupListener);
        LOG.info("Attempting to become master for endpoint: {} in {} with singletonID: {}", new Object[]{this.route.getEndpoint(), this.getCamelContext(), this.getGroupName()});
        this.thisNodeState = this.createNodeState();
        this.groupListener.updateState(this.thisNodeState);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopAndShutdownServices(this.groupListener);
        this.masterConsumer.set(false);
    }

    protected Runnable onLockOwned() {
        return () -> {
            if (this.masterConsumer.compareAndSet(false, true)) {
                try {
                    LOG.info("Elected as master. Starting consumer: {}", (Object)this.route.getEndpoint());
                    this.startConsumer(this.route.getConsumer());
                    this.thisNodeState = this.createNodeState();
                    this.thisNodeState.setStarted(true);
                    this.groupListener.updateState(this.thisNodeState);
                }
                catch (Exception e) {
                    LOG.error("Failed to start master consumer for: {}", (Object)this.route.getEndpoint(), (Object)e);
                }
                LOG.info("Elected as master. Consumer started: {}", (Object)this.route.getEndpoint());
            }
        };
    }

    protected Runnable onDisconnected() {
        return () -> {
            this.masterConsumer.set(false);
            try {
                this.stopConsumer(this.route.getConsumer());
            }
            catch (Exception e) {
                LOG.warn("Failed to stop master consumer: {}", (Object)this.route.getEndpoint(), (Object)e);
            }
        };
    }

    protected String getCamelClusterPath(String name) {
        Object path = name;
        if (ObjectHelper.isNotEmpty(this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }

    private CamelNodeState createNodeState() {
        String containerId = this.getContainerIdFactory().newContainerId();
        CamelNodeState state = new CamelNodeState(this.getGroupName(), containerId);
        state.setConsumer(this.route.getEndpoint().getEndpointUri());
        return state;
    }
}

