/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.metric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.metrics.Summary;
import org.apache.zookeeper.server.metric.Metric;

public class AvgMinMaxCounter
extends Metric
implements Summary {
    private final String name;
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong count = new AtomicLong();

    public AvgMinMaxCounter(String name) {
        this.name = name;
    }

    public void addDataPoint(long value) {
        this.total.addAndGet(value);
        this.count.incrementAndGet();
        this.setMin(value);
        this.setMax(value);
    }

    private void setMax(long value) {
        long current;
        while (value > (current = this.max.get()) && !this.max.compareAndSet(current, value)) {
        }
    }

    private void setMin(long value) {
        long current;
        while (value < (current = this.min.get()) && !this.min.compareAndSet(current, value)) {
        }
    }

    public double getAvg() {
        long currentCount = this.count.get();
        long currentTotal = this.total.get();
        if (currentCount > 0L) {
            double avgLatency = (double)currentTotal / (double)currentCount;
            BigDecimal bg = new BigDecimal(avgLatency);
            return bg.setScale(4, RoundingMode.HALF_UP).doubleValue();
        }
        return 0.0;
    }

    public long getCount() {
        return this.count.get();
    }

    public long getMax() {
        long current = this.max.get();
        return current == Long.MIN_VALUE ? 0L : current;
    }

    public long getMin() {
        long current = this.min.get();
        return current == Long.MAX_VALUE ? 0L : current;
    }

    public long getTotal() {
        return this.total.get();
    }

    public void resetMax() {
        this.max.set(this.getMin());
    }

    @Override
    public void reset() {
        this.count.set(0L);
        this.total.set(0L);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
    }

    @Override
    public void add(long value) {
        this.addDataPoint(value);
    }

    @Override
    public Map<String, Object> values() {
        LinkedHashMap<String, Object> m4 = new LinkedHashMap<String, Object>();
        m4.put("avg_" + this.name, this.getAvg());
        m4.put("min_" + this.name, this.getMin());
        m4.put("max_" + this.name, this.getMax());
        m4.put("cnt_" + this.name, this.getCount());
        m4.put("sum_" + this.name, this.getTotal());
        return m4;
    }
}

