/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group.internal;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.GroupFactory;
import org.apache.camel.component.zookeepermaster.group.NodeState;
import org.apache.camel.component.zookeepermaster.group.internal.ZooKeeperGroup;
import org.apache.camel.component.zookeepermaster.group.internal.ZooKeeperMultiGroup;
import org.apache.curator.framework.CuratorFramework;

public class ZooKeeperGroupFactory
implements GroupFactory {
    private CuratorFramework curator;

    public ZooKeeperGroupFactory(CuratorFramework curator) {
        this.curator = curator;
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
        return new ZooKeeperGroup<T>(this.curator, path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        return new ZooKeeperGroup<T>(this.curator, path, clazz, threadFactory);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
        return new ZooKeeperMultiGroup<T>(this.curator, path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        return new ZooKeeperMultiGroup<T>(this.curator, path, clazz, threadFactory);
    }
}

