/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class PopulateAndGenerateReportServerCommand
extends AbstractServerCommand {
    public PopulateAndGenerateReportServerCommand() {
    }

    public PopulateAndGenerateReportServerCommand(String jdbcUrl, String dbDriver, String dbUser, String dbPassword, String filePath, String template) {
        this();
        this.setValue("JDBC_URL", jdbcUrl);
        this.setValue("DB_DRIVER", dbDriver);
        this.setValue("DB_USER", dbUser);
        this.setValue("USER_PASSWORD", dbPassword);
        this.setValue("FILEPATH", filePath);
        this.setValue("TEMPLATE", template);
    }

    public PopulateAndGenerateReportServerCommand(String jdbcUrl, String dbDriver, String dbUser, String dbPassword, String template) {
        this(jdbcUrl, dbDriver, dbUser, dbPassword, null, template);
    }

    @Override
    public String writeToString(boolean forDisplay) {
        String template;
        String branch;
        String dbUser;
        String dbDriver;
        CommandStringBuilder builder = new CommandStringBuilder("populateAudit");
        String jdbcUrl = this.getJdbcUrl();
        if (jdbcUrl != null) {
            builder.addOptionWithArgument("ju", jdbcUrl);
        }
        if ((dbDriver = this.getDbDriver()) != null) {
            builder.addOptionWithArgument("dd", dbDriver);
        }
        if ((dbUser = this.getDbUser()) != null) {
            builder.addOptionWithArgument("du", dbUser);
            String dbPassword = this.getDbPassword();
            if (dbPassword != null && dbPassword.length() > 0) {
                builder.addOptionWithArgument("up", this.getDisplayPassword(dbPassword, forDisplay));
            }
        }
        if ((branch = this.getFilePath()) != null) {
            builder.addOptionWithArgument("fp", branch);
        }
        if ((template = this.getTemplate()) != null) {
            builder.addOptionWithArgument("t", template);
        }
        return builder.toString();
    }

    @Override
    public String writeToString() {
        return this.writeToString(false);
    }

    @Override
    public String toString() {
        return this.writeToString(true);
    }

    public String getDbDriver() {
        return (String)this.getValue("DB_DRIVER");
    }

    public String getJdbcUrl() {
        return (String)this.getValue("JDBC_URL");
    }

    public String getDbUser() {
        return (String)this.getValue("DB_USER");
    }

    public String getDbPassword() {
        return (String)this.getValue("USER_PASSWORD");
    }

    public String getFilePath() {
        return (String)this.getValue("FILEPATH");
    }

    private String getTemplate() {
        return (String)this.getValue("TEMPLATE");
    }
}

