/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class PopulateAuditServerCommand
extends AbstractServerCommand {
    public PopulateAuditServerCommand() {
    }

    public PopulateAuditServerCommand(String jdbcUrl, String dbDriver, String dbUser, String dbPassword) {
        this();
        this.setValue("JDBC_URL", jdbcUrl);
        this.setValue("DB_DRIVER", dbDriver);
        this.setValue("DB_USER", dbUser);
        this.setValue("USER_PASSWORD", dbPassword);
    }

    public String getJdbcUrl() {
        return (String)this.getValue("JDBC_URL");
    }

    public String getDbDriver() {
        return (String)this.getValue("DB_DRIVER");
    }

    public String getDbUser() {
        return (String)this.getValue("DB_USER");
    }

    public String getDbPassword() {
        return (String)this.getValue("USER_PASSWORD");
    }

    @Override
    public String writeToString() {
        return this.writeToString(false);
    }

    @Override
    public String writeToString(boolean forDisplay) {
        String dbUser;
        String dbDriver;
        CommandStringBuilder builder = new CommandStringBuilder("populateAudit");
        String jdbcUrl = this.getJdbcUrl();
        if (jdbcUrl != null) {
            builder.addOptionWithArgument("ju", jdbcUrl);
        }
        if ((dbDriver = this.getDbDriver()) != null) {
            builder.addOptionWithArgument("dd", dbDriver);
        }
        if ((dbUser = this.getDbUser()) != null) {
            builder.addOptionWithArgument("du", dbUser);
            String dbPassword = this.getDbPassword();
            if (dbPassword != null && dbPassword.length() > 0) {
                builder.addOptionWithArgument("up", this.getDisplayPassword(dbPassword, forDisplay));
            }
        }
        return builder.toString();
    }
}

