/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class Base64SerializationHelper {
    public Object decode(String string, final Class<?> ... expectedTypes) throws IOException, ClassNotFoundException {
        byte[] base64 = Base64.decodeBase64(string.getBytes("UTF8"));
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(base64)){
                private boolean valid;

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (expectedTypes != null && !this.valid) {
                        if (Arrays.stream(expectedTypes).anyMatch(c -> c.getName().equals(desc.getName()))) {
                            this.valid = true;
                        } else {
                            throw new InvalidClassException("Unauthorized deserialization attempt", desc.getName());
                        }
                    }
                    return super.resolveClass(desc);
                }
            };
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            objectInputStream.close();
        }
        catch (Exception exception) {}
        return object;
    }

    public String encode(Object object) throws IOException {
        byte[] base64;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream).writeObject(object);
            base64 = Base64.encodeBase64(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {}
        return new String(base64, "UTF8");
    }
}

