/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commons.utils.threading.lockerbykey;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.commons.utils.threading.lockerbykey.ILockerByKey;
import org.talend.commons.utils.threading.lockerbykey.LockerByKey;
import org.talend.commons.utils.threading.lockerbykey.LockerValue;
import org.talend.commons.utils.threading.lockerbykey.LockerValueHandler;

public class LockerByKeyUnrestricted<KP>
implements ILockerByKey<KP> {
    private static final String NOT_ALREADY_LOCKED_MESSAGE = "Already unlocked by an other thread or never locked, ensure all the unlock() operations of this locker are called after their lock has really locked:";
    private static Logger log = LoggerFactory.getLogger(LockerByKeyUnrestricted.class);
    private ExecutorService threadPool;
    private LockerByKey<KP> locker;
    private final Object lockAllOperations = new Object();
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger runningOperations = new AtomicInteger();
    private static final int DEFAULT_CLEAN_PERIOD = 500;
    private static final boolean DEFAULT_FAIR = true;
    private volatile boolean blockAllOperations;
    private volatile boolean shuttingDown;
    private volatile boolean stopped;
    private int cleanPeriod;

    public LockerByKeyUnrestricted() {
        this(true, 500);
    }

    public LockerByKeyUnrestricted(boolean fair) {
        this(fair, 500);
    }

    public LockerByKeyUnrestricted(int cleanPeriod) {
        this(true, cleanPeriod);
    }

    public LockerByKeyUnrestricted(boolean fair, int cleanPeriod) {
        if (cleanPeriod <= 0) {
            throw new IllegalArgumentException("The cleanPeriod value has to be greater than 0");
        }
        boolean cleanDisabled = true;
        this.locker = new LockerByKey(fair, cleanDisabled);
        this.threadPool = this.intializePool(LockerByKeyUnrestricted.class.getSimpleName());
        this.cleanPeriod = cleanPeriod;
    }

    protected ExecutorService intializePool(final String poolName) {
        ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = this.defaultThreadFactory.newThread(r);
                newThread.setName(poolName + "_" + newThread.getName());
                return newThread;
            }
        });
        return threadPool;
    }

    @Override
    public void lockInterruptibly(KP key) throws InterruptedException {
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            this.locker.lockInterruptibly(key);
        }
        finally {
            this.decrementRunningOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockInterruptiblyUnrestricted(final KP key) throws InterruptedException {
        this.checkStopped();
        this.blockOperationIfRequired();
        LockerValue<KP> lockerValue = null;
        LockerValueHandler handler = null;
        if (this.tryLockUnrestricted(key)) {
            return;
        }
        this.incrementRunningOperations();
        lockerValue = this.locker.getLockerValue(key);
        if (this.locker != null && (handler = lockerValue.getHandler()) != null && Thread.currentThread() == handler.getCallerThreadLocker()) {
            this.decrementRunningOperations();
            return;
        }
        try {
            Thread threadLocker = Thread.currentThread();
            final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
            final AtomicBoolean hasError = new AtomicBoolean();
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        LockerByKeyUnrestricted.this.locker.lockInterruptibly(key);
                    }
                    catch (Exception e) {
                        hasError.set(true);
                        throw e;
                    }
                    finally {
                        cyclicBarrier.await();
                    }
                    cyclicBarrier.await();
                    boolean unlocked = LockerByKeyUnrestricted.this.locker.unlock(key);
                    return unlocked;
                }
            };
            Future<Boolean> futureTask = this.threadPool.submit(callable);
            try {
                cyclicBarrier.await();
            }
            catch (BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
            if (hasError.get()) {
                try {
                    futureTask.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    throw new RuntimeException(e);
                }
            }
            lockerValue = this.locker.getLockerValue(key);
            lockerValue.addHandler(new LockerValueHandler(futureTask, cyclicBarrier, threadLocker));
        }
        finally {
            this.decrementRunningOperations();
        }
    }

    @Override
    public boolean tryLock(KP key) {
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            boolean bl = this.locker.tryLock(key);
            return bl;
        }
        finally {
            this.decrementRunningOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLockUnrestricted(final KP key) {
        boolean tryLockResultBoolean;
        this.checkStopped();
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            final AtomicBoolean tryLockResult = new AtomicBoolean();
            final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
            Callable<Boolean> callable = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean locked;
                    try {
                        locked = LockerByKeyUnrestricted.this.locker.tryLock(key);
                        tryLockResult.set(locked);
                    }
                    finally {
                        cyclicBarrier.await();
                    }
                    if (locked) {
                        cyclicBarrier.await();
                        return LockerByKeyUnrestricted.this.locker.unlock(key);
                    }
                    return false;
                }
            };
            Future<Boolean> futureTask = this.threadPool.submit(callable);
            try {
                cyclicBarrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            tryLockResultBoolean = tryLockResult.get();
            if (tryLockResultBoolean) {
                LockerValue<KP> lockerValue = this.locker.getLockerValue(key);
                Thread callerThreadLocker = Thread.currentThread();
                lockerValue.addHandler(new LockerValueHandler(futureTask, cyclicBarrier, callerThreadLocker));
            }
        }
        finally {
            this.decrementRunningOperations();
        }
        return tryLockResultBoolean;
    }

    @Override
    public boolean tryLock(KP key, long timeout) throws InterruptedException {
        return this.locker.tryLock(key, timeout, TimeUnit.MILLISECONDS);
    }

    public boolean tryLockUnrestricted(KP key, long timeout) throws InterruptedException {
        return this.tryLockUnrestricted(key, timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(KP key, long timeout, TimeUnit unit) throws InterruptedException {
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            boolean bl = this.locker.tryLock(key, timeout, unit);
            return bl;
        }
        finally {
            this.decrementRunningOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLockUnrestricted(final KP key, final long timeout, final TimeUnit unit) throws InterruptedException {
        this.checkStopped();
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        boolean tryLockResultBoolean = false;
        try {
            final AtomicBoolean tryLockResult = new AtomicBoolean();
            final AtomicReference interruptedExceptionFromTryRef = new AtomicReference();
            final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);
            Callable<Boolean> callable = new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    boolean locked = false;
                    try {
                        locked = LockerByKeyUnrestricted.this.locker.tryLock(key, timeout, unit);
                        tryLockResult.set(locked);
                    }
                    catch (InterruptedException e) {
                        interruptedExceptionFromTryRef.set(e);
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        cyclicBarrier.await();
                    }
                    if (locked) {
                        cyclicBarrier.await();
                        return LockerByKeyUnrestricted.this.locker.unlock(key);
                    }
                    return false;
                }
            };
            Future<Boolean> futureTask = this.threadPool.submit(callable);
            try {
                cyclicBarrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            InterruptedException interruptedExceptionFromTry = (InterruptedException)interruptedExceptionFromTryRef.get();
            if (interruptedExceptionFromTry != null) {
                throw interruptedExceptionFromTry;
            }
            tryLockResultBoolean = tryLockResult.get();
            if (tryLockResultBoolean) {
                LockerValue<KP> lockerValue = this.locker.getLockerValue(key);
                Thread threadLocker = Thread.currentThread();
                lockerValue.addHandler(new LockerValueHandler(futureTask, cyclicBarrier, threadLocker));
                this.locker.traceStackForDebugging(lockerValue);
            }
        }
        finally {
            this.decrementRunningOperations();
        }
        return tryLockResultBoolean;
    }

    @Override
    public boolean unlock(KP key) {
        boolean returnedValue = false;
        try {
            this.checkStopped();
            this.blockOperationIfRequired();
            this.incrementRunningOperations();
            returnedValue = this.locker.unlock(key);
        }
        finally {
            this.decrementRunningOperations();
        }
        this.cleanAccordingOperations();
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockUnrestricted(KP key) {
        Boolean resultFuture;
        this.checkStopped();
        this.blockOperationIfRequired();
        this.incrementRunningOperations();
        try {
            LockerValue<KP> lockerValue = this.locker.getLockerValue(key);
            if (lockerValue == null) {
                throw new IllegalStateException("Already unlocked by an other thread or never locked, ensure all the unlock() operations of this locker are called after their lock has really locked: key=" + key);
            }
            LockerValueHandler handler = lockerValue.getHandlerAndRemove();
            if (handler == null) {
                throw new UnsupportedOperationException("Either you have to use the restricted unlock() method to unlock, or you have to use '*Lock*Unrestricted()' methods to lock !");
            }
            CyclicBarrier barrier = handler.getBarrier();
            try {
                barrier.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Future<Boolean> future = handler.getFuture();
            if (future.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            resultFuture = null;
            try {
                resultFuture = future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.decrementRunningOperations();
        }
        this.cleanAccordingOperations();
        return resultFuture;
    }

    @Override
    public int getCleanPeriod() {
        return this.cleanPeriod;
    }

    private void checkStopped() {
        if (this.stopped || this.shuttingDown) {
            throw new IllegalStateException("This locker is already stopped or is shutting down !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAccordingOperations() {
        Object object = this.lockAllOperations;
        synchronized (object) {
            int cleanPeriod = this.getCleanPeriod();
            if (cleanPeriod > 0 && this.counter.incrementAndGet() % cleanPeriod == 0) {
                this.clean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        Object object = this.lockAllOperations;
        synchronized (object) {
            this.waitForRunningOperationsEnded();
            this.locker.clean();
            this.resumeAllOperations();
        }
    }

    private void waitForRunningOperationsEnded() {
        this.blockAllOperations();
        boolean breakAtNext = false;
        while (true) {
            Collection<LockerValue<KP>> values = this.locker.getMapKeyLockToValueLock().values();
            int waitingThreads = 0;
            for (LockerValue<KP> lockerValue : values) {
                waitingThreads += lockerValue.getLock().getQueueLength();
            }
            if (this.runningOperations.get() - waitingThreads <= 0) {
                if (breakAtNext) break;
                breakAtNext = true;
            } else {
                breakAtNext = false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void resumeAllOperations() {
        this.blockAllOperations = false;
        this.lockAllOperations.notifyAll();
    }

    private void blockAllOperations() {
        this.blockAllOperations = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockOperationIfRequired() {
        if (this.blockAllOperations) {
            Object object = this.lockAllOperations;
            synchronized (object) {
                if (this.blockAllOperations) {
                    try {
                        this.lockAllOperations.wait();
                    }
                    catch (InterruptedException e) {
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void decrementRunningOperations() {
        this.runningOperations.decrementAndGet();
    }

    private void incrementRunningOperations() {
        this.runningOperations.incrementAndGet();
    }

    @Override
    public synchronized void shutdownNow() {
        this.shuttingDown = true;
        this.locker.shutdownNow();
        this.threadPool.shutdownNow();
        this.stopped = true;
    }

    @Override
    public synchronized void shutdown() {
        this.shuttingDown = true;
        this.locker.shutdown();
        this.threadPool.shutdown();
        this.stopped = true;
    }

    @Override
    public LockerValue<KP> getLockerValue(KP key) {
        return this.locker.getLockerValue(key);
    }

    @Override
    public boolean isLocked(KP key) {
        return this.locker.isLocked(key);
    }

    @Override
    public List<LockerValue<KP>> getSuspectLocks(long timeDetectionLimitMs) {
        return this.locker.getSuspectLocks(timeDetectionLimitMs);
    }

    @Override
    public void setDetectSuspectLocks(boolean detectSuspectLocks) {
        this.locker.setDetectSuspectLocks(detectSuspectLocks);
    }

    @Override
    public boolean isDetectSuspectLocks() {
        return this.locker.isDetectSuspectLocks();
    }
}

