/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.format;

public final class PresentableBox {
    private static final String ENCAP = "!!";
    private static final String CR = "\n";
    private static final String DASH = "-";
    private static final String SPACE = " ";
    private static final int MAX_BOX_SIZE = 256;
    private static final String MANY_DASHES = PresentableBox.makeRepeat("-", 256);
    private static final String MANY_SPACES = PresentableBox.makeRepeat(" ", 256);
    private final String title;
    private final String subTitle;
    private final int boxSize;
    private final String topLine;
    private final String titleLine;
    private final String subTitleLine;
    private final String bottomLine;
    private final String emptyLine;

    private static String makeRepeat(String in, int nbFold) {
        String ret = "";
        for (int i = 0; i < nbFold; ++i) {
            ret = ret + in;
        }
        return ret;
    }

    public String getTitleLine() {
        return this.titleLine;
    }

    public String getTopLine() {
        return this.topLine;
    }

    public String getBottomLine() {
        return this.bottomLine;
    }

    public String getEmptyLine() {
        return this.emptyLine;
    }

    public String getSubTitleLine() {
        return this.subTitleLine;
    }

    public String getFullBox(String startTokAtEachLine) {
        String tmp = startTokAtEachLine == null ? "" : startTokAtEachLine;
        String tokPar = !tmp.startsWith(CR) ? CR + tmp : tmp;
        String ret = "";
        ret = ret + tokPar + this.getTopLine();
        ret = ret + tokPar + this.getEmptyLine();
        ret = ret + tokPar + this.getTitleLine();
        ret = ret + tokPar + this.getSubTitleLine();
        ret = ret + tokPar + this.getEmptyLine();
        ret = ret + tokPar + this.getBottomLine();
        return ret;
    }

    public String getFullBox() {
        return this.getFullBox("");
    }

    public PresentableBox(String aTitle, String aSubTitle, int aBoxSize) {
        this.title = aTitle == null ? "" : aTitle.trim();
        this.subTitle = aSubTitle == null ? "" : aSubTitle.trim();
        int maxTextSize = Math.max(this.title.length(), this.subTitle.length());
        String encapers = ENCAP;
        int lgAddedEncap = 2 * ENCAP.length();
        this.boxSize = Math.max(aBoxSize + aBoxSize % 2, maxTextSize + 2 * lgAddedEncap);
        String transparent = "  ";
        this.bottomLine = this.topLine = PresentableBox.surroundFill(DASH, ENCAP, "--", this.boxSize);
        this.emptyLine = PresentableBox.surroundFill(SPACE, ENCAP, "  ", this.boxSize);
        this.titleLine = PresentableBox.surroundFill(SPACE, ENCAP, this.title, this.boxSize);
        this.subTitleLine = PresentableBox.surroundFill(SPACE, ENCAP, this.subTitle, this.boxSize);
    }

    private static String surroundFill(String filler, String startEnd, String center, int totalSize) {
        int totFillers = totalSize - center.length() - startEnd.length();
        String filler1 = PresentableBox.getFiller(filler).substring(0, totFillers / 2);
        String filler2 = PresentableBox.getFiller(filler).substring(0, totFillers - totFillers / 2);
        return startEnd + filler1 + center + filler2 + startEnd;
    }

    private static String getFiller(String filler) {
        if (filler == null) {
            return MANY_SPACES;
        }
        if (filler.length() == 0) {
            return MANY_SPACES;
        }
        if (filler.charAt(0) == '-') {
            return MANY_DASHES;
        }
        return MANY_SPACES;
    }
}

