/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import java.util.List;
import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.util.CommandStringBuilder;

public class ExecuteRouteServerCommand
extends AbstractServerCommand {
    public ExecuteRouteServerCommand() {
    }

    public ExecuteRouteServerCommand(String interpreter, String name, String context, String version, List<String> jobContextParam, String jobResultDestDir, Integer timeout, boolean applyContextToChildren) {
        this();
        this.setValue("INTERPRETER", interpreter);
        this.setValue("routeName", name);
        this.setValue("JOB_VERSION", version);
        this.setValue("JOB_CONTEXT", context);
        this.setValue("JOB_CONTEXT_PARAM", jobContextParam);
        this.setValue("JOB_RESULT_DESTINATION_DIR", jobResultDestDir);
        this.setValue("JOB_TIMEOUT", timeout);
        this.setValue("JOB_APPLY_CONTEXT_TO_CHILDREN", applyContextToChildren);
    }

    @Override
    public String writeToString() {
        boolean applayContext;
        Integer timeout;
        String jobResultDestDir;
        List<String> jobContextParam;
        String jobContext;
        String version;
        String interPreter;
        CommandStringBuilder builder = new CommandStringBuilder("executeRoute");
        String jobName = this.getJobName();
        if (jobName != null) {
            builder.addArgument(jobName);
        }
        if ((interPreter = this.getInterPreter()) != null) {
            builder.addOptionWithArgument("i", interPreter);
        }
        if ((version = this.getVersion()) != null) {
            builder.addOptionWithArgument("jv", version);
        }
        if ((jobContext = this.getJobConntext()) != null) {
            builder.addOptionWithArgument("jc", jobContext);
        }
        if ((jobContextParam = this.getJobContextParam()) != null && jobContextParam.size() > 0) {
            builder.addOption("jcp");
            for (String contextParam : jobContextParam) {
                builder.addArgument(contextParam);
            }
        }
        if ((jobResultDestDir = this.getjobResultDestDir()) != null) {
            builder.addOptionWithArgument("jrdd", jobResultDestDir);
        }
        if ((timeout = this.getTimeOut()) != null) {
            builder.addOptionWithArgument("jt", timeout.toString());
        }
        if (applayContext = this.isApplyContextToChildren()) {
            builder.addOption("jactc");
        }
        return builder.toString();
    }

    public String getInterPreter() {
        return (String)this.getValue("INTERPRETER");
    }

    public String getJobName() {
        return (String)this.getValue("routeName");
    }

    public String getVersion() {
        return (String)this.getValue("JOB_VERSION");
    }

    public String getJobConntext() {
        return (String)this.getValue("JOB_CONTEXT");
    }

    public List<String> getJobContextParam() {
        return (List)this.getValue("JOB_CONTEXT_PARAM");
    }

    public String getjobResultDestDir() {
        return (String)this.getValue("JOB_RESULT_DESTINATION_DIR");
    }

    public Integer getTimeOut() {
        return (Integer)this.getValue("JOB_TIMEOUT");
    }

    public boolean isApplyContextToChildren() {
        return this.getBooleanValue("JOB_APPLY_CONTEXT_TO_CHILDREN");
    }
}

