/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client.command.extension;

import org.talend.commandline.client.command.extension.AbstractServerCommand;
import org.talend.commandline.client.constant.extension.IPaasCommandDefine;
import org.talend.commandline.client.util.CommandStringBuilder;

public class IPaasPublishServerCommand
extends AbstractServerCommand
implements IPaasCommandDefine {
    public String getUserName() {
        return (String)this.getValue("USER_NAME");
    }

    public String getPassword() {
        return (String)this.getValue("PASSWORD");
    }

    public String getURL() {
        return (String)this.getValue("INVENTORY_URL");
    }

    public String getItemName() {
        return (String)this.getValue("ITEM_NAME");
    }

    public String getPublishVersion() {
        return (String)this.getValue("PUBLISH_VERSION");
    }

    public String getWorkspace() {
        return (String)this.getValue("WORKSPACE");
    }

    public boolean isExportSources() {
        return this.getBooleanValue("EXPORT_SOURCES");
    }

    public boolean isExportImage() {
        return this.getBooleanValue("EXPORT_IMAGE");
    }

    public boolean isNotAccelerate() {
        return this.getBooleanValue("NOT_ACCELERATE");
    }

    @Override
    public String writeToString() {
        String workspaceId;
        String publishVersion;
        String url;
        String password;
        String userName;
        CommandStringBuilder builder = new CommandStringBuilder("publishAction");
        String itemName = this.getItemName();
        if (itemName != null) {
            builder.addArgument(itemName);
        }
        if ((userName = this.getUserName()) != null) {
            builder.addOptionWithArgument("u", userName);
        }
        if ((password = this.getPassword()) != null) {
            builder.addOptionWithArgument("p", password);
        }
        if ((url = this.getURL()) != null) {
            builder.addOptionWithArgument("r", url);
        }
        if ((publishVersion = this.getPublishVersion()) != null) {
            builder.addOptionWithArgument("v", publishVersion);
        }
        if ((workspaceId = this.getWorkspace()) != null) {
            builder.addOptionWithArgument("w", workspaceId);
        }
        if (this.isExportSources()) {
            builder.addOption("s");
        }
        if (this.isExportImage()) {
            builder.addOption("i");
        }
        if (this.isNotAccelerate()) {
            builder.addOption("na");
        }
        return builder.toString();
    }
}

