/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.Authenticator;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.talend.ci.util.Utils;
import org.talend.ci.util.VersionUtils;
import org.talend.commandline.client.CommandLineJavaClient;
import org.talend.commandline.client.command.CommandStatus;
import org.talend.commandline.client.command.CreateProjectCommand;
import org.talend.commandline.client.command.IJavaCommand;
import org.talend.commandline.client.command.InitLocalCommand;
import org.talend.commandline.client.command.LogoffProjectCommand;
import org.talend.commandline.client.command.LogonProjectCommand;
import org.talend.commandline.client.command.extension.BuildItemSourcesCommand;
import org.talend.jobbuilder.Run;
import org.talend.jobbuilder.RunInstall;
import org.talend.jobbuilder.RunScript;
import org.talend.jobbuilder.RunUpgrade;
import org.talend.jobbuilder.model.EMavenRepo;
import org.talend.jobbuilder.model.ItemInfo;
import org.talend.jobbuilder.model.TalendProject;
import org.talend.utils.io.FilesUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JobBuilder
extends AbstractMojo {
    private static final String TALEND_PROJECT_NAME = "talend.project.name";
    private static final String TALEND_JOB_ID = "talend.job.id";
    private static final String TALEND_JOB_VERSION = "talend.job.version";
    protected final String SERVER_GENERATE = "server";
    protected final String LOCAL_GENERATE = "local";
    @Parameter(required=false, property="generation.type", defaultValue="server")
    protected String generationType;
    @Parameter(required=false, property="ci.builder.skip", defaultValue="false")
    private String skip;
    @Parameter(required=false, property="commandline.skip", defaultValue="false")
    private String skipCommandline;
    @Parameter(required=false, property="commandline.user", defaultValue="jobbuilder@talend.com")
    protected String commandlineUser;
    @Parameter(required=false, property="commandline.host", defaultValue="localhost")
    protected String commandlineHost;
    @Parameter(required=false, property="commandline.port", defaultValue="8002")
    protected int commandlinePort;
    @Parameter(required=false, defaultValue="${user.dir}", readonly=true)
    private String userDir;
    private String pomDir;
    @Deprecated
    @Parameter(required=false, property="updatesite.path")
    protected String updatesitePath;
    @Deprecated
    @Parameter(required=false, property="talend.studio.p2.base")
    protected String p2Origin;
    @Parameter(required=false, property="talend.studio.p2.update")
    public String p2Update;
    @Parameter(required=false, property="patch.path")
    protected String[] patchPath;
    @Parameter(required=false, property="patch.remote.user")
    protected String patchUser;
    @Parameter(required=false, property="patch.remote.password")
    protected String patchPassword;
    @Parameter(required=false, property="target.os")
    protected String targetOs;
    @Deprecated
    @Parameter(required=false, property="forceUpdate")
    protected boolean forceUpdate;
    @Parameter(required=false, property="license.path")
    protected String licensePath;
    @Parameter(required=false, property="license.remote.user")
    protected String licenseUser;
    @Parameter(required=false, property="license.remote.password")
    protected String licensePassword;
    @Parameter(required=false, property="product.path", defaultValue="${user.home}/.installation/.commandline_8")
    protected String productPath;
    @Parameter(required=false, property="installer.clean")
    protected boolean installerClean;
    @Parameter(required=false, property="talend.project.branch", defaultValue="")
    private String branchName;
    @Parameter(required=false, property="components.nexus.url")
    protected String compNexusUrl;
    @Parameter(required=false, property="components.nexus.repository")
    protected String compNexusRepository;
    @Parameter(required=false, property="components.nexus.repository.snapshot")
    protected String compNexusSnapshotRepository;
    @Parameter(required=false, property="components.nexus.user")
    protected String compNexusUser;
    @Parameter(required=false, property="components.nexus.password")
    protected String compNexusPassword;
    @Parameter(required=false, property="components.artifact.repo.token")
    protected String compNexusToken;
    @Parameter(required=false, property="p2Installer.path", defaultValue="${user.home}/.installation/.p2Installer_8")
    protected String p2InstallerPath;
    @Parameter(required=false, property="eclipse.keyring")
    protected String keyRingPath;
    @Parameter(required=false, property="eclipse.password")
    protected String masterKeyPath;
    @Deprecated
    @Parameter(required=false, property="talend.studio.p2.base.user")
    public String baseP2User;
    @Deprecated
    @Parameter(required=false, property="talend.studio.p2.base.pwd")
    public String baseP2Pwd;
    @Parameter(required=false, property="talend.studio.p2.update.user")
    public String updateP2User;
    @Parameter(required=false, property="talend.studio.p2.update.pwd")
    public String updateP2Pwd;
    @Parameter(required=false, property="debug")
    protected boolean debug;
    @Parameter(required=false, property="eclipse.debug")
    protected String eclipseDebug;
    @Parameter(required=false, property="commandline.proxy.usemvncmd", defaultValue="true")
    protected boolean useProxyFromMvnCmd;
    @Parameter(required=false, property="commandline.proxy.defaultsystem", defaultValue="true")
    protected boolean defaultEnableSystemProxy;
    @Parameter(required=false, property="jvm.arguments", defaultValue="-ea -Xms512m -Dfile.encoding=UTF-8 -Xmx2000m -XX:MinHeapFreeRatio=10 -XX:MaxHeapFreeRatio=20 -XX:+HeapDumpOnOutOfMemoryError -XX:+UseStringDeduplication")
    protected String jvmArguments;
    @Parameter(defaultValue="${session}")
    public MavenSession session;
    @Component(role=SecDispatcher.class, hint="mng-4384")
    public SecDispatcher secDispatcher;
    @Parameter(required=false, property="maven.repository", defaultValue="global")
    protected String repo;
    protected String commandlineWorkspace;
    protected String buildProject;
    protected String launcherPath;
    private String projectName;
    protected List<TalendProject> talendProjectList = new ArrayList<TalendProject>();
    private Map<String, List<ItemInfo>> projectMap = new HashMap<String, List<ItemInfo>>();
    protected Map<String, String> preparedPatchesMap;
    public static final Set<String> EXCLUDE_PROPERTIES = new HashSet<String>();

    protected void initializeProjectList() throws MojoExecutionException {
        this.getLog().info((CharSequence)("List projects from:" + this.commandlineWorkspace));
        File workspace = new File(this.commandlineWorkspace);
        if (workspace == null || !workspace.exists()) {
            throw new MojoExecutionException("Invalid or not existing workspace directory");
        }
        File[] files = workspace.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (File file : files) {
            File talendProjects;
            if (!file.isDirectory() || (talendProjects = this.findTalendProjects(file)) != null) continue;
            this.getLog().info((CharSequence)("  Not valid folder (no talend project) in:" + file.getName()));
        }
        if (this.talendProjectList.isEmpty()) {
            RuntimeException e = new RuntimeException("No valid talend projects");
            this.getLog().warn((Throwable)e);
        }
    }

    protected void checkCompatiable() throws MojoFailureException, MojoExecutionException {
        VersionUtils instance = VersionUtils.create(this.getLog());
        File projFile = new File(this.buildProject);
        String[] projectVersion = instance.getProjectVersion(projFile);
        HashMap<String, String[]> projectVersions = new HashMap<String, String[]>();
        projectVersions.put(projFile.getName(), projectVersion);
        instance.checkCompatiable(this, projectVersions, this.productPath);
    }

    private File findTalendProjects(File parentFolder) {
        File talendProjectFile = new File(parentFolder, "talend.project");
        if (talendProjectFile.isFile() && talendProjectFile.exists()) {
            this.talendProjectList.add(new TalendProject(parentFolder, null));
            this.getLog().info((CharSequence)("  Found project:" + VersionUtils.create(this.getLog()).buildMessage(parentFolder)));
            return talendProjectFile;
        }
        return null;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Optional<String>> replacedProxies = null;
        Authenticator defaultAuthenticator = Utils.getDefaultAuthenticator(this.getLog());
        try {
            replacedProxies = this.completingSystemProxiesFromMavenSettings();
            Authenticator.setDefault(Utils.createProxyAuthenticator(defaultAuthenticator, this.getLog()));
            this.exec();
        }
        finally {
            this.restoreSystemProxies(replacedProxies);
            Authenticator.setDefault(defaultAuthenticator);
        }
    }

    private void restoreSystemProxies(Map<String, Optional<String>> replacedProxies) {
        if (replacedProxies == null) {
            return;
        }
        replacedProxies.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Optional value = (Optional)entry.getValue();
            String v = value.orElse(null);
            this.updateSystemProperty(key, v);
        });
    }

    private Map<String, Optional<String>> completingSystemProxiesFromMavenSettings() {
        if (!this.useProxyFromMvnCmd) {
            return null;
        }
        List proxies = this.session.getSettings().getProxies();
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        HashMap<String, Optional<String>> completedProxies = new HashMap<String, Optional<String>>();
        for (Proxy proxy : proxies) {
            String proxyHost;
            if (!proxy.isActive()) continue;
            String protocol = proxy.getProtocol();
            if (StringUtils.equalsIgnoreCase(protocol, "http")) {
                proxyHost = System.getProperty("http.proxyHost");
                if (!StringUtils.isBlank(proxyHost)) continue;
                completedProxies.put("http.proxyHost", Optional.ofNullable(this.updateSystemProperty("http.proxyHost", proxy.getHost())));
                completedProxies.put("http.proxyPort", Optional.ofNullable(this.updateSystemProperty("http.proxyPort", "" + proxy.getPort())));
                completedProxies.put("http.proxyUser", Optional.ofNullable(this.updateSystemProperty("http.proxyUser", proxy.getUsername())));
                completedProxies.put("http.proxyPassword", Optional.ofNullable(this.updateSystemProperty("http.proxyPassword", proxy.getPassword())));
                completedProxies.put("http.nonProxyHosts", Optional.ofNullable(this.updateSystemProperty("http.nonProxyHosts", proxy.getNonProxyHosts())));
                continue;
            }
            if (StringUtils.equalsIgnoreCase(protocol, "https")) {
                proxyHost = System.getProperty("https.proxyHost");
                if (!StringUtils.isBlank(proxyHost)) continue;
                completedProxies.put("https.proxyHost", Optional.ofNullable(this.updateSystemProperty("https.proxyHost", proxy.getHost())));
                completedProxies.put("https.proxyPort", Optional.ofNullable(this.updateSystemProperty("https.proxyPort", "" + proxy.getPort())));
                completedProxies.put("https.proxyUser", Optional.ofNullable(this.updateSystemProperty("https.proxyUser", proxy.getUsername())));
                completedProxies.put("https.proxyPassword", Optional.ofNullable(this.updateSystemProperty("https.proxyPassword", proxy.getPassword())));
                completedProxies.put("https.nonProxyHosts", Optional.ofNullable(this.updateSystemProperty("https.nonProxyHosts", proxy.getNonProxyHosts())));
                continue;
            }
            if (StringUtils.equalsIgnoreCase(protocol, "socks")) {
                proxyHost = System.getProperty("socksProxyHost");
                String proxyPort = System.getProperty("socksProxyPort");
                if (!StringUtils.isBlank(proxyHost) || !StringUtils.isBlank(proxyPort)) continue;
                completedProxies.put("socksProxyHost", Optional.ofNullable(this.updateSystemProperty("socksProxyHost", proxy.getHost())));
                completedProxies.put("socksProxyPort", Optional.ofNullable(this.updateSystemProperty("socksProxyPort", "" + proxy.getPort())));
                completedProxies.put("socksProxyUser", Optional.ofNullable(this.updateSystemProperty("socksProxyUser", proxy.getUsername())));
                completedProxies.put("socksProxyPassword", Optional.ofNullable(this.updateSystemProperty("socksProxyPassword", proxy.getPassword())));
                continue;
            }
            this.getLog().info((CharSequence)("Unknown proxy protocol: " + protocol));
        }
        return completedProxies;
    }

    private String updateSystemProperty(String key, String value) {
        if (value == null) {
            return System.clearProperty(key);
        }
        return System.setProperty(key, value);
    }

    protected void exec() throws MojoExecutionException, MojoFailureException {
        if (Boolean.valueOf(this.skip).booleanValue()) {
            this.getLog().info((CharSequence)"Skipping ci-builder");
            return;
        }
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        if (sortedProjects.isEmpty()) {
            this.getLog().debug((CharSequence)"no projects to build");
            return;
        }
        MavenProject currentProject = this.session.getCurrentProject();
        if (currentProject.getPackaging().equals("pom") && currentProject.getProperties().getProperty(TALEND_PROJECT_NAME) == null) {
            this.getLog().debug((CharSequence)("Not a talend project pom:" + currentProject.getName()));
            return;
        }
        this.getLog().debug((CharSequence)("CurrentProject=" + currentProject.getName()));
        String jobId = currentProject.getProperties().getProperty(TALEND_JOB_ID);
        if (jobId == null) {
            this.setSkipToProject(currentProject);
        }
        List selectors = this.session.getRequest().getSelectedProjects();
        File reactorDirectory = new File(this.session.getRequest().getBaseDirectory());
        if (!selectors.isEmpty()) {
            for (MavenProject currentMavenProject : sortedProjects) {
                boolean needSkip = true;
                for (String selector : selectors) {
                    if (!this.isMatchingProject(currentMavenProject, selector, reactorDirectory)) continue;
                    needSkip = false;
                }
                if (!needSkip) continue;
                this.setSkipToProject(currentMavenProject);
            }
        }
        if (Boolean.valueOf(this.skipCommandline).booleanValue()) {
            this.getLog().info((CharSequence)"Skipping commandline calls (assuming the jobs are already generated before)");
            this.initFields();
        } else {
            if (!((MavenProject)sortedProjects.get(0)).equals((Object)currentProject)) {
                this.getLog().debug((CharSequence)"No call of commandline (not main project)");
                return;
            }
            MavenProject firstProjectNeedBuild = this.session.getTopLevelProject();
            this.pomDir = firstProjectNeedBuild.getBasedir().getAbsolutePath();
            this.getLog().debug((CharSequence)"**** START **** Prepare List to build");
            this.getLog().debug((CharSequence)("CurrentProject=" + this.session.getCurrentProject().getName()));
            this.getLog().debug((CharSequence)("firstProject=" + firstProjectNeedBuild.getName()));
            if (this.projectName == null) {
                this.projectName = firstProjectNeedBuild.getProperties().getProperty(TALEND_PROJECT_NAME);
            }
            ArrayList<MavenProject> topAndSubProjects = new ArrayList<MavenProject>();
            if (!selectors.isEmpty()) {
                for (MavenProject currentMavenProject : sortedProjects) {
                    for (String selector : selectors) {
                        if (!this.isMatchingProject(currentMavenProject, selector, reactorDirectory)) continue;
                        topAndSubProjects.add(currentMavenProject);
                        topAndSubProjects.addAll(currentMavenProject.getCollectedProjects());
                    }
                }
            } else {
                topAndSubProjects.addAll(sortedProjects);
            }
            topAndSubProjects.forEach(p -> {
                String talendProjectName = p.getProperties().getProperty(TALEND_PROJECT_NAME);
                String itemId = p.getProperties().getProperty(TALEND_JOB_ID);
                String itemVersion = p.getProperties().getProperty(TALEND_JOB_VERSION);
                if (talendProjectName != null && itemId != null && itemVersion != null) {
                    this.getLog().debug((CharSequence)("Project=" + talendProjectName + " / id=" + itemId + " / version=" + itemVersion));
                    if (!this.projectMap.containsKey(talendProjectName)) {
                        this.projectMap.put(talendProjectName, new ArrayList());
                    }
                    this.projectMap.get(talendProjectName).add(new ItemInfo(itemId, itemVersion, p.getName()));
                } else {
                    this.getLog().debug((CharSequence)("Nothing to build in=" + p.getName()));
                }
            });
            this.getLog().debug((CharSequence)"****  END  **** Prepare List to build");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"*****************************************************");
            this.initFields();
            this.initializeProjectList();
            this.checkCompatiable();
            try {
                this.setConfigToCommandline();
            }
            catch (IOException e) {
                throw new MojoFailureException("Set ci-setting info failed.", (Throwable)e);
            }
            this.installCommandline();
            if (this.generationType.equals("server")) {
                this.executeByServerCommandline();
            } else if (this.generationType.equals("local")) {
                this.executeByLocalCommandline();
            }
        }
        this.setSignerSessionInfo();
    }

    protected void installCommandline() throws MojoExecutionException, MojoFailureException {
        if (this.forceUpdate) {
            this.getLog().warn((CharSequence)"[forceUpdate] is deprecated, using [installer.clean].");
            this.installerClean = true;
        }
        try {
            this.getPreparedPatchesMap();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to prepare patch", (Throwable)e);
        }
        if (this.p2Update != null) {
            this.generationType = "local";
            Run.Result result = new RunInstall(this).run();
            if (Run.Result.SUCCESS == result) {
                new RunUpgrade(this).run();
            } else {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Skipping upgrade on existing installation...");
            }
        } else if (this.generationType.equals("local")) {
            this.setupComponentNexusProperties();
            if (this.patchPath.length > 0) {
                this.getLog().info((CharSequence)"Patch paths will be passed to commandline by -Dtalend.studio.p2.update");
            }
        }
    }

    protected void setSignerSessionInfo() throws MojoFailureException {
        Properties buildProperties = Utils.getBuildProperties(this.commandlineWorkspace);
        if (buildProperties != null) {
            this.session.getSystemProperties().setProperty("session.id", buildProperties.getProperty("session.id"));
            this.session.getSystemProperties().setProperty("license.path", buildProperties.getProperty("license.path"));
        }
    }

    protected void setConfigToCommandline() throws IOException {
        File settingFile = new File(this.commandlineWorkspace, "ci-setting.properties");
        if (!settingFile.exists()) {
            settingFile.createNewFile();
        }
        Properties properties = new Properties();
        String branchNameProp = "";
        if (StringUtils.isNotBlank(this.branchName)) {
            branchNameProp = this.branchName;
        }
        properties.put("talend.project.branch", branchNameProp);
        FileWriter fileWriter = new FileWriter(settingFile);
        properties.store(fileWriter, "Update ci-setting properties");
        ((Writer)fileWriter).close();
    }

    private void setSkipToProject(MavenProject project) {
        boolean skipAssembly = project.getActiveProfiles().stream().anyMatch(p -> p.getId().equals("signature"));
        if (skipAssembly) {
            project.getProperties().setProperty("assembly.skipAssembly", "true");
        }
        project.getProperties().setProperty("maven.install.skip", "true");
        project.getProperties().setProperty("maven.deploy.skip", "true");
        project.getProperties().setProperty("docker.skip", "true");
        project.getProperties().setProperty("cloud.publisher.skip", "true");
    }

    private boolean isMatchingProject(MavenProject project, String selector, File reactorDirectory) {
        if (selector.indexOf(58) >= 0) {
            String id = ":" + project.getArtifactId();
            if (id.equals(selector)) {
                return true;
            }
            id = project.getGroupId() + id;
            if (id.equals(selector)) {
                return true;
            }
        } else if (reactorDirectory != null) {
            File selectedProject = new File(new File(reactorDirectory, selector).toURI().normalize());
            if (selectedProject.isFile()) {
                return selectedProject.equals(project.getFile());
            }
            if (selectedProject.isDirectory()) {
                return selectedProject.equals(project.getBasedir());
            }
        }
        return false;
    }

    private void initFields() throws MojoExecutionException {
        File projectFolder = this.pomDir != null ? new File(this.pomDir) : new File(this.userDir);
        boolean foundProject = false;
        while (!foundProject && (projectFolder = projectFolder.getParentFile()) != null) {
            if (!ArrayUtils.contains(projectFolder.list(), "talend.project")) continue;
            foundProject = true;
        }
        if (foundProject && projectFolder != null) {
            this.buildProject = projectFolder.getAbsolutePath();
            File workspaceFolder = projectFolder.getParentFile();
            if (workspaceFolder != null) {
                this.commandlineWorkspace = workspaceFolder.getAbsolutePath();
                this.getLog().info((CharSequence)("Workspace found :" + this.commandlineWorkspace));
            }
        } else {
            throw new MojoExecutionException("Workspace not found based on current pom folder :" + projectFolder.getAbsolutePath());
        }
    }

    private void executeByServerCommandline() throws MojoExecutionException, MojoFailureException {
        CommandLineJavaClient client = new CommandLineJavaClient(this.commandlineHost, this.commandlinePort);
        try {
            client.connect();
        }
        catch (Exception e) {
            throw new MojoFailureException("Can't connect to Commandline server : " + client.getHostname() + " with port: " + client.getPort(), (Throwable)e);
        }
        this.addCommandAndCheck(client, new InitLocalCommand());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Creating the detected projects for Commandline workspace.");
        Map<File, File> backupFilesMap = this.backupProjectFile();
        for (TalendProject talendProject : this.talendProjectList) {
            this.addCommandAndCheck(client, new CreateProjectCommand(talendProject.getName(), "from CI Builder", "java", this.commandlineUser));
            this.getLog().info((CharSequence)("  Created project (base on existing folder): " + talendProject.getName()));
        }
        this.addCommandAndCheck(client, new LogoffProjectCommand());
        this.restoreProjectFile(backupFilesMap);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to generate sources");
        boolean mainJobOnly = this.session.getRequest().getSelectedProjects().isEmpty();
        for (TalendProject project : this.talendProjectList) {
            if (!this.projectName.equals(project.getName())) {
                this.getLog().info((CharSequence)("Nothing to generate on project (skip):" + project.getName()));
                continue;
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)" Logon project");
            this.addCommandAndCheck(client, new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            this.getLog().info((CharSequence)" Generating code...");
            for (List<ItemInfo> listItemInfo : this.projectMap.values()) {
                for (ItemInfo itemInfo : listItemInfo) {
                    this.getLog().info((CharSequence)(" Generating code for :" + itemInfo.getName()));
                    BuildItemSourcesCommand buildItem = new BuildItemSourcesCommand(itemInfo.getId(), itemInfo.getVersion(), String.valueOf(mainJobOnly));
                    this.addCommandAndCheck(client, buildItem);
                }
            }
            this.getLog().info((CharSequence)" Logoff project");
            this.addCommandAndCheck(client, new LogoffProjectCommand());
            this.getLog().info((CharSequence)" Successfully generated sources");
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Finished to generate the code");
        this.getLog().info((CharSequence)"*****************************************************");
        try {
            client.disconnect();
        }
        catch (IOException iOException) {
            this.getLog().error((Throwable)iOException);
        }
    }

    private void executeByLocalCommandline() throws MojoExecutionException, MojoFailureException {
        this.prepareLocalExcution();
        ArrayList<IJavaCommand> commands = new ArrayList<IJavaCommand>();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"*****************************************************");
        this.getLog().info((CharSequence)"Starting to generate sources");
        boolean mainJobOnly = this.session.getRequest().getSelectedProjects().isEmpty();
        commands.add(new InitLocalCommand());
        for (TalendProject project : this.talendProjectList) {
            if (!this.projectName.equals(project.getName())) {
                this.getLog().info((CharSequence)("Nothing to generate on project (skip):" + project.getName()));
                continue;
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Generating commandline script...");
            commands.add(new LogonProjectCommand(project.getName(), this.commandlineUser, null, true));
            for (List<ItemInfo> listItemInfo : this.projectMap.values()) {
                List setItemInfo = listItemInfo.stream().distinct().collect(Collectors.toList());
                for (ItemInfo iInfo : setItemInfo) {
                    this.getLog().info((CharSequence)("Prepare command to generating code for :" + iInfo.getName()));
                    BuildItemSourcesCommand buildItem = new BuildItemSourcesCommand(iInfo.getId(), iInfo.getVersion(), String.valueOf(mainJobOnly));
                    commands.add(buildItem);
                }
            }
            commands.add(new LogoffProjectCommand());
        }
        this.getLog().info((CharSequence)"Executing script...");
        this.generateScriptAndRun(commands);
        this.getLog().info((CharSequence)"Script execution finished.");
        this.getLog().info((CharSequence)"Successfully generated sources");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Finished to generate the code");
        this.getLog().info((CharSequence)"*****************************************************");
    }

    protected void prepareLocalExcution() throws MojoFailureException, MojoExecutionException {
        Map<File, File> backupFilesMap = this.backupProjectFile();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Creating the detected projects for Commandline workspace.");
        ArrayList<IJavaCommand> commands = new ArrayList<IJavaCommand>();
        commands.add(new InitLocalCommand());
        for (TalendProject project : this.talendProjectList) {
            commands.add(new CreateProjectCommand(project.getName(), "from CI Builder", "java", this.commandlineUser));
            this.getLog().info((CharSequence)(" Created project (base on existing folder): " + project.getName()));
        }
        commands.add(new LogoffProjectCommand());
        this.generateScriptAndRun(commands);
        this.restoreProjectFile(backupFilesMap);
    }

    protected Map<File, File> backupProjectFile() throws MojoFailureException {
        HashMap<File, File> backupFilesMap = new HashMap<File, File>();
        for (TalendProject project : this.talendProjectList) {
            File projectFolder = new File(this.commandlineWorkspace, project.getName());
            this.doBackup("talend.project", backupFilesMap, project, projectFolder);
            this.doBackup(".settings", backupFilesMap, project, projectFolder);
            this.doBackup("recycle_bin.index", backupFilesMap, project, projectFolder);
        }
        return backupFilesMap;
    }

    private void doBackup(String fileName, Map<File, File> backupFilesMap, TalendProject project, File projectFolder) throws MojoFailureException {
        File file = new File(projectFolder, fileName);
        if (file.exists()) {
            File backupFile = new File(projectFolder, fileName + ".bak");
            try {
                if (file.isDirectory()) {
                    FilesUtils.copyFolder(file, backupFile, false, null, null, true);
                } else {
                    FilesUtils.copyFile(file, backupFile);
                }
                backupFilesMap.put(file, backupFile);
            }
            catch (IOException e) {
                throw new MojoFailureException("Can't backup the " + fileName + " for: " + project.getName(), (Throwable)e);
            }
        }
    }

    protected void restoreProjectFile(Map<File, File> backupFilesMap) throws MojoFailureException {
        for (File file : backupFilesMap.keySet()) {
            File backupFile = backupFilesMap.get(file);
            InputStream fis = null;
            try {
                if (file.isDirectory()) {
                    FilesUtils.copyFolder(backupFile, file, true, null, null, true);
                    continue;
                }
                fis = new FileInputStream(backupFile);
                FilesUtils.copyFile(fis, file);
            }
            catch (IOException e) {
                throw new MojoFailureException("Can't revert file: " + file.getName(), (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        this.getLog().error((Throwable)e);
                    }
                }
                if (!backupFile.exists()) continue;
                if (backupFile.isDirectory()) {
                    FilesUtils.deleteFolder(backupFile, true);
                    continue;
                }
                backupFile.delete();
            }
        }
    }

    protected void addCommandAndCheck(CommandLineJavaClient client, IJavaCommand command) throws MojoExecutionException, MojoFailureException {
        try {
            CommandStatus status = client.addCommandAndWait(command);
            if (status.getException() != null) {
                throw new MojoExecutionException("Have exceptions when execute the command: " + command.toString(), status.getException());
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Fail to execute command: " + command.toString(), (Throwable)e);
        }
    }

    protected void generateScriptAndRun(List<IJavaCommand> commands) throws MojoFailureException, MojoExecutionException {
        new RunScript(commands.stream().map(IJavaCommand::writeToString).collect(Collectors.toList()), this).run();
    }

    void appendMavenRepo(List<String> commandList) throws MojoFailureException {
        if (!EMavenRepo.isValidRepo(this.repo)) {
            this.getLog().warn((CharSequence)("paramter -Dmaven.repository=" + this.repo + "is not valid. changed to default value " + EMavenRepo.Global.getName()));
            this.repo = EMavenRepo.Global.getName();
        }
        String paramNameMaven = "-Dmaven.repository=";
        commandList.add("-Dmaven.repository=" + this.repo);
    }

    void setupComponentNexusProperties() throws MojoExecutionException {
        if (StringUtils.isNotBlank(this.compNexusUrl)) {
            File configIniFile = new File(StringUtils.stripEnd(this.productPath, "/") + "/configuration/config.ini");
            this.getLog().info((CharSequence)"Setup Component Nexus properties...");
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(configIniFile);){
                properties.load(reader);
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
            properties.setProperty("components.nexus.url", this.compNexusUrl);
            properties.setProperty("components.nexus.repository", this.compNexusRepository);
            properties.setProperty("components.nexus.repository.snapshot", this.compNexusSnapshotRepository);
            if (this.compNexusUser != null) {
                properties.setProperty("components.nexus.user", this.compNexusUser);
            }
            if (this.compNexusPassword != null) {
                properties.setProperty("components.nexus.pass", this.decrypt("components.nexus.pass", this.compNexusPassword));
            }
            if (this.compNexusToken != null) {
                properties.setProperty("components.artifact.repo.token", this.decrypt("components.artifact.repo.token", this.compNexusToken));
            }
            try (FileWriter writer = new FileWriter(configIniFile);){
                properties.store(writer, "Update by Commandline Installer");
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    void appendLiteP2Patch(List<String> commandList) throws MojoFailureException {
        String paramName = "-Dtalend.studio.p2.update=";
        Iterator<String> iterator = commandList.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (next == null || !next.startsWith("-Dtalend.studio.p2.update=")) continue;
            iterator.remove();
            break;
        }
        StringBuilder repositories = new StringBuilder();
        if (this.preparedPatchesMap == null) {
            this.getLog().error((Throwable)new Exception("patch is not prepared, can't update."));
        } else {
            Collection<String> patches = this.preparedPatchesMap.values();
            if (patches != null && !patches.isEmpty()) {
                try {
                    for (String path : patches) {
                        if (0 < repositories.length()) {
                            repositories.append(",");
                        }
                        repositories.append(Utils.formatUriStr(path));
                    }
                }
                catch (URISyntaxException e1) {
                    throw new MojoFailureException(e1.getMessage());
                }
                commandList.add("-Dtalend.studio.p2.update=" + repositories.toString());
            }
        }
    }

    Map<String, String> getPreparedPatchesMap() throws Exception {
        if (this.preparedPatchesMap != null) {
            return this.preparedPatchesMap;
        }
        this.preparedPatchesMap = new HashMap<String, String>();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Resolve patches...");
        if (StringUtils.isNotBlank(this.p2Update)) {
            this.getLog().info((CharSequence)("talend.studio.p2.update: " + this.p2Update));
            if (this.patchPath != null && this.patchPath.length > 0) {
                this.getLog().warn((CharSequence)"Skip deprecated [patch.path]");
            }
            if (this.p2Update.endsWith(".zip")) {
                throw new MojoFailureException("[talend.studio.p2.update]: Compressed file as P2 repository is not supported.");
            }
            this.putToPreparedPatchPathMap(this.p2Update);
            return this.preparedPatchesMap;
        }
        if (this.patchPath != null && this.patchPath.length > 0) {
            LinkedHashSet<String> patchPaths = new LinkedHashSet<String>();
            this.getLog().warn((CharSequence)"[patch.path] is deprecated, use [talend.studio.p2.update] instead.");
            this.getLog().info((CharSequence)("patch.path: " + Arrays.toString(this.patchPath)));
            patchPaths.addAll(Arrays.asList(this.patchPath));
            for (String path : patchPaths) {
                String patchDir;
                if (path.endsWith(".zip")) {
                    File patchFile;
                    Path tmpDir;
                    if (path.startsWith("http")) {
                        String patchName = StringUtils.substringAfterLast(StringUtils.stripEnd(path, "/"), "/");
                        tmpDir = Files.createTempDirectory(patchName, new FileAttribute[0]);
                        patchFile = new File(tmpDir.toFile(), patchName);
                        this.transferFile(path, patchFile, this.getP2UserAndPwd(path));
                    } else {
                        patchFile = new File(path);
                        tmpDir = Files.createTempDirectory(StringUtils.substringAfterLast(patchFile.getName(), "."), new FileAttribute[0]);
                    }
                    patchDir = tmpDir.resolve("repository").toString();
                    FilesUtils.unzip(patchFile.getAbsolutePath(), patchDir, new String[0]);
                } else {
                    patchDir = path;
                }
                this.putToPreparedPatchPathMap(patchDir);
            }
        }
        return this.preparedPatchesMap;
    }

    private void putToPreparedPatchPathMap(String source) throws Exception {
        String path = this.resolveCompositePath(source);
        String patchPropertiesPath = StringUtils.stripEnd(path, "/") + "/patch.properties";
        Path tmpFolder = Files.createTempDirectory("patch.properties", new FileAttribute[0]);
        File tempFile = new File(tmpFolder.toFile(), "patch.properties");
        try {
            this.transferFile(patchPropertiesPath, tempFile, this.getP2UserAndPwd(source));
        }
        catch (Exception e) {
            try {
                String productFilePath = StringUtils.stripEnd(path, "/") + "/.eclipseproduct";
                Path tmpProdFolder = Files.createTempDirectory(".eclipseproduct", new FileAttribute[0]);
                File tempProdFile = new File(tmpProdFolder.toFile(), ".eclipseproduct");
                this.transferFile(productFilePath, tempProdFile, this.getP2UserAndPwd(source));
                try (BufferedReader reader = Files.newBufferedReader(tempProdFile.toPath(), StandardCharsets.UTF_8);){
                    Properties props = new Properties();
                    props.load(reader);
                    if (!StringUtils.equals("org.talend.rcp.branding.lite.ci.product", props.getProperty("id", null))) {
                        throw e;
                    }
                }
            }
            catch (Exception ex) {
                this.getLog().error((Throwable)ex);
                throw e;
            }
            return;
        }
        String version = null;
        try (BufferedReader reader = Files.newBufferedReader(tempFile.toPath(), StandardCharsets.UTF_8);){
            Properties props = new Properties();
            props.load(reader);
            version = props.getProperty("product.version", null);
        }
        if (version != null) {
            this.preparedPatchesMap.put(version, path);
        }
    }

    private String resolveCompositePath(String path) throws MojoFailureException {
        Path tmpFolder = null;
        try {
            tmpFolder = Files.createTempDirectory("compositeContent.xml", new FileAttribute[0]);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        if (tmpFolder != null) {
            String compositePath = StringUtils.stripEnd(path, "/") + "/compositeContent.xml";
            File tempFile = new File(tmpFolder.toFile(), "compositeContent.xml");
            try {
                this.transferFile(compositePath, tempFile, this.getP2UserAndPwd(path));
            }
            catch (Exception e) {
                return path;
            }
            Document document = null;
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = builder.parse(tempFile);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to parse " + compositePath, (Throwable)e);
            }
            if (document != null) {
                NodeList children = document.getElementsByTagName("child");
                if (children == null || children.getLength() < 1) {
                    throw new MojoFailureException("Wrong <child> setup of " + compositePath);
                }
                String reference = children.item(0).getAttributes().getNamedItem("location").getNodeValue();
                return StringUtils.stripEnd(path, "/") + "/" + reference;
            }
        }
        return path;
    }

    void transferFile(Object source, File target, String[] userAndPwd) throws MojoFailureException {
        this.getLog().debug((CharSequence)("Transfer from: " + source + " to: " + target.getAbsolutePath()));
        try {
            if (source instanceof String) {
                if (((String)source).startsWith("http")) {
                    URL url = new URL((String)source);
                    URLConnection conn = url.openConnection();
                    String credentials = Utils.getBasicAuthCredentials(source.toString(), userAndPwd, this.getLog());
                    if (!StringUtils.isEmpty(credentials)) {
                        conn.addRequestProperty("Authorization", "Basic " + credentials);
                    }
                    conn.setConnectTimeout(3000);
                    FilesUtils.copyFile(conn.getInputStream(), target);
                } else {
                    FilesUtils.copyFile(new File((String)source), target);
                }
            } else if (source instanceof URL) {
                FilesUtils.copyFile(((URL)source).openStream(), target);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Transfer " + source + " failed", (Throwable)e);
        }
    }

    public String decrypt(String key, String password) throws MojoExecutionException {
        try {
            return this.secDispatcher.decrypt(password);
        }
        catch (SecDispatcherException e) {
            this.getLog().error((CharSequence)("Decrypt password " + key + " failed:"), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public String[] getP2UserAndPwd(String uri) throws MojoExecutionException {
        if (StringUtils.startsWith(uri, this.p2Update) || JobBuilder.contains(this.patchPath, uri)) {
            if (!StringUtils.isEmpty(this.updateP2User) && !StringUtils.isEmpty(this.updateP2Pwd)) {
                return new String[]{this.updateP2User, this.decrypt("talend.studio.p2.update.pwd", this.updateP2Pwd)};
            }
            if (!StringUtils.isEmpty(this.patchUser) && !StringUtils.isEmpty(this.patchPassword)) {
                return new String[]{this.patchUser, this.decrypt("patch.remote.password", this.patchPassword)};
            }
        }
        if (StringUtils.startsWith(uri, this.licensePath) && !StringUtils.isEmpty(this.licenseUser) && !StringUtils.isEmpty(this.licensePassword)) {
            return new String[]{this.licenseUser, this.decrypt("patch.remote.password", this.licensePassword)};
        }
        return null;
    }

    public String getOneP2UpdateUrl() {
        if (!StringUtils.isEmpty(this.p2Update)) {
            return this.p2Update;
        }
        if (this.patchPath != null && this.patchPath.length > 1 && StringUtils.isEmpty(this.patchPath[0])) {
            return this.patchPath[0];
        }
        return null;
    }

    private static boolean contains(String[] patches, String uri) {
        if (patches == null) {
            return false;
        }
        Optional<String> find = Stream.of(patches).filter(e -> StringUtils.startsWith(uri, e)).findFirst();
        return find.isPresent();
    }

    static {
        EXCLUDE_PROPERTIES.add("talend.studio.p2.base.user");
        EXCLUDE_PROPERTIES.add("talend.studio.p2.base.pwd");
        EXCLUDE_PROPERTIES.add("talend.studio.p2.update.user");
        EXCLUDE_PROPERTIES.add("talend.studio.p2.update.pwd");
    }
}

