/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.talend.ci.util.Utils;
import org.talend.commandline.client.command.CommandStatus;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.Run;
import org.talend.jobbuilder.ScriptExecutor;
import org.talend.jobbuilder.model.CommandStatus;
import org.talend.jobbuilder.model.Constants;
import org.talend.jobbuilder.model.ERuntimeError;

class RunScript
extends Run {
    private File scriptFile;
    private File statusFile;
    private List<String> scriptCommands;

    RunScript(List<String> scriptCommands, JobBuilder mojo) {
        super(mojo);
        this.scriptCommands = scriptCommands;
    }

    @Override
    Run.Result doRun() throws MojoFailureException, MojoExecutionException {
        this.initLogFile();
        this.resetStatusFile();
        this.generateScriptFile(this.scriptCommands);
        this.waitForRun();
        return Run.Result.SUCCESS;
    }

    @Override
    List<ERuntimeError> getErrorsToCheck() {
        return ERuntimeError.getErrorsForScriptRun();
    }

    @Override
    String getApplication() {
        return "org.talend.commandline.CommandLine";
    }

    @Override
    List<String> getExecutionCommand() throws MojoFailureException {
        List<String> commandList = super.getExecutionCommand();
        commandList.add("scriptFile");
        commandList.add(this.scriptFile.getName());
        return commandList;
    }

    private void waitForRun() throws MojoFailureException {
        Run.RuntimeExecutor executor = new Run.RuntimeExecutor(this);
        FutureTask<Exception> futureTask = new FutureTask<Exception>(new Callable<Exception>(){

            @Override
            public Exception call() {
                try {
                    RunScript.this.checkExecution();
                }
                catch (Exception e) {
                    return e;
                }
                return null;
            }
        });
        new Thread(futureTask).start();
        executor.exec();
        while (!this.commandExit) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.error((Throwable)e);
            }
            Properties properties = Utils.getBuildProperties(this.mojo.commandlineWorkspace);
            boolean doclean = false;
            if (Boolean.valueOf(properties.getProperty("doclean", Boolean.FALSE.toString())).booleanValue()) {
                doclean = true;
                properties.setProperty("doclean", Boolean.FALSE.toString());
                Utils.storeBuildProperties(this.mojo.commandlineWorkspace, properties);
            }
            boolean talendCleanM2 = false;
            if (Boolean.valueOf(properties.getProperty("talendCleanM2", Boolean.FALSE.toString())).booleanValue()) {
                talendCleanM2 = true;
                properties.setProperty("talendCleanM2", Boolean.FALSE.toString());
                Utils.storeBuildProperties(this.mojo.commandlineWorkspace, properties);
            }
            if (!Boolean.valueOf(properties.getProperty("restart", Boolean.FALSE.toString())).booleanValue()) continue;
            properties.setProperty("restart", Boolean.FALSE.toString());
            Utils.storeBuildProperties(this.mojo.commandlineWorkspace, properties);
            this.logger.info((CharSequence)("Restarting commandline..." + (doclean ? " with -clean " : "")));
            if (doclean && !executor.getCommand().contains("-clean")) {
                executor.getCommand().add("-clean");
            }
            if (talendCleanM2 && !executor.getCommand().contains("-talendCleanM2")) {
                executor.getCommand().add("-talendCleanM2");
                executor.getCommand().add("true");
            }
            executor.exec();
        }
        try {
            Exception e = futureTask.get();
            if (e != null) {
                throw new MojoFailureException(e.fillInStackTrace().getMessage());
            }
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage());
        }
    }

    private void checkExecution() throws MojoFailureException, MojoExecutionException {
        List<String> cmds = this.loadScript();
        this.commandExit = false;
        while (true) {
            List<CommandStatus> statusList = this.loadStatusFromFile();
            for (CommandStatus status : statusList) {
                if (status == null || !CommandStatus.CommandStatusLevel.FAILED.name().equals(status.getLevel())) continue;
                MojoExecutionException e = new MojoExecutionException("Failed to execute [" + status.getCommandName() + "], check ci-builder.log for more details");
                this.logger.error((Throwable)e);
                this.commandExit = true;
                throw e;
            }
            if (statusList.size() == cmds.size()) {
                this.commandExit = true;
            } else {
                for (int i = 0; i < cmds.size(); ++i) {
                    String cmd;
                    String cmdName;
                    if (statusList.size() <= i || StringUtils.containsIgnoreCase(cmdName = statusList.get(i).getCommandName(), cmd = cmds.get(i).split(" ")[0].trim())) continue;
                    MojoExecutionException e = new MojoExecutionException("Failed to execute [" + cmds.get(i) + "], check ci-builder.log for more details");
                    this.logger.error((Throwable)e);
                    this.commandExit = true;
                    throw e;
                }
            }
            if (this.commandExit) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private void generateScriptFile(List<String> commands) throws MojoFailureException {
        try {
            if (this.scriptFile == null) {
                this.scriptFile = File.createTempFile("script_command_", ".txt");
            }
            StringBuilder commandsBuilder = new StringBuilder();
            commands.forEach(command -> commandsBuilder.append((String)command).append(Constants.LINE));
            if (commandsBuilder.length() > 0) {
                try (FileWriter writer = new FileWriter(this.scriptFile);){
                    writer.write(commandsBuilder.toString());
                }
            }
            if (this.mojo instanceof ScriptExecutor) {
                this.logger.info((CharSequence)("generateScriptFile, generated new script file: " + this.scriptFile));
                this.logger.info((CharSequence)("generateScriptFile, commands: " + Constants.LINE + commandsBuilder.toString()));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to generate script command file.", (Throwable)e);
        }
    }

    private List<String> loadScript() throws MojoFailureException {
        ArrayList<String> cmds = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(this.scriptFile));){
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                cmds.add(line);
            }
            this.logger.info((CharSequence)("loadScript, loaded temp command script file: " + this.scriptFile));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to load user command script file", (Throwable)e);
        }
        return cmds;
    }

    private void resetStatusFile() throws MojoFailureException {
        try {
            this.statusFile = new File(this.mojo.commandlineWorkspace + "/status.log");
            if (this.statusFile.exists()) {
                this.statusFile.delete();
            }
            this.statusFile.createNewFile();
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to reset status file.", (Throwable)e);
        }
    }

    private List<CommandStatus> loadStatusFromFile() throws MojoFailureException {
        ArrayList<CommandStatus> statusList = new ArrayList<CommandStatus>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.statusFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                statusList.add(this.parseStatus(line));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to load status from file.", (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
        return statusList;
    }

    private CommandStatus parseStatus(String line) {
        CommandStatus status = new CommandStatus();
        String[] lines1 = line.split(":");
        if (lines1 != null && lines1.length > 1) {
            status.setId(Integer.valueOf(lines1[0]));
            String[] lines2 = lines1[1].split(" ");
            if (lines1 != null && lines1.length > 1) {
                status.setLevel(lines2[0]);
                status.setCommandName(lines2[1]);
            }
        }
        return status;
    }
}

