/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.files;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.files.FileDirCleanerFilter;

public class FileDirCleaner {
    private static Logger log = LoggerFactory.getLogger(FileDirCleaner.class);
    private long currentTime;
    private CleanResult cleanResult;
    private String filesRegExpPattern;
    private String directoriesRegExpPattern;
    private int maxEntriesByDirectoryAndByType;
    private long maxDurationBeforeCleaning;
    private boolean cleanDirectories;
    private boolean cleanFiles;
    private boolean recursively;
    private boolean doAction = false;
    private FileDirCleanerFilter filter;
    final Comparator<File> datComparatorFiles = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            long compareResult = o1.lastModified() - o2.lastModified();
            if (compareResult == 0L) {
                return 0;
            }
            return (int)(compareResult / Math.abs(compareResult));
        }
    };

    public FileDirCleaner(boolean doAction, int maxEntriesByDirectoryAndByType, long maxDurationBeforeCleaning) {
        this(doAction, SCAN_STRATEGY.FILES, maxEntriesByDirectoryAndByType, maxDurationBeforeCleaning);
    }

    public FileDirCleaner(boolean doAction, SCAN_STRATEGY strategy, int maxEntriesByDirectory, long cleanAfterThisDuration) {
        this.doAction = doAction;
        this.maxEntriesByDirectoryAndByType = maxEntriesByDirectory;
        this.maxDurationBeforeCleaning = cleanAfterThisDuration;
        this.cleanDirectories = strategy.isCleanDirectories();
        this.cleanFiles = strategy.isCleanFiles();
        this.recursively = strategy.isRecursively();
    }

    public FileDirCleaner(boolean doAction, SCAN_STRATEGY strategy, int maxEntriesByDirectory, long cleanAfterThisDuration, boolean isCleanLibs) {
        this.doAction = doAction;
        this.maxEntriesByDirectoryAndByType = maxEntriesByDirectory;
        this.maxDurationBeforeCleaning = cleanAfterThisDuration;
        this.cleanDirectories = strategy.isCleanDirectories();
        this.cleanFiles = strategy.isCleanFiles();
        this.recursively = strategy.isRecursively();
    }

    public int clean(String pathDir) {
        return this.clean(pathDir, null, null);
    }

    public int clean(String pathDir, String filesRegExpPattern) {
        return this.clean(pathDir, filesRegExpPattern, null);
    }

    public int clean(String pathDir, String filesRegExpPattern, String directoriesRegExpPattern) {
        return this.clean(pathDir, filesRegExpPattern, directoriesRegExpPattern, null);
    }

    public int clean(String pathDir, String filesRegExpPattern, String directoriesRegExpPattern, FileDirCleanerFilter filter) {
        if (pathDir == null) {
            throw new IllegalArgumentException("pathFolder can't be null");
        }
        this.cleanResult = new CleanResult();
        this.directoriesRegExpPattern = directoriesRegExpPattern;
        this.filesRegExpPattern = filesRegExpPattern;
        this.currentTime = System.currentTimeMillis();
        this.filter = filter;
        File dir = new File(pathDir);
        if (dir.isDirectory()) {
            this.cleanFilesDirRecursively(dir, true);
        }
        return this.cleanResult.deletedEntries;
    }

    public void cleanFilesDirRecursively(File dir, boolean isRootDirectory) {
        try {
            File[] listFilesDirs = dir.listFiles();
            Arrays.sort(listFilesDirs, this.datComparatorFiles);
            int countMatchingDirs = 0;
            int countMatchingFiles = 0;
            int levelDeletedDir = 0;
            int levelDeletedFile = 0;
            for (File fileDirJob : listFilesDirs) {
                boolean isDirectory = fileDirJob.isDirectory();
                boolean fileMatches = false;
                boolean dirMatches = false;
                String fileDirName = fileDirJob.getName();
                if (isDirectory) {
                    dirMatches = this.directoriesRegExpPattern == null || fileDirName.matches(this.directoriesRegExpPattern);
                } else {
                    boolean bl = fileMatches = this.filesRegExpPattern == null || fileDirName.matches(this.filesRegExpPattern);
                }
                if (isDirectory && dirMatches) {
                    ++countMatchingDirs;
                    continue;
                }
                if (isDirectory || !fileMatches) continue;
                ++countMatchingFiles;
            }
            boolean parentDirMatches = this.directoriesRegExpPattern == null || dir.getName().matches(this.directoriesRegExpPattern);
            for (File fileDirJob : listFilesDirs) {
                String fileDirName = fileDirJob.getName();
                boolean fileMatches = false;
                boolean dirMatches = false;
                boolean isDirectory = fileDirJob.isDirectory();
                boolean tooManyDirs = (isRootDirectory || !isRootDirectory && this.recursively) && isDirectory && this.maxEntriesByDirectoryAndByType > 0 && countMatchingDirs - levelDeletedDir > this.maxEntriesByDirectoryAndByType;
                boolean tooManyFiles = !isDirectory && this.maxEntriesByDirectoryAndByType > 0 && countMatchingFiles - levelDeletedFile > this.maxEntriesByDirectoryAndByType;
                boolean timeExceeded = this.maxDurationBeforeCleaning > 0L && this.currentTime - fileDirJob.lastModified() > this.maxDurationBeforeCleaning * 1000L;
                try {
                    if (timeExceeded || tooManyDirs || tooManyFiles) {
                        String sep;
                        StringBuilder reason;
                        if (isDirectory) {
                            dirMatches = this.directoriesRegExpPattern == null || fileDirName.matches(this.directoriesRegExpPattern);
                        } else {
                            boolean bl = fileMatches = this.filesRegExpPattern == null || fileDirName.matches(this.filesRegExpPattern);
                        }
                        if (isDirectory) {
                            if (this.cleanDirectories && dirMatches) {
                                if (!this.checkFilter(fileDirJob)) continue;
                                if (this.doAction) {
                                    this.deleteDirectory(fileDirJob);
                                    if (log.isDebugEnabled()) {
                                        log.debug("Deleted directory: " + fileDirJob);
                                    }
                                } else {
                                    reason = new StringBuilder();
                                    sep = "";
                                    if (timeExceeded) {
                                        reason.append("timeExceeded");
                                        sep = ", ";
                                    }
                                    if (tooManyDirs) {
                                        reason.append(sep + "tooManyDirs");
                                    }
                                    log.debug("'doAction' has to be true to remove recursively the directory (" + reason.toString() + "): " + fileDirJob);
                                }
                                ++this.cleanResult.deletedEntries;
                                ++levelDeletedDir;
                                continue;
                            }
                            if (!this.recursively) continue;
                            this.cleanFilesDirRecursively(fileDirJob, false);
                            continue;
                        }
                        if (!this.cleanFiles || !fileMatches || !parentDirMatches || !this.checkFilter(fileDirJob)) continue;
                        if (this.doAction) {
                            FileUtils.forceDelete(fileDirJob);
                            if (log.isDebugEnabled()) {
                                log.debug("Deleted file: " + fileDirJob);
                            }
                        } else {
                            reason = new StringBuilder();
                            sep = "";
                            if (timeExceeded) {
                                reason.append("timeExceeded");
                                sep = ", ";
                            }
                            if (tooManyFiles) {
                                reason.append(sep + "tooManyFiles");
                            }
                            log.debug("'doAction' has to be true to remove the file (" + reason.toString() + "): " + fileDirJob);
                        }
                        ++this.cleanResult.deletedEntries;
                        ++levelDeletedFile;
                        continue;
                    }
                    if (!this.recursively || !isDirectory) continue;
                    ++levelDeletedDir;
                    this.cleanFilesDirRecursively(fileDirJob, false);
                }
                catch (Throwable t) {
                    ++this.cleanResult.countExceptions;
                    if (this.cleanResult.firstException != null) continue;
                    this.cleanResult.firstException = t;
                }
            }
            if (this.cleanResult.firstException != null && !this.cleanResult.alreadyLogged) {
                log.warn("TempDataCleaner: " + this.cleanResult.countExceptions + " error(s) have occured when trying to clean the following file or directory '" + dir.getAbsolutePath() + "', the first error is the following : ", this.cleanResult.firstException);
                this.cleanResult.alreadyLogged = true;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    private boolean checkFilter(File fileDirJob) {
        boolean isDirectory = fileDirJob.isDirectory();
        return this.filter == null || this.filter.acceptClean(fileDirJob);
    }

    private void deleteDirectory(File fileDirJob) {
        try {
            FileUtils.cleanDirectory(fileDirJob);
            FileUtils.deleteDirectory(fileDirJob);
        }
        catch (IOException e) {
            log.error("Exception while deleting directory " + fileDirJob.getAbsolutePath() + ", " + e.getMessage());
        }
    }

    static class CleanResult {
        Throwable firstException;
        int countExceptions;
        int deletedEntries;
        boolean alreadyLogged;

        CleanResult() {
        }
    }

    public static enum SCAN_STRATEGY {
        FILES(false, true, false),
        DIRECTORIES(true, false, false),
        FILES_AND_DIRECTORIES(true, true, false),
        FILES_RECURSIVELY(false, true, true),
        DIRECTORIES_RECURSIVELY(true, false, true),
        FILES_AND_DIRECTORIES_RECURSIVELY(true, true, true);

        private boolean cleanDirectories;
        private boolean cleanFiles;
        private boolean recursively;

        private SCAN_STRATEGY(boolean cleanDirectories, boolean cleanFiles, boolean recursively) {
            this.cleanFiles = cleanFiles;
            this.cleanDirectories = cleanDirectories;
            this.recursively = recursively;
        }

        public boolean isCleanDirectories() {
            return this.cleanDirectories;
        }

        public boolean isCleanFiles() {
            return this.cleanFiles;
        }

        public boolean isRecursively() {
            return this.recursively;
        }
    }
}

