/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.crypto.CipherSource;
import org.talend.daikon.crypto.CipherSources;
import org.talend.daikon.crypto.Encryption;
import org.talend.daikon.crypto.KeySource;
import org.talend.daikon.crypto.KeySources;
import org.talend.utils.security.StudioKeyName;
import org.talend.utils.security.StudioKeySource;

public class StudioEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioEncryption.class);
    private static final String ENCRYPTION_KEY_FILE_NAME = "studio.keys";
    private static final String ENCRYPTION_KEY_FILE_SYS_PROP = "encryption.keys.file";
    private static final String PREFIX_PASSWORD_M3 = "ENC:[";
    public static final String PREFIX_PASSWORD = "enc:";
    private static final Pattern REG_ENCRYPTED_DATA_SYSTEM = Pattern.compile("^enc\\:system\\.encryption\\.key\\.v\\d\\:\\p{Print}+");
    private static final Pattern REG_ENCRYPTED_DATA_MIGRATION = Pattern.compile("^enc\\:migration\\.token\\.encryption\\.key\\:\\p{Print}+");
    private static final Pattern REG_ENCRYPTED_DATA_ROUTINE = Pattern.compile("^enc\\:routine\\.encryption\\.key\\.v\\d\\:\\p{Print}+");
    private EncryptionKeyName keyName;
    private String securityProvider;
    private static final ThreadLocal<Map<StudioKeyName, String>> LOCALCACHEDALLKEYS;

    private StudioEncryption(EncryptionKeyName encryptionKeyName, String providerName) {
        this.keyName = encryptionKeyName;
        this.securityProvider = providerName;
    }

    public static StudioKeySource getKeySource(String encryptionKeyName, boolean isEncrypt) {
        Map<StudioKeyName, String> allKeys = LOCALCACHEDALLKEYS.get();
        StudioKeySource ks = StudioKeySource.key(allKeys, encryptionKeyName, isEncrypt);
        try {
            if (ks.getKey() != null) {
                return ks;
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not load encryption key: " + encryptionKeyName, (Throwable)e);
        }
        RuntimeException e = new RuntimeException("Can not load encryption key: " + encryptionKeyName);
        LOGGER.error("Can not load encryption key: " + encryptionKeyName, (Throwable)e);
        throw e;
    }

    private Encryption getEncryption(StudioKeySource ks) {
        CipherSource cs = null;
        if (this.securityProvider != null && !this.securityProvider.isEmpty()) {
            Provider p = Security.getProvider(this.securityProvider);
            cs = CipherSources.aesGcm((int)12, (int)16, (Provider)p);
        }
        if (cs == null) {
            cs = CipherSources.getDefault();
        }
        return new Encryption((KeySource)ks, cs);
    }

    public String encrypt(String src) {
        if (src == null || StudioEncryption.hasEncryptionSymbol(src)) {
            return src;
        }
        try {
            StudioKeySource ks = StudioEncryption.getKeySource(this.keyName.name, true);
            StringBuilder sb = new StringBuilder();
            sb.append(PREFIX_PASSWORD);
            sb.append(ks.getKeyName());
            sb.append(":");
            sb.append(this.getEncryption(ks).encrypt(src));
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.error("encrypt error", (Throwable)e);
            return null;
        }
    }

    public String decrypt(String src) {
        if (!StudioEncryption.hasEncryptionSymbol(src)) {
            return src;
        }
        try {
            if (src.startsWith(PREFIX_PASSWORD)) {
                String[] srcData = src.split("\\:");
                StudioKeySource ks = StudioEncryption.getKeySource(srcData[1], false);
                return this.getEncryption(ks).decrypt(srcData[2]);
            }
            StudioKeySource ks = StudioEncryption.getKeySource(this.keyName.name, false);
            return this.getEncryption(ks).decrypt(src.substring(PREFIX_PASSWORD_M3.length(), src.length() - 1));
        }
        catch (Exception e) {
            LOGGER.error("decrypt error", (Throwable)e);
            return null;
        }
    }

    public static StudioEncryption getStudioEncryption(EncryptionKeyName keyName) {
        return new StudioEncryption(keyName, null);
    }

    public static StudioEncryption getStudioBCEncryption(EncryptionKeyName keyName) {
        return new StudioEncryption(keyName, "BC");
    }

    public static boolean hasEncryptionSymbol(String input) {
        return input != null && (REG_ENCRYPTED_DATA_SYSTEM.matcher(input).matches() || REG_ENCRYPTED_DATA_MIGRATION.matcher(input).matches() || REG_ENCRYPTED_DATA_ROUTINE.matcher(input).matches() || input.startsWith(PREFIX_PASSWORD_M3) && input.endsWith("]"));
    }

    private static void updateConfig() {
        String keyPath = System.getProperty(ENCRYPTION_KEY_FILE_SYS_PROP);
        if (keyPath != null) {
            if (StudioEncryption.isStudio()) {
                File keyFile = new File(keyPath);
                if (!keyFile.exists()) {
                    Throwable throwable;
                    Properties p = new Properties();
                    try {
                        throwable = null;
                        try (InputStream fi = StudioEncryption.class.getResourceAsStream(ENCRYPTION_KEY_FILE_NAME);){
                            p.load(fi);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("load encryption keys error", (Throwable)e);
                    }
                    p.remove(EncryptionKeyName.MIGRATION.name);
                    p.remove(EncryptionKeyName.MIGRATION_TOKEN.name);
                    try {
                        throwable = null;
                        try (FileOutputStream fo = new FileOutputStream(keyFile);){
                            p.store(fo, "studio encryption keys");
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("persist encryption keys error", (Throwable)e);
                    }
                    LOGGER.info("updateConfig, studio environment, key file setup completed");
                } else {
                    try {
                        if (StudioEncryption.generateEncryptionKeys(keyFile)) {
                            LOGGER.info("Customized encryption keys generated, please synchronize key file " + keyFile + " to Administrator and Jobserver");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Generate customized encryption keys error", (Throwable)e);
                    }
                }
            } else {
                LOGGER.info("updateConfig, non studio environment, skip setup of key file");
            }
        }
    }

    private static boolean isStudio() {
        String osgiFramework = System.getProperty("osgi.framework");
        return osgiFramework != null && osgiFramework.contains("eclipse");
    }

    public static boolean generateEncryptionKeys(File keyFile) throws Exception {
        boolean propertyChanged = false;
        Properties p = new Properties();
        FileInputStream fi = new FileInputStream(keyFile);
        Object object = null;
        try {
            p.load(fi);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fi != null) {
                if (object != null) {
                    try {
                        fi.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fi.close();
                }
            }
        }
        Set<Map.Entry<Object, Object>> entries = p.entrySet();
        for (Map.Entry entry : entries) {
            try {
                StudioKeyName keyName = new StudioKeyName(entry.getKey().toString());
                if (!keyName.isSystemKey() && !keyName.isRoutineKey() || entry.getValue() != null && !entry.getValue().toString().isEmpty()) continue;
                if (keyName.isDefaultRoutineKey()) {
                    Properties defaulKeys = StudioKeySource.loadDefaultKeys();
                    entry.setValue(defaulKeys.getProperty(keyName.getKeyName()));
                    LOGGER.warn(keyName.getKeyName() + " customization is not allowed");
                    continue;
                }
                entry.setValue(Base64.getEncoder().encodeToString(KeySources.random((int)32).getKey()));
                propertyChanged = true;
                LOGGER.debug("Customized encryption key is generated for " + entry.getKey().toString());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (propertyChanged) {
            Throwable throwable = null;
            try (FileOutputStream fo = new FileOutputStream(keyFile);){
                p.store(fo, "Generated customized encryption keys");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        return propertyChanged;
    }

    static {
        StudioEncryption.updateConfig();
        LOCALCACHEDALLKEYS = ThreadLocal.withInitial(() -> StudioKeySource.loadAllKeys());
    }

    public static enum EncryptionKeyName {
        SYSTEM("system.encryption.key.v1"),
        ROUTINE("routine.encryption.key.v1"),
        MIGRATION_TOKEN("migration.token.encryption.key"),
        MIGRATION("migration.encryption.key");

        private final String name;

        private EncryptionKeyName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

