/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.crypto.KeySource;
import org.talend.utils.security.StudioKeyName;

public class StudioKeySource
implements KeySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StudioKeySource.class);
    private StudioKeyName keyName;
    private final boolean isEncrypt;
    private final Map<StudioKeyName, String> availableKeys;

    private StudioKeySource(Map<StudioKeyName, String> allKeys, StudioKeyName keyName, boolean isMaxVersion) {
        this.availableKeys = allKeys;
        this.keyName = keyName;
        this.isEncrypt = isMaxVersion;
        if (this.isEncrypt && (this.keyName.isRoutineKey() || this.keyName.isSystemKey())) {
            this.keyName = this.availableKeys.keySet().stream().filter(e -> e.isRoutineKey() == keyName.isRoutineKey() && e.isSystemKey() == keyName.isSystemKey()).max(Comparator.comparing(e -> e.getVersionNumber())).get();
        }
    }

    public static StudioKeySource key(Map<StudioKeyName, String> allKeys, String keyName, boolean isEncrypt) {
        return new StudioKeySource(allKeys, new StudioKeyName(keyName), isEncrypt);
    }

    public byte[] getKey() throws Exception {
        StudioKeyName keyToLoad = this.getKeyName();
        String key = this.availableKeys.get(keyToLoad);
        if (key == null) {
            LOGGER.warn("Can not load " + keyToLoad);
            throw new IllegalArgumentException("Invalid encryption key: " + keyToLoad);
        }
        LOGGER.debug("Loaded " + keyToLoad);
        return Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8));
    }

    public StudioKeyName getKeyName() {
        return this.keyName;
    }

    public static Properties loadDefaultKeys() {
        Properties defaultKeys = new Properties();
        try (InputStream fi = StudioKeySource.class.getResourceAsStream("studio.keys");){
            defaultKeys.load(fi);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return defaultKeys;
    }

    public static Map<StudioKeyName, String> loadAllKeys() {
        File keyFile;
        HashMap<StudioKeyName, String> retMap = new HashMap<StudioKeyName, String>();
        Properties allKeys = new Properties();
        allKeys.putAll((Map<?, ?>)StudioKeySource.loadDefaultKeys());
        Properties tempProperty = new Properties();
        String keyPath = System.getProperty("encryption.keys.file");
        if (keyPath != null && (keyFile = new File(keyPath)).exists()) {
            try (FileInputStream fi = new FileInputStream(keyFile);){
                tempProperty.load(fi);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        tempProperty.putAll((Map<?, ?>)System.getProperties());
        tempProperty.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            try {
                StudioKeyName key = new StudioKeyName(String.valueOf(k));
                if (key.isSystemKey() || key.isRoutineKey()) {
                    allKeys.put(key.getKeyName(), v);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }));
        if (LOGGER.isDebugEnabled() || LOGGER.isTraceEnabled()) {
            allKeys.stringPropertyNames().forEach(k -> LOGGER.debug(k));
        }
        allKeys.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            try {
                retMap.put(new StudioKeyName(String.valueOf(k)), String.valueOf(v));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }));
        return retMap;
    }
}

